/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base.conditions.mining;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Supplier;
import org.eclipse.passage.lic.api.LicensedProduct;
import org.eclipse.passage.lic.api.LicensingException;
import org.eclipse.passage.lic.api.ServiceInvocationResult;
import org.eclipse.passage.lic.api.conditions.ConditionMiningTarget;
import org.eclipse.passage.lic.api.conditions.ConditionPack;
import org.eclipse.passage.lic.api.conditions.mining.MinedConditions;
import org.eclipse.passage.lic.api.conditions.mining.MiningEquipment;
import org.eclipse.passage.lic.api.diagnostic.Diagnostic;
import org.eclipse.passage.lic.api.diagnostic.Trouble;
import org.eclipse.passage.lic.api.diagnostic.TroubleCode;
import org.eclipse.passage.lic.base.BaseServiceInvocationResult;
import org.eclipse.passage.lic.base.diagnostic.BaseDiagnostic;
import org.eclipse.passage.lic.base.diagnostic.code.NoLicenses;
import org.eclipse.passage.lic.base.diagnostic.code.ServiceFailedOnInfrastructureDenial;
import org.eclipse.passage.lic.base.io.PassageFileExtension;
import org.eclipse.passage.lic.internal.base.i18n.ConditionMiningMessages;

abstract class BaseLocalConditions
implements MinedConditions {
    private final ConditionMiningTarget id;
    private final MiningEquipment equipment;
    protected final PassageFileExtension scope;

    protected BaseLocalConditions(ConditionMiningTarget id, MiningEquipment equipment, PassageFileExtension scope) {
        String cls = this.getClass().getSimpleName();
        this.id = Objects.requireNonNull(id, cls + "::id");
        this.equipment = Objects.requireNonNull(equipment, cls + "::equipment");
        this.scope = Objects.requireNonNull(scope, cls + "::scope");
    }

    protected BaseLocalConditions(ConditionMiningTarget id, MiningEquipment equipment) {
        this(id, equipment, new PassageFileExtension.LicenseEncrypted());
    }

    public final ConditionMiningTarget id() {
        return this.id;
    }

    public final ServiceInvocationResult<Collection<ConditionPack>> all(LicensedProduct product) {
        try {
            Collection<Path> licenses = this.licenses(product);
            if (licenses.isEmpty()) {
                return this.noLicenses(product);
            }
            return this.equipment.tool(product, this.id).mine(licenses);
        }
        catch (LicensingException e) {
            return this.scanFailed(e);
        }
    }

    protected abstract Collection<Path> licenses(LicensedProduct var1) throws LicensingException;

    protected abstract Supplier<Path> base(LicensedProduct var1);

    private ServiceInvocationResult<Collection<ConditionPack>> noLicenses(LicensedProduct product) {
        return new BaseServiceInvocationResult<Collection<ConditionPack>>((Diagnostic)new BaseDiagnostic(Collections.emptyList(), Collections.singletonList(new Trouble((TroubleCode)new NoLicenses(), String.format(ConditionMiningMessages.getString("BaseLocalConditions.no_licenses"), this.base(product).get().toAbsolutePath())))), Collections.emptyList());
    }

    private BaseServiceInvocationResult<Collection<ConditionPack>> scanFailed(LicensingException e) {
        return new BaseServiceInvocationResult<Collection<ConditionPack>>(new Trouble((TroubleCode)new ServiceFailedOnInfrastructureDenial(), ConditionMiningMessages.getString("BaseLocalConditions.failed"), (Exception)((Object)e)));
    }
}

