/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.product;

import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;

public class GeneralInfoSection
extends PDESection {
    private FormEntry fIdEntry;
    private FormEntry fNameEntry;
    private FormEntry fVersionEntry;
    private Button fLaunchersButton;
    private Button fJreButton;
    private static int NUM_COLUMNS = 3;

    public GeneralInfoSection(PDEFormPage page, Composite parent) {
        super(page, parent, 128);
        this.createClient(this.getSection(), page.getEditor().getToolkit());
    }

    @Override
    protected void createClient(Section section, FormToolkit toolkit) {
        section.setText(PDEUIMessages.GeneralInfoSection_title);
        section.setDescription(PDEUIMessages.GeneralInfoSection_desc);
        section.setLayout((Layout)FormLayoutFactory.createClearTableWrapLayout(false, 1));
        TableWrapData data = new TableWrapData(256);
        data.colspan = 2;
        section.setLayoutData((Object)data);
        Composite client = toolkit.createComposite((Composite)section);
        client.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, NUM_COLUMNS));
        IActionBars actionBars = this.getPage().getPDEEditor().getEditorSite().getActionBars();
        this.createIdEntry(client, toolkit, actionBars);
        this.createVersionEntry(client, toolkit, actionBars);
        this.createNameEntry(client, toolkit, actionBars);
        this.createLaunchersOption(client, toolkit);
        toolkit.paintBordersFor(client);
        section.setClient((Control)client);
        this.getModel().addModelChangedListener((IModelChangedListener)this);
    }

    public void dispose() {
        IProductModel model = this.getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    private void createNameEntry(Composite client, FormToolkit toolkit, IActionBars actionBars) {
        this.fNameEntry = new FormEntry(client, toolkit, PDEUIMessages.ProductInfoSection_productname, null, false);
        this.fNameEntry.setFormEntryListener(new FormEntryAdapter(this, actionBars){

            @Override
            public void textValueChanged(FormEntry entry) {
                GeneralInfoSection.this.getProduct().setName(entry.getValue().trim());
            }
        });
        GridData gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.fNameEntry.getText().setLayoutData((Object)gd);
        this.fNameEntry.setEditable(this.isEditable());
    }

    private void createIdEntry(Composite client, FormToolkit toolkit, IActionBars actionBars) {
        this.fIdEntry = new FormEntry(client, toolkit, PDEUIMessages.ProductInfoSection_id, null, false);
        this.fIdEntry.setFormEntryListener(new FormEntryAdapter(this, actionBars){

            @Override
            public void textValueChanged(FormEntry entry) {
                GeneralInfoSection.this.getProduct().setId(entry.getValue().trim());
                GeneralInfoSection.this.validateProductId();
            }
        });
        GridData gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.fIdEntry.getText().setLayoutData((Object)gd);
        this.fIdEntry.setEditable(this.isEditable());
        this.validateProductId();
    }

    private void validateProductId() {
        String pluginId = this.getProduct().getDefiningPluginId();
        IMessageManager messageManager = this.getManagedForm().getForm().getMessageManager();
        if (pluginId != null && pluginId.equals(this.getProduct().getId())) {
            messageManager.addMessage((Object)PDEUIMessages.GeneralInfoSection_IdWarning, PDEUIMessages.GeneralInfoSection_IdWarning, null, 2);
        } else {
            messageManager.removeMessage((Object)PDEUIMessages.GeneralInfoSection_IdWarning);
        }
    }

    private void createVersionEntry(Composite client, FormToolkit toolkit, IActionBars actionBars) {
        this.fVersionEntry = new FormEntry(client, toolkit, PDEUIMessages.ProductInfoSection_version, null, false);
        this.fVersionEntry.setFormEntryListener(new FormEntryAdapter(this, actionBars){

            @Override
            public void textValueChanged(FormEntry entry) {
                GeneralInfoSection.this.getProduct().setVersion(entry.getValue().trim());
            }
        });
        GridData gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.fVersionEntry.getText().setLayoutData((Object)gd);
        this.fVersionEntry.setEditable(this.isEditable());
    }

    private void createLaunchersOption(Composite client, FormToolkit toolkit) {
        this.fLaunchersButton = toolkit.createButton(client, PDEUIMessages.ProductInfoSection_launchers, 32);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        this.fLaunchersButton.setLayoutData((Object)data);
        this.fLaunchersButton.setEnabled(this.isEditable());
        this.fLaunchersButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.getProduct().setIncludeLaunchers(this.fLaunchersButton.getSelection())));
        this.fJreButton = toolkit.createButton(client, PDEUIMessages.ProductInfoSection_jre, 32);
        this.fJreButton.setLayoutData((Object)data);
        this.fJreButton.setEnabled(this.isEditable());
        this.fJreButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.getProduct().setIncludeJre(this.fJreButton.getSelection())));
    }

    public void commit(boolean onSave) {
        this.fIdEntry.commit();
        this.fNameEntry.commit();
        this.fVersionEntry.commit();
        super.commit(onSave);
    }

    @Override
    public void cancelEdit() {
        this.fIdEntry.cancelEdit();
        this.fNameEntry.cancelEdit();
        this.fVersionEntry.cancelEdit();
        super.cancelEdit();
    }

    private IProductModel getModel() {
        return (IProductModel)this.getPage().getPDEEditor().getAggregateModel();
    }

    private IProduct getProduct() {
        return this.getModel().getProduct();
    }

    public void refresh() {
        IProduct product = this.getProduct();
        if (product.getId() != null) {
            this.fIdEntry.setValue(product.getId(), true);
        }
        if (product.getName() != null) {
            this.fNameEntry.setValue(product.getName(), true);
        }
        if (product.getVersion() != null) {
            this.fVersionEntry.setValue(product.getVersion(), true);
        }
        this.fLaunchersButton.setSelection(product.includeLaunchers());
        this.fJreButton.setSelection(product.includeJre());
        super.refresh();
    }

    @Override
    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.handleModelEventWorldChanged(e);
            return;
        }
        String prop = e.getChangedProperty();
        Object[] objects = e.getChangedObjects();
        if (prop == null || objects == null || !(objects[0] instanceof IProduct)) {
            return;
        }
        if (prop.equals("uid")) {
            this.fIdEntry.setValue(e.getNewValue().toString(), true);
        } else if (prop.equals("name")) {
            this.fNameEntry.setValue(e.getNewValue().toString(), true);
        } else if (prop.equals("version")) {
            this.fVersionEntry.setValue(e.getNewValue().toString(), true);
        } else if (prop.equals("includeLaunchers")) {
            this.fLaunchersButton.setSelection(Boolean.parseBoolean(e.getNewValue().toString()));
        }
    }

    private void handleModelEventWorldChanged(IModelChangedEvent event) {
        this.refresh();
        this.getPage().setLastFocusControl((Control)this.fIdEntry.getText());
    }

    @Override
    public boolean canPaste(Clipboard clipboard) {
        Display d = this.getSection().getDisplay();
        Control c = d.getFocusControl();
        return c instanceof Text;
    }
}

