/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.event;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.TextDisplayPropertyEditor;
import org.eclipse.wb.internal.core.model.property.event.ListenerMethodProperty;
import org.eclipse.wb.internal.core.model.property.table.PropertyTable;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;

final class ListenerMethodPropertyEditor
extends TextDisplayPropertyEditor {
    public static final PropertyEditor INSTANCE = new ListenerMethodPropertyEditor();

    private ListenerMethodPropertyEditor() {
    }

    protected String getText(Property property) throws Exception {
        ListenerMethodProperty methodProperty = (ListenerMethodProperty)property;
        return methodProperty.getStartPosition().map(startPosition -> {
            JavaInfo javaInfo = methodProperty.getJavaInfo();
            int line = javaInfo.getEditor().getLineNumber((int)startPosition);
            return "line " + line;
        }).orElse(null);
    }

    public void doubleClick(Property property) throws Exception {
        this.openStubMethod(property);
    }

    public boolean activate(PropertyTable propertyTable, Property property, Point location) throws Exception {
        if (location == null) {
            this.openStubMethod(property);
        }
        return false;
    }

    private void openStubMethod(Property property) throws Exception {
        final ListenerMethodProperty methodProperty = (ListenerMethodProperty)property;
        ExecutionUtils.run((ObjectInfo)methodProperty.getJavaInfo(), (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                methodProperty.openStubMethod();
            }
        });
    }
}

