/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.extensions;

import java.util.HashMap;
import org.osgi.framework.Bundle;

public class NSKeyedExtensionRegistry {
    protected HashMap map = new HashMap();
    private static final String PLUGIN_LOADING_ERROR = "PLUGIN_LOADING_ERROR";

    public void put(String namespaceURI, String className, Bundle bundle) {
        ExtensionInfo info = (ExtensionInfo)this.map.get(namespaceURI);
        if (info == null) {
            info = new SinglePropertyExtensionInfo(className, bundle);
            this.map.put(namespaceURI, info);
        }
    }

    public void put(String namespaceURI, HashMap propertyToClassNameMap, Bundle bundle) {
        ExtensionInfo info = (ExtensionInfo)this.map.get(namespaceURI);
        if (info == null) {
            info = new MultiPropertyExtensionInfo(propertyToClassNameMap, bundle);
            this.map.put(namespaceURI, info);
        }
    }

    public Object get(String namespaceURI) {
        ExtensionInfo info = (ExtensionInfo)this.map.get(namespaceURI);
        return info != null ? info.getObject("") : null;
    }

    public Object getProperty(String namespaceURI, String property) {
        ExtensionInfo info = (ExtensionInfo)this.map.get(namespaceURI);
        return info != null ? info.getObject(property) : null;
    }

    private abstract class ExtensionInfo {
        protected Bundle bundle;

        public ExtensionInfo(Bundle bundle) {
            this.bundle = bundle;
        }

        public abstract Object getObject(String var1);
    }

    private class MultiPropertyExtensionInfo
    extends ExtensionInfo {
        protected HashMap propertyToClassNameTable;
        protected HashMap propertyToObjectTable;

        public MultiPropertyExtensionInfo(HashMap propertToClassNameTable, Bundle bundle) {
            super(bundle);
            this.propertyToObjectTable = new HashMap();
            this.propertyToClassNameTable = propertToClassNameTable;
        }

        @Override
        public Object getObject(String property) {
            String result = null;
            String className = (String)this.propertyToClassNameTable.get(property);
            if (className != null && (result = (String)this.propertyToObjectTable.get(property)) == null) {
                try {
                    Class theClass = this.bundle.loadClass(className);
                    result = (String)theClass.newInstance();
                    this.propertyToObjectTable.put(property, result);
                }
                catch (Exception e) {
                    this.propertyToObjectTable.put(property, NSKeyedExtensionRegistry.PLUGIN_LOADING_ERROR);
                    result = NSKeyedExtensionRegistry.PLUGIN_LOADING_ERROR;
                    e.printStackTrace();
                }
            }
            return result != NSKeyedExtensionRegistry.PLUGIN_LOADING_ERROR ? result : null;
        }
    }

    private class SinglePropertyExtensionInfo
    extends ExtensionInfo {
        protected String className;
        protected Object object;
        protected boolean error;

        public SinglePropertyExtensionInfo(String className, Bundle bundle) {
            super(bundle);
            this.className = className;
        }

        @Override
        public Object getObject(String property) {
            if (this.object == null) {
                try {
                    Class theClass = this.bundle.loadClass(this.className);
                    this.object = theClass.newInstance();
                }
                catch (Exception e) {
                    this.object = NSKeyedExtensionRegistry.PLUGIN_LOADING_ERROR;
                    e.printStackTrace();
                }
            }
            return this.object != NSKeyedExtensionRegistry.PLUGIN_LOADING_ERROR ? this.object : null;
        }
    }
}

