/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.DynamicInstructionPointerAnnotation;
import org.eclipse.debug.internal.ui.InstructionPointerAnnotation;
import org.eclipse.debug.internal.ui.LazyModelPresentation;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugEditorPresentation;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IDebugModelPresentationExtension;
import org.eclipse.debug.ui.IInstructionPointerPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public class DelegatingModelPresentation
implements IDebugModelPresentation,
IDebugEditorPresentation,
IColorProvider,
IFontProvider,
IInstructionPointerPresentation,
IDebugModelPresentationExtension {
    private final HashMap<String, Object> fAttributes = new HashMap(3);
    private final HashMap<String, IDebugModelPresentation> fLabelProviders = new HashMap(5);

    @Override
    public void removeAnnotations(IEditorPart editorPart, IThread thread) {
        IDebugModelPresentation presentation = this.getConfiguredPresentation(thread);
        if (presentation instanceof IDebugEditorPresentation) {
            ((IDebugEditorPresentation)((Object)presentation)).removeAnnotations(editorPart, thread);
        }
    }

    @Override
    public boolean addAnnotations(IEditorPart editorPart, IStackFrame frame) {
        IDebugModelPresentation presentation = this.getConfiguredPresentation(frame);
        if (presentation instanceof IDebugEditorPresentation) {
            return ((IDebugEditorPresentation)((Object)presentation)).addAnnotations(editorPart, frame);
        }
        return false;
    }

    public DelegatingModelPresentation() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(DebugUIPlugin.getUniqueIdentifier(), "debugModelPresentations");
        if (point != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = point.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configElements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configElements = extension.getConfigurationElements();
                int n3 = configElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement elt = iConfigurationElementArray[n4];
                    String id = elt.getAttribute("id");
                    if (id != null) {
                        LazyModelPresentation lp = new LazyModelPresentation(this, elt);
                        this.getLabelProviders().put(id, lp);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    public void addListener(ILabelProviderListener listener) {
        for (ILabelProvider iLabelProvider : this.fLabelProviders.values()) {
            iLabelProvider.addListener(listener);
        }
    }

    public void dispose() {
        for (ILabelProvider iLabelProvider : this.fLabelProviders.values()) {
            iLabelProvider.dispose();
        }
    }

    @Override
    public Image getImage(Object item) {
        Image image;
        IDebugModelPresentation lp = this.getConfiguredPresentation(item);
        if (lp != null && (image = lp.getImage(item)) != null) {
            return image;
        }
        return this.getDefaultImage(item);
    }

    @Override
    public String getText(Object item) {
        IDebugModelPresentation lp = this.getConfiguredPresentation(item);
        if (lp != null) {
            return lp.getText(item);
        }
        return this.getDefaultText(item);
    }

    @Override
    public IEditorInput getEditorInput(Object item) {
        IDebugModelPresentation lp = this.getConfiguredPresentation(item);
        if (lp != null) {
            return lp.getEditorInput(item);
        }
        return null;
    }

    @Override
    public String getEditorId(IEditorInput input, Object objectInput) {
        IDebugModelPresentation lp = this.getConfiguredPresentation(objectInput);
        if (lp != null) {
            return lp.getEditorId(input, objectInput);
        }
        return null;
    }

    protected String getDefaultText(Object element) {
        return DebugUIPlugin.getDefaultLabelProvider().getText(element);
    }

    protected Image getDefaultImage(Object element) {
        return DebugUIPlugin.getDefaultLabelProvider().getImage(element);
    }

    @Override
    public void computeDetail(IValue value, IValueDetailListener listener) {
        IDebugModelPresentation lp = this.getConfiguredPresentation(value);
        if (lp != null) {
            lp.computeDetail(value, listener);
        } else {
            listener.detailComputed(value, this.getText(value));
        }
    }

    public void removeListener(ILabelProviderListener listener) {
        for (ILabelProvider iLabelProvider : this.fLabelProviders.values()) {
            iLabelProvider.removeListener(listener);
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        IDebugModelPresentation lp;
        if (element instanceof IDebugElement && (lp = this.getConfiguredPresentation(element)) != null) {
            return lp.isLabelProperty(element, property);
        }
        return true;
    }

    protected IDebugModelPresentation getConfiguredPresentation(Object element) {
        String id = null;
        if (element instanceof IDebugElement) {
            IDebugElement de = (IDebugElement)element;
            id = de.getModelIdentifier();
        } else if (element instanceof IMarker) {
            IMarker m = (IMarker)element;
            IBreakpoint bp = DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(m);
            if (bp != null) {
                id = bp.getModelIdentifier();
            }
        } else if (element instanceof IBreakpoint) {
            id = ((IBreakpoint)element).getModelIdentifier();
        }
        if (id != null) {
            return this.getPresentation(id);
        }
        return null;
    }

    public IDebugModelPresentation getPresentation(String id) {
        return this.getLabelProviders().get(id);
    }

    @Override
    public void setAttribute(String id, Object value) {
        if (value == null) {
            return;
        }
        this.basicSetAttribute(id, value);
        for (IDebugModelPresentation p : this.fLabelProviders.values()) {
            p.setAttribute(id, value);
        }
    }

    protected void basicSetAttribute(String id, Object value) {
        this.fAttributes.put(id, value);
    }

    protected boolean showVariableTypeNames() {
        Boolean show = (Boolean)this.fAttributes.get("org.eclipse.debug.ui.displayVariableTypeNames");
        show = show == null ? Boolean.FALSE : show;
        return show;
    }

    public HashMap<String, Object> getAttributes() {
        return this.fAttributes;
    }

    public Map<String, Object> getAttributeMap() {
        return new HashMap<String, Object>(this.fAttributes);
    }

    protected HashMap<String, IDebugModelPresentation> getLabelProviders() {
        return this.fLabelProviders;
    }

    public Color getForeground(Object element) {
        IDebugModelPresentation presentation = this.getConfiguredPresentation(element);
        if (presentation instanceof IColorProvider) {
            IColorProvider colorProvider = (IColorProvider)presentation;
            return colorProvider.getForeground(element);
        }
        return null;
    }

    public Color getBackground(Object element) {
        IDebugModelPresentation presentation = this.getConfiguredPresentation(element);
        if (presentation instanceof IColorProvider) {
            IColorProvider colorProvider = (IColorProvider)presentation;
            return colorProvider.getBackground(element);
        }
        return null;
    }

    public Font getFont(Object element) {
        IDebugModelPresentation presentation = this.getConfiguredPresentation(element);
        if (presentation instanceof IFontProvider) {
            IFontProvider fontProvider = (IFontProvider)presentation;
            return fontProvider.getFont(element);
        }
        return null;
    }

    @Override
    public Annotation getInstructionPointerAnnotation(IEditorPart editorPart, IStackFrame frame) {
        IInstructionPointerPresentation pointerPresentation;
        IDebugModelPresentation presentation = this.getConfiguredPresentation(frame);
        Annotation annotation = null;
        String id = null;
        Image image = null;
        String text = null;
        if (presentation instanceof IInstructionPointerPresentation && (annotation = (pointerPresentation = (IInstructionPointerPresentation)presentation).getInstructionPointerAnnotation(editorPart, frame)) == null) {
            id = pointerPresentation.getInstructionPointerAnnotationType(editorPart, frame);
            if (id == null) {
                image = pointerPresentation.getInstructionPointerImage(editorPart, frame);
            }
            text = pointerPresentation.getInstructionPointerText(editorPart, frame);
        }
        if (annotation == null) {
            boolean defaultAnnotation;
            boolean bl = defaultAnnotation = id == null;
            if (id == null || text == null || defaultAnnotation && image == null) {
                IThread thread = frame.getThread();
                IStackFrame tos = null;
                boolean top = false;
                try {
                    tos = thread.getTopStackFrame();
                    top = frame.equals(tos);
                }
                catch (DebugException debugException) {
                    // empty catch block
                }
                if (id == null) {
                    id = top ? "org.eclipse.debug.ui.currentIP" : "org.eclipse.debug.ui.secondaryIP";
                }
                if (text == null) {
                    text = top ? DebugUIMessages.InstructionPointerAnnotation_0 : DebugUIMessages.InstructionPointerAnnotation_1;
                }
                if (defaultAnnotation && image == null) {
                    image = top ? DebugUITools.getImage("IMG_OBJS_INSTRUCTION_POINTER_TOP") : DebugUITools.getImage("IMG_OBJS_INSTRUCTION_POINTER");
                }
            }
            annotation = defaultAnnotation ? new InstructionPointerAnnotation(frame, id, text, image) : new DynamicInstructionPointerAnnotation(frame, id, text);
        }
        return annotation;
    }

    @Override
    public String getInstructionPointerAnnotationType(IEditorPart editorPart, IStackFrame frame) {
        IDebugModelPresentation presentation = this.getConfiguredPresentation(frame);
        if (presentation instanceof IInstructionPointerPresentation) {
            return ((IInstructionPointerPresentation)presentation).getInstructionPointerAnnotationType(editorPart, frame);
        }
        return null;
    }

    @Override
    public Image getInstructionPointerImage(IEditorPart editorPart, IStackFrame frame) {
        IDebugModelPresentation presentation = this.getConfiguredPresentation(frame);
        if (presentation instanceof IInstructionPointerPresentation) {
            return ((IInstructionPointerPresentation)presentation).getInstructionPointerImage(editorPart, frame);
        }
        return null;
    }

    @Override
    public String getInstructionPointerText(IEditorPart editorPart, IStackFrame frame) {
        IDebugModelPresentation presentation = this.getConfiguredPresentation(frame);
        if (presentation instanceof IInstructionPointerPresentation) {
            return ((IInstructionPointerPresentation)presentation).getInstructionPointerText(editorPart, frame);
        }
        return null;
    }

    @Override
    public boolean requiresUIThread(Object element) {
        IDebugModelPresentation presentation = this.getConfiguredPresentation(element);
        if (presentation == null) {
            return !DebugPluginImages.isInitialized();
        }
        if (presentation instanceof IDebugModelPresentationExtension) {
            return ((IDebugModelPresentationExtension)presentation).requiresUIThread(element);
        }
        return false;
    }
}

