/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.wb.core.editor.IContextMenuConstants;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.editor.actions.DesignPageActions;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.gef.core.MultiSelectionContextMenuProvider;

public final class DesignContextMenuProvider
extends MultiSelectionContextMenuProvider
implements IContextMenuConstants {
    private final DesignPageActions m_pageActions;
    private List<ObjectInfo> m_selectedObjects;

    public static void addGroups(IMenuManager manager) {
        manager.add((IContributionItem)new Separator("org.eclipse.wb.popup.group.top"));
        manager.add((IContributionItem)new Separator("org.eclipse.wb.popup.group.edit"));
        manager.add((IContributionItem)new Separator("org.eclipse.wb.popup.group.edit2"));
        manager.add((IContributionItem)new Separator("org.eclipse.wb.popup.group.events"));
        manager.add((IContributionItem)new Separator("org.eclipse.wb.popup.group.events2"));
        manager.add((IContributionItem)new Separator("org.eclipse.wb.popup.group.layout"));
        manager.add((IContributionItem)new Separator("org.eclipse.wb.popup.group.constraints"));
        manager.add((IContributionItem)new Separator("org.eclipse.wb.popup.group.inheritance"));
        manager.add((IContributionItem)new Separator("org.eclipse.wb.popup.group.additional"));
    }

    public DesignContextMenuProvider(EditPartViewer viewer, DesignPageActions pageActions) {
        super(viewer);
        this.m_pageActions = pageActions;
    }

    protected void preprocessSelection(List<? extends EditPart> editParts) {
        super.preprocessSelection(editParts);
        this.m_selectedObjects = new ArrayList<ObjectInfo>();
        for (EditPart editPart : editParts) {
            if (!(editPart.getModel() instanceof ObjectInfo)) continue;
            this.m_selectedObjects.add((ObjectInfo)editPart.getModel());
        }
    }

    protected void buildContextMenu(final EditPart editPart, final IMenuManager manager) {
        DesignContextMenuProvider.addGroups(manager);
        boolean wbBasic = InstanceScope.INSTANCE.getNode("org.eclipse.wb.core.editor.constants.preferences").getBoolean("basicUserInterface", false);
        manager.appendToGroup("org.eclipse.wb.popup.group.edit", this.m_pageActions.getCutAction());
        manager.appendToGroup("org.eclipse.wb.popup.group.edit", this.m_pageActions.getCopyAction());
        manager.appendToGroup("org.eclipse.wb.popup.group.edit", this.m_pageActions.getPasteAction());
        manager.appendToGroup("org.eclipse.wb.popup.group.edit", this.m_pageActions.getDeleteAction());
        if (!wbBasic) {
            manager.appendToGroup("org.eclipse.wb.popup.group.edit2", this.m_pageActions.getTestAction());
            manager.appendToGroup("org.eclipse.wb.popup.group.edit2", this.m_pageActions.getRefreshAction());
        }
        if (!wbBasic && editPart.getModel() instanceof ObjectInfo) {
            ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    ObjectInfo object = (ObjectInfo)editPart.getModel();
                    object.getBroadcastObject().addContextMenu(DesignContextMenuProvider.this.m_selectedObjects, object, manager);
                }
            });
        }
    }
}

