/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.util;

import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.wst.common.componentcore.ArtifactEdit;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.internal.ArtifactEditModel;
import org.eclipse.wst.common.componentcore.internal.impl.ModuleURIUtil;
import org.eclipse.wst.common.componentcore.internal.util.ArtifactEditRegistryReader;
import org.eclipse.wst.common.componentcore.internal.util.IArtifactEditFactory;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.internal.emfworkbench.edit.EditModelRegistry;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModel;

public class ArtifactEditAdapterFactory
implements IAdapterFactory {
    private static final Class ARTIFACT_EDIT_MODEL_CLASS = ArtifactEditModel.class;
    private static final Class ARTIFACT_EDIT_CLASS = ArtifactEdit.class;

    public Object getAdapter(Object anAdaptableObject, Class anAdapterType) {
        if (anAdapterType == ArtifactEditModel.ADAPTER_TYPE && anAdaptableObject instanceof ArtifactEdit) {
            ArtifactEdit edit = (ArtifactEdit)anAdaptableObject;
            IProject aProject = edit.getProject();
            URI componentURI = ModuleURIUtil.fullyQualifyURI(aProject);
            ModuleCoreNature nature = ModuleCoreNature.getModuleCoreNature(edit.getComponent().getProject());
            HashMap<String, URI> params = new HashMap<String, URI>();
            params.put("MODULE_URI", componentURI);
            try {
                String[] editModelIDs = EditModelRegistry.getInstance().getRegisteredEditModelIDs();
                int i = 0;
                while (i < editModelIDs.length) {
                    try {
                        EditModel editModel = nature.getExistingEditModel(editModelIDs[i], params, edit.isReadOnly());
                        if (editModel != null) {
                            return editModel;
                        }
                    }
                    catch (Exception exception) {}
                    ++i;
                }
            }
            catch (Exception exception) {}
            return null;
        }
        if (anAdapterType == ArtifactEdit.ADAPTER_TYPE) {
            ArtifactEditRegistryReader reader;
            IArtifactEditFactory factory;
            if (anAdaptableObject instanceof ArtifactEditModel) {
                return new ArtifactEdit((ArtifactEditModel)((Object)anAdaptableObject));
            }
            if (anAdaptableObject instanceof IVirtualComponent && (factory = (reader = ArtifactEditRegistryReader.instance()).getArtifactEdit(((IVirtualComponent)anAdaptableObject).getProject())) != null) {
                return factory.createArtifactEditForRead((IVirtualComponent)anAdaptableObject);
            }
        }
        return null;
    }

    public Class[] getAdapterList() {
        return new Class[]{ARTIFACT_EDIT_MODEL_CLASS, ARTIFACT_EDIT_CLASS};
    }
}

