/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui.actions;

import java.util.ArrayList;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.web.ui.actions.Messages;
import org.eclipse.wst.jsdt.web.ui.views.contentoutline.IJavaWebNode;
import org.eclipse.wst.jsdt.web.ui.views.contentoutline.JsJfaceNode;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class StandardEditorActionsAction
implements IObjectActionDelegate {
    private static final boolean APPEND_NEW_LINES_TO_COPY = true;
    protected static final String COPY = "org.eclipse.wst.jsdt.web.ui.copy";
    protected static final String CUT = "org.eclipse.wst.jsdt.web.ui.cut";
    protected static final String DELETE = "org.eclipse.wst.jsdt.web.ui.delete";
    private static final char NEW_LINE = '\n';
    protected static final String PASTE_AFTER = "org.eclipse.wst.jsdt.web.ui.paste.after";
    protected static final String PASTE_BEFORE = "org.eclipse.wst.jsdt.web.ui.paste.before";
    protected ISelection selection;

    private void copy(IAction action) {
        JsJfaceNode[] nodes = this.parseSelection();
        if (nodes == null || nodes.length == 0) {
            return;
        }
        Clipboard clipboard = null;
        StringBuffer text = new StringBuffer();
        text.append('\n');
        try {
            int i = 0;
            while (i < nodes.length) {
                JsJfaceNode currentNode = nodes[i];
                int start = currentNode.getStartOffset();
                int length = currentNode.getLength();
                IStructuredDocument doc = currentNode.getStructuredDocument();
                try {
                    String elementText = doc.get(start, length);
                    text.append(elementText);
                }
                catch (BadLocationException ex) {
                    ex.printStackTrace();
                }
                text.append('\n');
                clipboard = new Clipboard(Display.getCurrent());
                clipboard.setContents(new Object[]{text.toString()}, new Transfer[]{TextTransfer.getInstance()});
                ++i;
            }
        }
        finally {
            if (clipboard != null) {
                clipboard.dispose();
            }
        }
    }

    private void delete(IAction action) {
        JsJfaceNode[] nodes = this.parseSelection();
        if (nodes == null || nodes.length == 0) {
            return;
        }
        IStructuredDocument lastDoc = null;
        IModelManager modelManager = StructuredModelManager.getModelManager();
        IStructuredModel model = null;
        try {
            try {
                int i = 0;
                while (i < nodes.length) {
                    JsJfaceNode currentNode = nodes[i];
                    int start = currentNode.getStartOffset();
                    int length = currentNode.getLength();
                    IStructuredDocument doc = currentNode.getStructuredDocument();
                    if (doc != lastDoc) {
                        lastDoc = doc;
                        if (model != null) {
                            model.endRecording((Object)action);
                            model.changedModel();
                            model.releaseFromEdit();
                        }
                        if (modelManager != null) {
                            model = modelManager.getExistingModelForEdit((IDocument)doc);
                            model.aboutToChangeModel();
                            model.beginRecording((Object)action, "Delete JavaScript Element", "Delete JavaScript Element");
                        }
                    }
                    doc.replaceText((Object)action, start, length, "");
                    ++i;
                }
                model.endRecording((Object)action);
            }
            catch (Exception e) {
                System.out.println(String.valueOf(Messages.getString("StandardEditorActionsAction.8")) + e);
                if (model != null) {
                    model.changedModel();
                    model.releaseFromEdit();
                }
            }
        }
        finally {
            if (model != null) {
                model.changedModel();
                model.releaseFromEdit();
            }
        }
    }

    private JsJfaceNode[] parseSelection() {
        if (this.selection == null) {
            return new JsJfaceNode[0];
        }
        ArrayList elements = new ArrayList();
        if (this.selection instanceof IStructuredSelection) {
            for (Object element : (IStructuredSelection)this.selection) {
                if (element instanceof IJavaScriptElement) {
                    elements.add(element);
                }
                if (!(element instanceof IJavaWebNode)) continue;
                elements.add(element);
            }
            return elements.toArray(new JsJfaceNode[elements.size()]);
        }
        return new JsJfaceNode[0];
    }

    private void paste(IAction action, boolean atEnd) {
        int i;
        JsJfaceNode[] nodes = this.parseSelection();
        if (nodes == null || nodes.length == 0) {
            return;
        }
        int startOfPaste = -1;
        IStructuredDocument doc = null;
        if (atEnd) {
            i = 0;
            while (i < nodes.length) {
                if (nodes[i].getStartOffset() + nodes[i].getLength() > startOfPaste) {
                    startOfPaste = nodes[i].getStartOffset() + nodes[i].getLength();
                    doc = nodes[i].getStructuredDocument();
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < nodes.length) {
                if (nodes[i].getStartOffset() < startOfPaste || startOfPaste < 0) {
                    startOfPaste = nodes[i].getStartOffset();
                    doc = nodes[i].getStructuredDocument();
                }
                ++i;
            }
        }
        Clipboard clipboard = null;
        IModelManager modelManager = StructuredModelManager.getModelManager();
        IStructuredModel model = null;
        try {
            clipboard = new Clipboard(Display.getCurrent());
            String pasteString = (String)clipboard.getContents((Transfer)TextTransfer.getInstance());
            model = modelManager.getExistingModelForEdit((IDocument)doc);
            model.aboutToChangeModel();
            model.beginRecording((Object)action, String.valueOf(Messages.getString("StandardEditorActionsAction.9")) + (atEnd ? Messages.getString("StandardEditorActionsAction.10") : Messages.getString("StandardEditorActionsAction.11")) + Messages.getString("StandardEditorActionsAction.12"), String.valueOf(Messages.getString("StandardEditorActionsAction.13")) + (atEnd ? Messages.getString("StandardEditorActionsAction.14") : Messages.getString("StandardEditorActionsAction.15")) + Messages.getString("StandardEditorActionsAction.16"));
            doc.replaceText((Object)action, startOfPaste, 0, pasteString);
        }
        finally {
            if (clipboard != null) {
                clipboard.dispose();
            }
            if (model != null) {
                model.endRecording((Object)action);
                model.changedModel();
                model.releaseFromEdit();
            }
        }
    }

    public void run(IAction action) {
        if (action.getId().equals(CUT)) {
            this.copy(action);
            this.delete(action);
        } else if (action.getId().equals(COPY)) {
            this.copy(action);
        } else if (action.getId().equals(PASTE_BEFORE)) {
            this.paste(action, false);
        } else if (action.getId().equals(PASTE_AFTER)) {
            this.paste(action, true);
        } else if (action.getId().equals(DELETE)) {
            this.delete(action);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }
}

