/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.validation.internal.ui.ant;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.DTDLocation;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.ResourceLocation;
import org.apache.tools.ant.types.XMLCatalog;
import org.eclipse.wst.wsdl.validation.internal.ClassloaderWSDLValidatorDelegate;
import org.eclipse.wst.wsdl.validation.internal.IValidationMessage;
import org.eclipse.wst.wsdl.validation.internal.IValidationReport;
import org.eclipse.wst.wsdl.validation.internal.WSDLValidationConfiguration;
import org.eclipse.wst.wsdl.validation.internal.WSDLValidator;
import org.eclipse.wst.wsdl.validation.internal.logging.LoggerFactory;
import org.eclipse.wst.wsdl.validation.internal.resolver.URIResolverDelegate;
import org.eclipse.wst.wsdl.validation.internal.ui.ant.AntLogger;
import org.eclipse.wst.wsdl.validation.internal.ui.ant.ExtensionValidator;
import org.eclipse.wst.wsdl.validation.internal.ui.ant.Property;
import org.eclipse.wst.wsdl.validation.internal.ui.ant.URIResolver;
import org.eclipse.wst.wsdl.validation.internal.ui.ant.XMLCatalogImpl;
import org.eclipse.wst.wsdl.validation.internal.util.MessageGenerator;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.ClassloaderWSDL11ValidatorDelegate;

public class WSDLValidate
extends Task {
    protected final String UI_PROPERTIES = "validatewsdlui";
    protected final String VALIDATOR_PROPERTIES = "validatewsdl";
    protected final String _ERROR_NO_FILE_SPECIFIED = "_ERROR_NO_FILE_SPECIFIED";
    protected final String _UI_INFORMATION_DELIMITER = "_UI_INFORMATION_DELIMITER";
    protected final String _UI_ACTION_VALIDATING_FILE = "_UI_ACTION_VALIDATING_FILE";
    protected final String _UI_ERROR_MARKER = "_UI_ERROR_MARKER";
    protected final String _UI_WARNING_MARKER = "_UI_WARNING_MARKER";
    protected final String _UI_VALID = "_UI_VALID";
    protected final String _UI_INVALID = "_UI_INVALID";
    protected final String _EXC_UNABLE_TO_VALIDATE_FILE = "_EXC_UNABLE_TO_VALIDATE_FILE";
    protected final String _EXC_WSDL_FAIL_ON_ERROR = "_EXC_WSDL_FAIL_ON_ERROR";
    protected final String FILE_PROTOCOL = "file:///";
    protected List filesets = new ArrayList();
    protected String file = null;
    protected Path classpath;
    protected String xsdDirectory = null;
    protected boolean failOnError = false;
    protected XMLCatalog globalXMLCatalog = new XMLCatalog();
    protected List wsdl11validators = new ArrayList();
    protected List extvalidators = new ArrayList();
    protected List extURIResolvers = new ArrayList();
    protected List properties = new ArrayList();

    public WSDLValidate() {
        LoggerFactory.getInstance().setLogger(new AntLogger(this));
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public void setSchemaDir(String dir) {
        this.xsdDirectory = dir;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public FileSet createFileset() {
        FileSet fileset = new FileSet();
        this.filesets.add(fileset);
        return fileset;
    }

    public void addConfiguredXMLCatalog(XMLCatalog catalog) {
        this.globalXMLCatalog.addConfiguredXMLCatalog(catalog);
    }

    public void addConfiguredExtensionValidator(ExtensionValidator extVal) {
        this.extvalidators.add(extVal);
    }

    public void addConfiguredWSDL11Validator(ExtensionValidator extVal) {
        this.wsdl11validators.add(extVal);
    }

    public DTDLocation createEntity() {
        DTDLocation dtdLoc = new DTDLocation();
        this.globalXMLCatalog.addEntity((ResourceLocation)dtdLoc);
        return dtdLoc;
    }

    public DTDLocation createDTD() {
        DTDLocation dtdLoc = new DTDLocation();
        this.globalXMLCatalog.addEntity((ResourceLocation)dtdLoc);
        return dtdLoc;
    }

    public URIResolver createURIResolver() {
        URIResolver urires = new URIResolver();
        this.extURIResolvers.add(urires.getClassName());
        return urires;
    }

    public void addConfiguredProperty(Property property) {
        this.properties.add(property);
    }

    protected List getFileList() {
        ArrayList<Object> files = new ArrayList<Object>();
        if (this.file != null) {
            try {
                URL url = new URL(this.file);
                files.add(url.toExternalForm());
            }
            catch (Exception exception) {
                Object absFile;
                File theFile = new File(this.file);
                if (!theFile.isAbsolute()) {
                    theFile = new File(this.getProject().getBaseDir(), this.file);
                }
                if (!((String)(absFile = theFile.toString())).startsWith("file:")) {
                    absFile = "file:///" + (String)absFile;
                }
                absFile = ((String)absFile).replace('\\', '/');
                files.add(absFile);
            }
        }
        for (FileSet fileset : this.filesets) {
            DirectoryScanner ds = fileset.getDirectoryScanner(fileset.getProject());
            String basedir = ds.getBasedir().toString() + File.separator;
            String[] filelist = ds.getIncludedFiles();
            int numFiles = filelist.length;
            if (files == null || numFiles <= 0) continue;
            int i = 0;
            while (i < numFiles) {
                Object absFile = "file:///" + basedir + filelist[i];
                absFile = ((String)absFile).replace('\\', '/');
                files.add(absFile);
                ++i;
            }
        }
        return files;
    }

    public void execute() throws BuildException {
        MessageGenerator messGen = null;
        try {
            ResourceBundle uiRB = ResourceBundle.getBundle("validatewsdlui");
            messGen = new MessageGenerator(uiRB);
        }
        catch (MissingResourceException e) {
            throw new BuildException("Unable to open resource bundle. " + String.valueOf(e));
        }
        org.eclipse.wst.wsdl.validation.internal.xml.XMLCatalog.setExtensionXMLCatalog(XMLCatalogImpl.class.getName(), ((Object)((Object)this)).getClass().getClassLoader());
        XMLCatalogImpl xmlCatalog = (XMLCatalogImpl)org.eclipse.wst.wsdl.validation.internal.xml.XMLCatalog.getExtensionCatalogInstance();
        xmlCatalog.addXMLCatalog(this.globalXMLCatalog);
        WSDLValidator wsdlValidator = new WSDLValidator();
        WSDLValidationConfiguration configuration = new WSDLValidationConfiguration();
        for (Property property : this.properties) {
            configuration.setProperty(property.getName(), property.getValue());
        }
        for (String resolverClass : this.extURIResolvers) {
            wsdlValidator.addURIResolver(new URIResolverDelegate(resolverClass, ((Object)((Object)this)).getClass().getClassLoader()).getURIResolver());
        }
        List files = this.getFileList();
        for (ExtensionValidator extVal : this.wsdl11validators) {
            ClassloaderWSDL11ValidatorDelegate delegate = new ClassloaderWSDL11ValidatorDelegate(extVal.getClassName());
            wsdlValidator.registerWSDL11Validator(extVal.getNamespace(), delegate);
        }
        for (ExtensionValidator extVal : this.extvalidators) {
            ClassloaderWSDLValidatorDelegate delegate = new ClassloaderWSDLValidatorDelegate(extVal.getClassName());
            wsdlValidator.registerWSDLExtensionValidator(extVal.getNamespace(), delegate);
        }
        if (files == null || files.isEmpty()) {
            this.log(messGen.getString("_ERROR_NO_FILE_SPECIFIED"), 0);
            return;
        }
        if (this.xsdDirectory != null) {
            org.eclipse.wst.wsdl.validation.internal.xml.XMLCatalog.addSchemaDir(this.xsdDirectory);
        }
        Iterator iFiles = files.iterator();
        String infoDelim = messGen.getString("_UI_INFORMATION_DELIMITER");
        String valid = messGen.getString("_UI_VALID");
        String invalid = messGen.getString("_UI_INVALID");
        String errormarker = messGen.getString("_UI_ERROR_MARKER");
        String warningmarker = messGen.getString("_UI_WARNING_MARKER");
        StringBuffer result = null;
        boolean notvalid = true;
        while (iFiles.hasNext()) {
            result = new StringBuffer();
            notvalid = false;
            String filename = (String)iFiles.next();
            try {
                try {
                    result.append(infoDelim).append("\n");
                    result.append(messGen.getString("_UI_ACTION_VALIDATING_FILE", filename)).append(" - ");
                    IValidationReport valReport = wsdlValidator.validate(filename, null, configuration);
                    IValidationMessage[] messages = valReport.getValidationMessages();
                    if (!valReport.hasErrors()) {
                        result.append(valid);
                    } else {
                        result.append(invalid);
                        notvalid = true;
                    }
                    result.append("\n").append(infoDelim).append("\n");
                    result.append(this.reportMessages(messages, errormarker, warningmarker));
                    if (notvalid) {
                        this.log(result.toString(), 0);
                    } else {
                        this.log(result.toString());
                    }
                }
                catch (Exception e) {
                    this.log(messGen.getString("_EXC_UNABLE_TO_VALIDATE_FILE", filename, e), 0);
                    if (!notvalid || !this.failOnError) continue;
                    throw new BuildException(messGen.getString("_EXC_WSDL_FAIL_ON_ERROR"));
                }
            }
            catch (Throwable throwable) {
                if (notvalid && this.failOnError) {
                    throw new BuildException(messGen.getString("_EXC_WSDL_FAIL_ON_ERROR"));
                }
                throw throwable;
            }
            if (!notvalid || !this.failOnError) continue;
            throw new BuildException(messGen.getString("_EXC_WSDL_FAIL_ON_ERROR"));
        }
        org.eclipse.wst.wsdl.validation.internal.xml.XMLCatalog.reset();
    }

    protected String reportMessages(IValidationMessage[] messages, String errormarker, String warningmarker) {
        StringBuffer returnBuffer = new StringBuffer();
        if (messages == null) {
            return returnBuffer.toString();
        }
        String prefix = null;
        int numMessages = messages.length;
        int i = 0;
        while (i < numMessages) {
            IValidationMessage message = messages[i];
            prefix = message.getSeverity() == 0 ? errormarker : (message.getSeverity() == 1 ? warningmarker : "");
            prefix = message.getSeverity() == 0 ? errormarker : (message.getSeverity() == 1 ? warningmarker : "");
            prefix = message.getSeverity() == 0 ? errormarker : (message.getSeverity() == 1 ? warningmarker : "");
            prefix = message.getSeverity() == 0 ? errormarker : (message.getSeverity() == 1 ? warningmarker : "");
            returnBuffer.append(prefix).append(" ").append(message.getLine()).append(":").append(message.getColumn()).append(":").append(message.getMessage()).append("\n");
            ++i;
        }
        return returnBuffer.toString();
    }
}

