/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.wizard.template;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.xtext.ui.wizard.template.IFileGenerator;
import org.eclipse.xtext.util.StringInputStream;

public class WorkspaceFileGenerator
extends WorkspaceModifyOperation
implements IFileGenerator {
    private final SortedMap<String, CharSequence> files = new TreeMap<String, CharSequence>();
    private IFile firstFile;

    @Override
    public void generate(CharSequence path, CharSequence content) {
        this.files.put(path.toString(), content);
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)this.files.size());
        try {
            try {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                for (Map.Entry<String, CharSequence> fileEntry : this.files.entrySet()) {
                    IFile file = workspace.getRoot().getFile((IPath)new Path(fileEntry.getKey()));
                    file.create((InputStream)new StringInputStream(fileEntry.getValue().toString(), file.getCharset()), true, (IProgressMonitor)subMonitor);
                    if (this.firstFile == null) {
                        this.firstFile = file;
                    }
                    subMonitor.worked(1);
                }
            }
            catch (UnsupportedEncodingException e) {
                Status status = new Status(4, "org.eclipse.xtext.ui", 0, e.getMessage(), (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        finally {
            subMonitor.done();
        }
    }

    public IFile getResult() {
        return this.firstFile;
    }
}

