/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;
import org.junit.jupiter.params.ParameterizedInvocationContextProvider;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.ParameterizedTestContext;
import org.junit.jupiter.params.ParameterizedTestInvocationContext;
import org.junit.platform.commons.support.AnnotationSupport;

class ParameterizedTestExtension
extends ParameterizedInvocationContextProvider<ParameterizedTestInvocationContext>
implements TestTemplateInvocationContextProvider {
    static final String DECLARATION_CONTEXT_KEY = "context";

    ParameterizedTestExtension() {
    }

    public boolean supportsTestTemplate(ExtensionContext context) {
        Optional annotation = AnnotationSupport.findAnnotation((Optional)context.getTestMethod(), ParameterizedTest.class);
        if (annotation.isEmpty()) {
            return false;
        }
        ParameterizedTestContext methodContext = new ParameterizedTestContext(context.getRequiredTestClass(), context.getRequiredTestMethod(), (ParameterizedTest)annotation.get());
        this.getStore(context).put((Object)DECLARATION_CONTEXT_KEY, (Object)methodContext);
        return true;
    }

    public Stream<ParameterizedTestInvocationContext> provideTestTemplateInvocationContexts(ExtensionContext extensionContext) {
        return this.provideInvocationContexts(extensionContext, this.getDeclarationContext(extensionContext));
    }

    public boolean mayReturnZeroTestTemplateInvocationContexts(ExtensionContext extensionContext) {
        return this.getDeclarationContext(extensionContext).isAllowingZeroInvocations();
    }

    private ParameterizedTestContext getDeclarationContext(ExtensionContext extensionContext) {
        return Objects.requireNonNull((ParameterizedTestContext)this.getStore(extensionContext).get((Object)DECLARATION_CONTEXT_KEY, ParameterizedTestContext.class));
    }

    private ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{ParameterizedTestExtension.class, context.getRequiredTestMethod()}));
    }
}

