/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.validation;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import org.eclipse.acceleo.TypedElement;
import org.eclipse.acceleo.Variable;
import org.eclipse.acceleo.aql.validation.IAcceleoValidationResult;
import org.eclipse.acceleo.query.parser.AstResult;
import org.eclipse.acceleo.query.parser.AstValidator;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;

public final class AcceleoValidationUtils {
    private AcceleoValidationUtils() {
    }

    public static String getPossibleTypesRepresentation(TypedElement acceleoTypedElement, IAcceleoValidationResult acceleoValidationResult) {
        return AcceleoValidationUtils.getPossibleTypes(acceleoTypedElement, acceleoValidationResult).stream().map(AcceleoValidationUtils::getFullyQualifiedName).collect(Collectors.joining(" | "));
    }

    public static Set<IType> getPossibleTypes(TypedElement acceleoTypedElement, IAcceleoValidationResult acceleoValidationResult) {
        AstResult typeAstResult = acceleoTypedElement.getType();
        IValidationResult parameterTypeValidationResult = acceleoValidationResult.getValidationResult(typeAstResult);
        HashSet possibleTypes = parameterTypeValidationResult.getPossibleTypes(typeAstResult.getAst());
        if (possibleTypes == null) {
            possibleTypes = new HashSet();
        }
        return possibleTypes;
    }

    public static String getFullyQualifiedName(IType aqlType) {
        String fullyQualifiedName = null;
        Object javaClassOrEClassifier = Objects.requireNonNull(aqlType).getType();
        if (javaClassOrEClassifier instanceof Class) {
            Class javaClass = (Class)javaClassOrEClassifier;
            fullyQualifiedName = javaClass.getCanonicalName();
        } else if (javaClassOrEClassifier instanceof EClass) {
            EClass eClass = (EClass)javaClassOrEClassifier;
            fullyQualifiedName = AcceleoValidationUtils.getCanonicalName(eClass);
        } else if (javaClassOrEClassifier instanceof EDataType) {
            EDataType eDataType = (EDataType)javaClassOrEClassifier;
            fullyQualifiedName = eDataType.getInstanceClass().getCanonicalName();
        } else {
            throw new IllegalArgumentException("Unexpected 'type' Object in " + aqlType.toString() + ": " + javaClassOrEClassifier.toString() + " is neither a Java class nor an EClassifier instance.");
        }
        return fullyQualifiedName;
    }

    private static String getCanonicalName(EClass eClass) {
        String eClassName = eClass.getName();
        Stack<EPackage> ePackages = new Stack<EPackage>();
        EPackage currentEPackage = eClass.getEPackage();
        do {
            ePackages.add(currentEPackage);
        } while ((currentEPackage = currentEPackage.getESuperPackage()) != null);
        String packageFullyQualifiedName = ePackages.stream().map(ENamedElement::getName).collect(Collectors.joining("::"));
        return packageFullyQualifiedName + "::" + eClassName;
    }

    public static String getVariablesListRepresentation(List<Variable> variables, IAcceleoValidationResult acceleoValidationResult) {
        Object variablesListRepresentation = "";
        for (Variable variable : variables) {
            String variablePossibleTypesRepresentation = AcceleoValidationUtils.getPossibleTypesRepresentation(variable, acceleoValidationResult);
            variablesListRepresentation = (String)variablesListRepresentation + variablePossibleTypesRepresentation;
            if (variables.indexOf(variable) == variables.size() - 1) continue;
            variablesListRepresentation = (String)variablesListRepresentation + ", ";
        }
        return variablesListRepresentation;
    }

    public static Set<IType> getPossibleTypes(TypedElement typedElement, IQueryEnvironment queryEnvironment) {
        AstResult typeToAnalyze = typedElement.getType();
        if (typeToAnalyze == null) {
            return new HashSet<IType>();
        }
        AstValidator aqlValidator = new AstValidator(new ValidationServices((IReadOnlyQueryEnvironment)queryEnvironment));
        IValidationResult variableTypeValidationResult = aqlValidator.validate(Collections.emptyMap(), typedElement.getType());
        return variableTypeValidationResult.getPossibleTypes(typedElement.getTypeAql());
    }
}

