/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.msw.build.ui;

import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsProvider;
import org.eclipse.cdt.managedbuilder.language.settings.providers.AbstractBuildCommandParser;
import org.eclipse.cdt.managedbuilder.language.settings.providers.AbstractLanguageSettingsOutputScanner;
import org.eclipse.cdt.msw.build.ui.Messages;
import org.eclipse.cdt.ui.language.settings.providers.AbstractLanguageSettingProviderOptionPage;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public final class MSVCCommandParserOptionPage
extends AbstractLanguageSettingProviderOptionPage {
    private boolean fEditable;
    private Text inputCommand;
    private Button expandRelativePathCheckBox;

    public void createControl(Composite parent) {
        this.fEditable = parent.isEnabled();
        AbstractBuildCommandParser provider = (AbstractBuildCommandParser)this.getProvider();
        Composite composite = new Composite(parent, 0);
        this.createCompositeForPageArea(composite);
        this.createCompilerPatternInputControl(provider, composite);
        this.createResolvePathsCheckbox(composite, (AbstractLanguageSettingsOutputScanner)provider);
        this.setControl((Control)composite);
    }

    private void createCompositeForPageArea(Composite composite) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 1;
        layout.marginHeight = 1;
        layout.marginRight = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Dialog.applyDialogFont((Control)composite);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        composite.setLayoutData((Object)gd);
    }

    private void createCompilerPatternInputControl(AbstractBuildCommandParser provider, Composite composite) {
        Label label = ControlFactory.createLabel((Composite)composite, (String)Messages.MSVCCommandParserOptionPage_CompilerPattern);
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        label.setLayoutData((Object)gd);
        label.setEnabled(this.fEditable);
        this.inputCommand = ControlFactory.createTextField((Composite)composite, (int)2052);
        String compilerPattern = provider.getCompilerPattern();
        this.inputCommand.setText(compilerPattern != null ? compilerPattern : "");
        gd = new GridData();
        gd.horizontalSpan = 1;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.inputCommand.setLayoutData((Object)gd);
        this.inputCommand.setEnabled(this.fEditable);
        this.inputCommand.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractBuildCommandParser provider;
                String text = MSVCCommandParserOptionPage.this.inputCommand.getText();
                if (!text.equals((provider = (AbstractBuildCommandParser)MSVCCommandParserOptionPage.this.getProvider()).getCompilerPattern())) {
                    AbstractBuildCommandParser selectedProvider = (AbstractBuildCommandParser)MSVCCommandParserOptionPage.this.getProviderWorkingCopy();
                    selectedProvider.setCompilerPattern(text);
                    MSVCCommandParserOptionPage.this.refreshItem((ILanguageSettingsProvider)selectedProvider);
                }
            }
        });
    }

    private void createResolvePathsCheckbox(Composite composite, AbstractLanguageSettingsOutputScanner provider) {
        this.expandRelativePathCheckBox = new Button(composite, 32);
        this.expandRelativePathCheckBox.setText(Messages.MSVCCommandParserOptionPage_ResolvePaths);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.expandRelativePathCheckBox.setLayoutData((Object)gd);
        this.expandRelativePathCheckBox.setSelection(provider.isResolvingPaths());
        this.expandRelativePathCheckBox.setEnabled(this.fEditable);
        this.expandRelativePathCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractBuildCommandParser provider;
                boolean enabled = MSVCCommandParserOptionPage.this.expandRelativePathCheckBox.getSelection();
                if (enabled != (provider = (AbstractBuildCommandParser)MSVCCommandParserOptionPage.this.getProvider()).isResolvingPaths()) {
                    AbstractBuildCommandParser selectedProvider = (AbstractBuildCommandParser)MSVCCommandParserOptionPage.this.getProviderWorkingCopy();
                    selectedProvider.setResolvingPaths(enabled);
                    MSVCCommandParserOptionPage.this.refreshItem((ILanguageSettingsProvider)selectedProvider);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }
}

