/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.core;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.AbstractLanguageToolkit;
import org.eclipse.dltk.core.DLTKContentTypeManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.PreferencesLookupDelegate;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.tcl.core.TclCheckContentExclude;
import org.eclipse.dltk.tcl.core.TclPlugin;

public class TclLanguageToolkit
extends AbstractLanguageToolkit {
    private static final String TCL_CONTENT_TYPE = "org.eclipse.dltk.tclContentType";
    protected static IDLTKLanguageToolkit sInstance = new TclLanguageToolkit();
    private final TclCheckContentExclude contentExclude = new TclCheckContentExclude();

    private boolean acceptDir(IFileHandle f, IEnvironment environment) {
        IFileHandle[] listFiles;
        if (f.isDirectory() && (listFiles = f.getChildren()) != null) {
            int i = 0;
            while (i < listFiles.length) {
                if (listFiles[i].isFile() && DLTKContentTypeManager.isValidFileNameForContentType((IDLTKLanguageToolkit)TclLanguageToolkit.getDefault(), (String)listFiles[i].getName())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean validateSourcePackage(IPath path, IEnvironment environment) {
        IFileHandle[] members;
        IFileHandle file = environment.getFile(path);
        if (file.isDirectory() && (members = file.getChildren()) != null) {
            int i = 0;
            while (i < members.length) {
                String name = members[i].getName();
                if (DLTKContentTypeManager.isValidFileNameForContentType((IDLTKLanguageToolkit)this, (IPath)members[i].getPath())) {
                    return true;
                }
                if (name.toLowerCase().equals("pkgindex.tcl") || name.toLowerCase().equals("tclindex")) {
                    return true;
                }
                if (this.acceptDir(members[i], environment)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public String getNatureId() {
        return "org.eclipse.dltk.tcl.core.nature";
    }

    public static IDLTKLanguageToolkit getDefault() {
        return sInstance;
    }

    public String getLanguageName() {
        return "Tcl";
    }

    public String getLanguageContentType() {
        return TCL_CONTENT_TYPE;
    }

    public boolean canValidateContent(IResource resource) {
        IFileHandle file;
        boolean remote;
        boolean local;
        if (this.contentExclude.isExcluded(resource.getName())) {
            return false;
        }
        IProject project = resource.getProject();
        if (project == null) {
            return false;
        }
        PreferencesLookupDelegate delegate = new PreferencesLookupDelegate(project);
        if (TclLanguageToolkit.isEmptyExtension((String)resource.getName())) {
            local = delegate.getBoolean("org.eclipse.dltk.tcl.core", "check_content.empty_extension.local");
            remote = delegate.getBoolean("org.eclipse.dltk.tcl.core", "check_content.empty_extension.remote");
        } else {
            local = delegate.getBoolean("org.eclipse.dltk.tcl.core", "check_content.any_extension.local");
            remote = delegate.getBoolean("org.eclipse.dltk.tcl.core", "check_content.any_extension.remote");
        }
        if (local == remote) {
            return local;
        }
        IEnvironment environment = EnvironmentManager.getEnvironment((IProject)project);
        if (environment == null) {
            return false;
        }
        IPath location = resource.getLocation();
        if (location != null && (file = EnvironmentManager.getLocalEnvironment().getFile(location)).exists()) {
            return local;
        }
        return environment.isLocal() ? local : remote;
    }

    public boolean canValidateContent(File file) {
        if (this.contentExclude.isExcluded(file.getName())) {
            return false;
        }
        return TclPlugin.getDefault().getPluginPreferences().getBoolean(TclLanguageToolkit.isEmptyExtension((String)file.getName()) ? "check_content.empty_extension.local" : "check_content.any_extension.local");
    }

    public boolean canValidateContent(IFileHandle file) {
        if (this.contentExclude.isExcluded(file.getName())) {
            return false;
        }
        return TclPlugin.getDefault().getPluginPreferences().getBoolean(TclLanguageToolkit.isEmptyExtension((String)file.getName()) ? "check_content.empty_extension.remote" : "check_content.any_extension.remote");
    }

    public String getPreferenceQualifier() {
        return "org.eclipse.dltk.tcl.core";
    }
}

