/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.ide;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ide.hook.IResourceSetHook;
import org.eclipse.emf.compare.uml2.rcp.internal.policy.UMLLoadOnDemandPolicy;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.uml2.common.util.CacheAdapter;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;

public class ResourceSetProfileUnloader
extends UMLLoadOnDemandPolicy
implements IResourceSetHook {
    public boolean isHookFor(Collection<? extends URI> uris) {
        for (URI uRI : uris) {
            if (!"uml".equals(uRI.fileExtension())) continue;
            return true;
        }
        return false;
    }

    public void preLoadingHook(ResourceSet resourceSet, Collection<? extends URI> uris) {
    }

    public void postLoadingHook(ResourceSet resourceSet, Collection<? extends URI> uris) {
    }

    public void onDispose(Iterable<Resource> resources) {
        ExtensibleURIConverterImpl uriConverter = new ExtensibleURIConverterImpl();
        for (Resource resource : resources) {
            URI uri;
            URI normalizedURI;
            if (!resource.isLoaded() || !this.isConventionalURIForUMLProfile(normalizedURI = uriConverter.normalize(uri = resource.getURI())) && !this.isUMLMetaModel(normalizedURI) && !this.isRegisteredUMLProfile(normalizedURI, (URIConverter)uriConverter)) continue;
            for (EObject child : resource.getContents()) {
                if (!(child instanceof Profile)) continue;
                this.disposeProfileApplications((Profile)child);
                break;
            }
            resource.unload();
        }
    }

    private void disposeProfileApplications(Profile profile) {
        LinkedHashSet<Resource> unloadMe = new LinkedHashSet<Resource>();
        Collection settings = CacheAdapter.getInstance().getInverseReferences((EObject)profile, false);
        for (EStructuralFeature.Setting setting : settings) {
            if (!(setting.getEObject() instanceof ProfileApplication)) continue;
            unloadMe.add(setting.getEObject().eResource());
        }
        for (Resource unload : unloadMe) {
            if (!unload.isLoaded()) continue;
            unload.unload();
        }
    }
}

