/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.viewers;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.parsley.ui.provider.DelegatingColumnLabelProvider;
import org.eclipse.emf.parsley.ui.provider.FeatureCaptionProvider;
import org.eclipse.emf.parsley.ui.provider.TableFeaturesProvider;
import org.eclipse.emf.parsley.viewers.ColumnLabelProviderFactory;
import org.eclipse.emf.parsley.viewers.LayoutHelper;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;

public class TreeViewerColumnBuilder {
    @Inject
    @Named(value="DefaultTableColumnWeight")
    private int defaultWeight;
    @Inject
    @Named(value="TableColumnWeights")
    private List<Integer> weights;
    @Inject
    private ColumnLabelProviderFactory columnLabelProviderFactory;
    @Inject
    private DelegatingColumnLabelProvider delegatingColumnLabelProvider;
    @Inject
    private FeatureCaptionProvider featureCaptionProvider;
    @Inject
    private TableFeaturesProvider featuresProvider;
    @Inject
    private LayoutHelper layoutHelper;

    public void buildTreeViewer(TreeViewer treeViewer, EClass eClass) {
        this.buildTreeViewer(treeViewer, eClass, this.featuresProvider.getFeatures(eClass));
    }

    public void buildTreeViewer(TreeViewer treeViewer, List<EStructuralFeature> typeFeatures) {
        this.buildTreeViewer(treeViewer, null, typeFeatures);
    }

    protected void buildTreeViewer(TreeViewer treeViewer, EClass eClass, List<EStructuralFeature> typeFeatures) {
        Layout layout = this.layoutHelper.adjustForTableLayout(treeViewer);
        int i = 0;
        this.createMainTreeViewerColumn(treeViewer, layout, this.customWeightOrDefaultWeight(i++));
        for (EStructuralFeature eStructuralFeature : typeFeatures) {
            this.buildTreeViewerColumn(treeViewer, layout, eClass != null ? eClass : eStructuralFeature.getEContainingClass(), eStructuralFeature, this.customWeightOrDefaultWeight(i++));
        }
    }

    private int customWeightOrDefaultWeight(int i) {
        int weight = this.defaultWeight;
        if (this.weights.size() > i) {
            weight = this.weights.get(i);
        }
        return weight;
    }

    protected TreeViewerColumn buildTreeViewerColumn(TreeViewer treeViewer, Layout layout, EClass eClass, EStructuralFeature eStructuralFeature, int weight) {
        TreeViewerColumn viewerColumn = this.createTreeViewerColumn(treeViewer, eStructuralFeature);
        TreeColumn objectColumn = viewerColumn.getColumn();
        this.layoutHelper.adjustLayoutColumnData(layout, (Widget)objectColumn, weight);
        objectColumn.setText(this.featureCaptionProvider.getText(eClass, eStructuralFeature));
        objectColumn.setResizable(true);
        return viewerColumn;
    }

    protected TreeViewerColumn createMainTreeViewerColumn(TreeViewer treeViewer, Layout layout, int weight) {
        TreeViewerColumn viewerColumn = new TreeViewerColumn(treeViewer, 0);
        viewerColumn.setLabelProvider((CellLabelProvider)this.delegatingColumnLabelProvider);
        TreeColumn objectColumn = viewerColumn.getColumn();
        this.layoutHelper.adjustLayoutColumnData(layout, (Widget)objectColumn, weight);
        objectColumn.setResizable(true);
        return viewerColumn;
    }

    protected TreeViewerColumn createTreeViewerColumn(TreeViewer treeViewer, EStructuralFeature eStructuralFeature) {
        TreeViewerColumn treeViewerColumn = new TreeViewerColumn(treeViewer, 0);
        treeViewerColumn.setLabelProvider((CellLabelProvider)this.columnLabelProviderFactory.createColumnLabelProvider(eStructuralFeature));
        return treeViewerColumn;
    }
}

