/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.orm;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.jpa.core.context.NamedColumn;
import org.eclipse.jpt.jpa.core.context.OrderBy;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmAttributeMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.internal.context.JpaValidator;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmXmlContextModel;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.orm.GenericOrmOrderBy;
import org.eclipse.jpt.jpa.core.internal.jpa2.context.OrderColumnValidator;
import org.eclipse.jpt.jpa.core.jpa2.context.SpecifiedOrderColumn2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.orm.OrmOrderable2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.orm.OrmSpecifiedOrderColumn2_0;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlOrderBy;
import org.eclipse.jpt.jpa.core.resource.orm.XmlOrderColumn;
import org.eclipse.jpt.jpa.core.resource.orm.XmlOrderable;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

public class GenericOrmOrderable
extends AbstractOrmXmlContextModel<OrmAttributeMapping>
implements OrmOrderable2_0 {
    protected final OrmOrderable2_0.ParentAdapter parentAdapter;
    protected boolean noOrdering = false;
    protected boolean orderByOrdering = false;
    protected OrderBy orderBy;
    protected boolean orderColumnOrdering = false;
    protected OrmSpecifiedOrderColumn2_0 orderColumn;

    public GenericOrmOrderable(OrmAttributeMapping parent) {
        this(new OrmOrderable2_0.ParentAdapter.Null(parent));
    }

    public GenericOrmOrderable(OrmOrderable2_0.ParentAdapter parentAdapter) {
        super((OrmAttributeMapping)parentAdapter.getOrderableParent());
        this.parentAdapter = parentAdapter;
        this.initNoOrdering();
        this.initOrderBy();
        this.initOrderColumn();
    }

    @Override
    public void synchronizeWithResourceModel(IProgressMonitor monitor) {
        super.synchronizeWithResourceModel(monitor);
        this.synchNoOrdering();
        this.syncOrderBy(monitor);
        this.syncOrderColumn(monitor);
    }

    @Override
    public void update(IProgressMonitor monitor) {
        super.update(monitor);
        this.updateOrderBy(monitor);
        this.updateOrderColumn(monitor);
    }

    @Override
    public boolean isNoOrdering() {
        return this.noOrdering;
    }

    @Override
    public void setNoOrdering() {
        this.setNoOrdering_(true);
        this.setOrderByOrdering_(false);
        this.setOrderColumnOrdering_(false);
        this.removeXmlOrderBy();
        this.removeXmlOrderColumn();
    }

    protected void setNoOrdering_(boolean noOrdering) {
        boolean old = this.noOrdering;
        this.noOrdering = noOrdering;
        this.firePropertyChanged("noOrdering", old, noOrdering);
    }

    protected void initNoOrdering() {
        this.noOrdering = this.buildNoOrdering();
    }

    protected void synchNoOrdering() {
        this.setNoOrdering_(this.buildNoOrdering());
    }

    protected boolean buildNoOrdering() {
        return this.isJpa2_0Compatible() ? this.buildNoOrdering2_0() : this.buildNoOrdering1_0();
    }

    protected boolean buildNoOrdering2_0() {
        return this.getXmlOrderBy() == null && this.getXmlOrderColumn() == null;
    }

    protected boolean buildNoOrdering1_0() {
        return this.getXmlOrderBy() == null;
    }

    @Override
    public boolean isOrderByOrdering() {
        return this.orderByOrdering;
    }

    @Override
    public void setOrderByOrdering() {
        this.setNoOrdering_(false);
        this.setOrderByOrdering_(true);
        this.setOrderColumnOrdering_(false);
        this.addXmlOrderBy();
        this.removeXmlOrderColumn();
    }

    protected void setOrderByOrdering_(boolean newOrderByOrdering) {
        boolean old = this.orderByOrdering;
        this.orderByOrdering = newOrderByOrdering;
        this.firePropertyChanged("orderByOrdering", old, newOrderByOrdering);
    }

    @Override
    public OrderBy getOrderBy() {
        return this.orderBy;
    }

    protected void initOrderBy() {
        this.orderByOrdering = this.buildOrderByOrdering();
        this.orderBy = this.buildOrderBy();
    }

    protected void syncOrderBy(IProgressMonitor monitor) {
        this.setOrderByOrdering_(this.buildOrderByOrdering());
        this.orderBy.synchronizeWithResourceModel(monitor);
    }

    protected void updateOrderBy(IProgressMonitor monitor) {
        this.orderBy.update(monitor);
    }

    protected boolean buildOrderByOrdering() {
        return this.isJpa2_0Compatible() ? this.buildOrderByOrdering2_0() : this.buildOrderByOrdering1_0();
    }

    protected boolean buildOrderByOrdering2_0() {
        return this.getXmlOrderBy() != null && this.getXmlOrderColumn() == null;
    }

    protected boolean buildOrderByOrdering1_0() {
        return this.getXmlOrderBy() != null;
    }

    protected OrderBy buildOrderBy() {
        return new GenericOrmOrderBy(this, new OrderByContext());
    }

    @Override
    public boolean isOrderColumnOrdering() {
        return this.orderColumnOrdering;
    }

    @Override
    public void setOrderColumnOrdering() {
        this.setNoOrdering_(false);
        this.setOrderByOrdering_(false);
        this.setOrderColumnOrdering_(true);
        this.removeXmlOrderBy();
        this.addXmlOrderColumn();
    }

    protected void setOrderColumnOrdering_(boolean orderColumnOrdering) {
        boolean old = this.orderColumnOrdering;
        this.orderColumnOrdering = orderColumnOrdering;
        this.firePropertyChanged("orderColumnOrdering", old, orderColumnOrdering);
    }

    @Override
    public OrmSpecifiedOrderColumn2_0 getOrderColumn() {
        return this.orderColumn;
    }

    protected void initOrderColumn() {
        this.orderColumnOrdering = this.buildOrderColumnOrdering();
        this.orderColumn = this.buildOrderColumn();
    }

    protected void syncOrderColumn(IProgressMonitor monitor) {
        this.setOrderColumnOrdering_(this.buildOrderColumnOrdering());
        if (this.orderColumn != null) {
            this.orderColumn.synchronizeWithResourceModel(monitor);
        }
    }

    protected void updateOrderColumn(IProgressMonitor monitor) {
        if (this.orderColumn != null) {
            this.orderColumn.update(monitor);
        }
    }

    protected boolean buildOrderColumnOrdering() {
        return this.isJpa2_0Compatible() ? this.getXmlOrderColumn() != null : false;
    }

    protected OrmSpecifiedOrderColumn2_0 buildOrderColumn() {
        return this.isOrmXml2_0Compatible() ? this.getContextModelFactory2_0().buildOrmOrderColumn(new OrderColumnParentAdapter()) : null;
    }

    protected XmlOrderBy getXmlOrderBy() {
        return this.getXmlOrderable().getOrderBy();
    }

    protected XmlOrderBy addXmlOrderBy() {
        XmlOrderBy xmlOrderBy = OrmFactory.eINSTANCE.createXmlOrderBy();
        this.getXmlOrderable().setOrderBy(xmlOrderBy);
        return xmlOrderBy;
    }

    protected void removeXmlOrderBy() {
        this.getXmlOrderable().setOrderBy(null);
    }

    protected XmlOrderColumn getXmlOrderColumn() {
        return this.getXmlOrderable().getOrderColumn();
    }

    protected XmlOrderColumn addXmlOrderColumn() {
        XmlOrderColumn xmlColumn = OrmFactory.eINSTANCE.createXmlOrderColumn();
        this.getXmlOrderable().setOrderColumn(xmlColumn);
        return xmlColumn;
    }

    protected void removeXmlOrderColumn() {
        this.getXmlOrderable().setOrderColumn(null);
    }

    protected OrmAttributeMapping getAttributeMapping() {
        return (OrmAttributeMapping)this.parent;
    }

    protected OrmSpecifiedPersistentAttribute getPersistentAttribute() {
        return this.getAttributeMapping().getPersistentAttribute();
    }

    protected XmlOrderable getXmlOrderable() {
        return (XmlOrderable)((Object)this.getAttributeMapping().getXmlAttributeMapping());
    }

    @Override
    public String getDefaultTableName() {
        return this.parentAdapter.getTableName();
    }

    protected Table resolveDbTable(String tableName) {
        return this.parentAdapter.resolveDbTable(tableName);
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.getXmlOrderable().getValidationTextRange();
        return textRange != null ? textRange : this.getAttributeMapping().getValidationTextRange();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        if (this.orderColumnOrdering) {
            this.orderColumn.validate(messages, reporter);
        }
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        if (this.orderColumn != null && (result = this.orderColumn.getCompletionProposals(pos)) != null) {
            return result;
        }
        return null;
    }

    protected class OrderByContext
    implements GenericOrmOrderBy.Context {
        protected OrderByContext() {
        }

        @Override
        public XmlOrderBy getXmlOrderBy(boolean addIfAbsent) {
            XmlOrderBy xmlOrderBy = GenericOrmOrderable.this.getXmlOrderBy();
            if (xmlOrderBy == null && addIfAbsent) {
                xmlOrderBy = GenericOrmOrderable.this.addXmlOrderBy();
            }
            return xmlOrderBy;
        }
    }

    public class OrderColumnParentAdapter
    implements OrmSpecifiedOrderColumn2_0.ParentAdapter {
        @Override
        public OrmOrderable2_0 getColumnParent() {
            return GenericOrmOrderable.this;
        }

        @Override
        public String getDefaultTableName() {
            return GenericOrmOrderable.this.getDefaultTableName();
        }

        @Override
        public Table resolveDbTable(String tableName) {
            return GenericOrmOrderable.this.resolveDbTable(tableName);
        }

        @Override
        public String getDefaultColumnName(NamedColumn column) {
            return this.getPersistentAttribute().getName() + "_ORDER";
        }

        @Override
        public TextRange getValidationTextRange() {
            return GenericOrmOrderable.this.getValidationTextRange();
        }

        @Override
        public JpaValidator buildColumnValidator(NamedColumn column) {
            return new OrderColumnValidator((PersistentAttribute)this.getPersistentAttribute(), (SpecifiedOrderColumn2_0)column);
        }

        @Override
        public XmlOrderColumn getXmlColumn() {
            return GenericOrmOrderable.this.getXmlOrderColumn();
        }

        @Override
        public XmlOrderColumn buildXmlColumn() {
            return GenericOrmOrderable.this.addXmlOrderColumn();
        }

        @Override
        public void removeXmlColumn() {
            GenericOrmOrderable.this.removeXmlOrderColumn();
        }

        protected OrmSpecifiedPersistentAttribute getPersistentAttribute() {
            return GenericOrmOrderable.this.getPersistentAttribute();
        }
    }
}

