/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.refactoring;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.common.core.internal.utility.TypeTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.internal.plugin.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.internal.refactoring.AbstractJpaRenameJavaElementParticipant;
import org.eclipse.jpt.jpa.core.refactoring.JptJpaCoreRefactoringMessages;
import org.eclipse.text.edits.ReplaceEdit;

public class JpaRenameTypeParticipant
extends AbstractJpaRenameJavaElementParticipant {
    protected final Collection<IType> nestedTypes = new ArrayList<IType>();

    public String getName() {
        return JptJpaCoreRefactoringMessages.JPA_RENAME_TYPE_REFACTORING_PARTICIPANT_NAME;
    }

    protected IType getOriginalType() {
        return (IType)super.getOriginalJavaElement();
    }

    @Override
    protected boolean initialize(Object element) {
        boolean initialize = super.initialize(element);
        if (initialize) {
            this.addNestedTypes(this.getOriginalType());
            return true;
        }
        return false;
    }

    protected void addNestedType(IType renamedType) {
        this.nestedTypes.add(renamedType);
        this.addNestedTypes(renamedType);
    }

    private void addNestedTypes(IType renamedType) {
        IType[] iTypeArray = TypeTools.getTypes((IType)renamedType);
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType nestedType = iTypeArray[n2];
            this.addNestedType(nestedType);
            ++n2;
        }
    }

    @Override
    protected Iterable<ReplaceEdit> createPersistenceXmlReplaceEdits(PersistenceUnit persistenceUnit) {
        return IterableTools.concatenate((Iterable[])new Iterable[]{this.createPersistenceXmlReplaceOriginalTypeEdits(persistenceUnit), this.createPersistenceXmlReplaceNestedTypeEdits(persistenceUnit)});
    }

    private Iterable<ReplaceEdit> createPersistenceXmlReplaceOriginalTypeEdits(PersistenceUnit persistenceUnit) {
        return persistenceUnit.createRenameTypeEdits(this.getOriginalType(), this.getNewName());
    }

    private Iterable<ReplaceEdit> createPersistenceXmlReplaceNestedTypeEdits(PersistenceUnit persistenceUnit) {
        return IterableTools.children(this.nestedTypes, (Transformer)new PersistenceUnitNestedTypeRenameTypeEditsTransformer(persistenceUnit));
    }

    @Override
    protected Iterable<ReplaceEdit> createMappingFileReplaceEdits(MappingFileRef mappingFileRef) {
        return IterableTools.concatenate((Iterable[])new Iterable[]{this.createMappingFileReplaceOriginalTypeEdits(mappingFileRef), this.createMappingFileReplaceNestedTypeEdits(mappingFileRef)});
    }

    private Iterable<ReplaceEdit> createMappingFileReplaceOriginalTypeEdits(MappingFileRef mappingFileRef) {
        return mappingFileRef.createRenameTypeEdits(this.getOriginalType(), this.getNewName());
    }

    private Iterable<ReplaceEdit> createMappingFileReplaceNestedTypeEdits(MappingFileRef mappingFileRef) {
        return IterableTools.children(this.nestedTypes, (Transformer)new MappingFileNestedTypeRenameTypeEditsTransformer(mappingFileRef));
    }

    protected String getNewName() {
        Object newName = this.getArguments().getNewName();
        try {
            if (this.getOriginalType().isMember()) {
                newName = this.getOriginalType().getTypeQualifiedName().substring(0, this.getOriginalType().getTypeQualifiedName().lastIndexOf(36)) + "$" + (String)newName;
            }
        }
        catch (JavaModelException e) {
            JptJpaCorePlugin.instance().logError(e);
        }
        return newName;
    }

    protected String getNewNameForNestedType(IType nestedType) {
        return nestedType.getTypeQualifiedName('$').replaceFirst(this.getOriginalType().getElementName(), this.getArguments().getNewName());
    }

    @Override
    protected String getCheckConditionsSubTaskName() {
        return JptJpaCoreRefactoringMessages.JPA_RENAME_TYPE_REFACTORING_SUB_TASK_NAME;
    }

    @Override
    protected String getCreateChangeSubTaskName() {
        return JptJpaCoreRefactoringMessages.JPA_RENAME_TYPE_REFACTORING_SUB_TASK_NAME;
    }

    @Override
    protected String getCompositeChangeName() {
        return JptJpaCoreRefactoringMessages.JPA_RENAME_TYPE_REFACTORING_CHANGE_NAME;
    }

    @Override
    protected String getPersistenceXmlChangeName() {
        return JptJpaCoreRefactoringMessages.JPA_RENAME_TYPE_REFACTORING_CHANGE_PERSISTENCE_XML_NAME;
    }

    @Override
    protected String getMappingFileChangeName() {
        return JptJpaCoreRefactoringMessages.JPA_RENAME_TYPE_REFACTORING_CHANGE_MAPPING_FILE_NAME;
    }

    public class MappingFileNestedTypeRenameTypeEditsTransformer
    extends TransformerAdapter<IType, Iterable<ReplaceEdit>> {
        protected final MappingFileRef mappingFileRef;

        public MappingFileNestedTypeRenameTypeEditsTransformer(MappingFileRef mappingFileRef) {
            this.mappingFileRef = mappingFileRef;
        }

        public Iterable<ReplaceEdit> transform(IType nestedType) {
            String newName = JpaRenameTypeParticipant.this.getNewNameForNestedType(nestedType);
            return this.mappingFileRef.createRenameTypeEdits(nestedType, newName);
        }
    }

    public class PersistenceUnitNestedTypeRenameTypeEditsTransformer
    extends TransformerAdapter<IType, Iterable<ReplaceEdit>> {
        protected final PersistenceUnit persistenceUnit;

        public PersistenceUnitNestedTypeRenameTypeEditsTransformer(PersistenceUnit persistenceUnit) {
            this.persistenceUnit = persistenceUnit;
        }

        public Iterable<ReplaceEdit> transform(IType nestedType) {
            String newName = JpaRenameTypeParticipant.this.getNewNameForNestedType(nestedType);
            return this.persistenceUnit.createRenameTypeEdits(nestedType, newName);
        }
    }
}

