/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.feature;

import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.impl.AbstractCreateFeature;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.editor.IDiagramContainerUI;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.i18n.JPAEditorMessages;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;

public class ClickAddAttributeButtonFeature
extends AbstractCreateFeature {
    public ClickAddAttributeButtonFeature(IFeatureProvider provider) {
        super(provider, "", "");
    }

    public boolean canExecute(IContext context) {
        return true;
    }

    public boolean canUndo(IContext context) {
        return false;
    }

    public boolean canCreate(ICreateContext context) {
        return true;
    }

    public Object[] create(ICreateContext context) {
        ContainerShape entityShape = context.getTargetContainer();
        PersistentType jpt = (PersistentType)this.getFeatureProvider().getBusinessObjectForPictogramElement((PictogramElement)entityShape);
        String newAttrName = JpaArtifactFactory.instance().createNewAttribute(jpt, false, this.getFeatureProvider());
        PersistentAttribute newAttr = jpt.resolveAttribute(newAttrName);
        this.getFeatureProvider().addAddIgnore((PersistentType)newAttr.getParent(), newAttr.getName());
        JpaArtifactFactory.instance().addOrmPersistentAttribute(jpt, newAttr, null);
        this.addGraphicalRepresentation((IAreaContext)context, newAttr);
        this.getFeatureProvider().getDirectEditingInfo().setActive(true);
        IWorkbenchPartSite ws = ((IDiagramContainerUI)this.getFeatureProvider().getDiagramTypeProvider().getDiagramBehavior().getDiagramContainer()).getSite();
        ICompilationUnit cu = this.getFeatureProvider().getCompilationUnit(jpt);
        this.getFeatureProvider().getJPAEditorUtil().formatCode(cu, (IWorkbenchSite)ws);
        return new Object[]{newAttr};
    }

    public boolean isAvailable(IContext context) {
        return true;
    }

    public String getName() {
        return JPAEditorMessages.ClickAddAttributeButtonFeature_createAttributeButtonLabel;
    }

    public String getDescription() {
        return JPAEditorMessages.ClickAddAttributeButtonFeature_createAttributeButtonDescription;
    }

    public IJPAEditorFeatureProvider getFeatureProvider() {
        return (IJPAEditorFeatureProvider)super.getFeatureProvider();
    }
}

