/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.project.facet;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.internal.resources.XMLWriter;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.common.project.facet.WtpUtils;
import org.eclipse.jst.common.project.facet.core.ClasspathHelper;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualComponent;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.ejb.internal.plugin.EjbPlugin;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.jst.j2ee.project.facet.J2EEFacetInstallDelegate;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class EjbFacetInstallDelegate
extends J2EEFacetInstallDelegate
implements IDelegate {
    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.beginTask("", 1);
        }
        try {
            IDataModel model = (IDataModel)config;
            IJavaProject jproj = JavaCore.create((IProject)project);
            WtpUtils.addNatures((IProject)project);
            IWorkspace ws = ResourcesPlugin.getWorkspace();
            IPath pjpath = project.getFullPath();
            IVirtualComponent c = ComponentCore.createComponent((IProject)project, (boolean)false);
            c.create(0, null);
            this.setOutputFolder(model, c);
            IVirtualFolder ejbroot = c.getRootFolder();
            IFolder ejbFolder = null;
            String configFolder = null;
            configFolder = model.getStringProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER");
            Path configFolderPath = new Path(configFolder);
            ejbroot.createLink((IPath)configFolderPath, 0, null);
            J2EEModuleVirtualComponent.setDefaultDeploymentDescriptorFolder((IVirtualFolder)ejbroot, (IPath)configFolderPath, null);
            IPath ejbFolderpath = pjpath.append(configFolder);
            ejbFolder = ws.getRoot().getFolder(ejbFolderpath);
            IFile vf = ejbFolder.getFile((IPath)new Path("META-INF/MANIFEST.MF"));
            if (vf == null || !vf.exists()) {
                try {
                    this.createManifest(project, (IContainer)ejbFolder, monitor);
                }
                catch (InvocationTargetException e) {
                    EjbPlugin.logError(e);
                }
                catch (InterruptedException e) {
                    EjbPlugin.logError(e);
                }
            }
            if (fv == IJ2EEFacetConstants.EJB_40 || fv == IJ2EEFacetConstants.EJB_32 || fv == IJ2EEFacetConstants.EJB_31 || fv == IJ2EEFacetConstants.EJB_30) {
                IFile ejbJarXmlFile;
                if (model.getBooleanProperty("IJ2EEFacetInstallDataModelProperties.GENERATE_DD") && !(ejbJarXmlFile = ejbFolder.getFile("META-INF/ejb-jar.xml")).exists()) {
                    try {
                        String ejbJarXmlContents = null;
                        ejbJarXmlContents = fv == IJ2EEFacetConstants.EJB_40 ? "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<ejb-jar version=\"4.0\" xmlns=\"https://jakarta.ee/xml/ns/jakartaee\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"https://jakarta.ee/xml/ns/jakartaee https://jakarta.ee/xml/ns/jakartaee/ejb-jar_4_0.xsd\">\n  <display-name>" + XMLWriter.getEscaped((String)project.getName()) + " </display-name> \n </ejb-jar>" : (fv == IJ2EEFacetConstants.EJB_32 ? "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<ejb-jar version=\"3.2\" xmlns=\"http://xmlns.jcp.org/xml/ns/javaee\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://xmlns.jcp.org/xml/ns/javaee http://xmlns.jcp.org/xml/ns/javaee/ejb-jar_3_2.xsd\">\n  <display-name>" + XMLWriter.getEscaped((String)project.getName()) + " </display-name> \n </ejb-jar>" : (fv == IJ2EEFacetConstants.EJB_31 ? "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<ejb-jar version=\"3.1\" xmlns=\"http://java.sun.com/xml/ns/javaee\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/ejb-jar_3_1.xsd\">\n  <display-name>" + XMLWriter.getEscaped((String)project.getName()) + " </display-name> \n </ejb-jar>" : "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<ejb-jar version=\"3.0\" xmlns=\"http://java.sun.com/xml/ns/javaee\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/ejb-jar_3_0.xsd\">\n  <display-name>" + XMLWriter.getEscaped((String)project.getName()) + " </display-name> \n </ejb-jar>"));
                        ejbJarXmlFile.create((InputStream)new ByteArrayInputStream(ejbJarXmlContents.getBytes("UTF-8")), true, monitor);
                    }
                    catch (UnsupportedEncodingException e) {
                        EjbPlugin.logError(e);
                    }
                }
            } else if (!ejbFolder.getFile("META-INF/ejb-jar.xml").exists()) {
                String ver = model.getStringProperty("IFacetDataModelProperties.FACET_VERSION_STR");
                int nVer = J2EEVersionUtil.convertVersionStringToInt((String)ver);
                EJBArtifactEdit.createDeploymentDescriptor(project, nVer);
            }
            IClasspathEntry[] cp = jproj.getRawClasspath();
            int i = 0;
            while (i < cp.length) {
                IClasspathEntry cpe = cp[i];
                if (cpe.getEntryKind() == 3) {
                    ejbroot.createLink(cpe.getPath().removeFirstSegments(1), 0, null);
                }
                ++i;
            }
            ClasspathHelper.removeClasspathEntries((IProject)project, (IProjectFacetVersion)fv);
            ClasspathHelper.addClasspathEntries((IProject)project, (IProjectFacetVersion)fv);
            if (model.getBooleanProperty("IJ2EEModuleFacetInstallDataModelProperties.INSTALL_EAR_LIBRARY")) {
                Path earLibContainer = new Path("org.eclipse.jst.j2ee.internal.module.container");
                EjbFacetInstallDelegate.addToClasspath((IJavaProject)jproj, (IClasspathEntry)JavaCore.newContainerEntry((IPath)earLibContainer));
            }
            try {
                ((IDataModelOperation)model.getProperty("FacetDataModelProvider.NOTIFICATION_OPERATION")).execute(monitor, null);
            }
            catch (ExecutionException e) {
                EjbPlugin.logError(e);
            }
            if (monitor != null) {
                monitor.worked(1);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }
}

