/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.jsflibraryregistry.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.util.Messages;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.util.MigrateV1toV2Operation;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.util.UpgradeOperation;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.util.UpgradeStatus;

public class JSFLibraryRegistryUpgradeUtil {
    static String v1Tov2UpgradeURL = "http://www.eclipse.org/JSFxxxxxxxxxxxxxxxxxxxxxx";
    private UpgradeStatus upgradeStatus;
    public static final String JSF_LIBRARY_REGISTRY_V1_URL = ".metadata/.plugins/org.eclipse.jst.jsf.core/JSFLibraryRegistry.xml";
    public static final String JSF_LIBRARY_REGISTRY_V2_URL = ".metadata/.plugins/org.eclipse.jst.jsf.core/JSFLibraryRegistryV2.xml";
    public static final String JSF_LIBRARY_REGISTRY_LATESTVERSION_URL = ".metadata/.plugins/org.eclipse.jst.jsf.core/JSFLibraryRegistryV2.xml";
    public static final int LATESTVERSION = 2;
    private static final int NO_VERSION = 0;
    private static JSFLibraryRegistryUpgradeUtil INSTANCE;

    public static synchronized JSFLibraryRegistryUpgradeUtil getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new JSFLibraryRegistryUpgradeUtil();
        }
        return INSTANCE;
    }

    public static URI getRegistryURI(String registryVersion) throws MalformedURLException {
        URL jsfLibRegURL = new URL(Platform.getInstanceLocation().getURL(), registryVersion);
        return URI.createURI((String)jsfLibRegURL.toString());
    }

    public static String getBackupFileName(String originalFile) {
        return originalFile.concat(".bkp");
    }

    public void upgradeRegistryIfNecessary(int expectedVersion) {
        try {
            int curVersion = this.getCurVersion();
            if (curVersion < expectedVersion && curVersion != 0) {
                UpgradeOperation op = this.getUpgradeOperation(curVersion);
                if (op.canExecute()) {
                    try {
                        this.upgradeStatus = (UpgradeStatus)op.execute((IProgressMonitor)new NullProgressMonitor(), null);
                        this.upgradeStatus.setUpgradeOperation(op);
                    }
                    catch (ExecutionException e) {
                        JSFCorePlugin.log(4, "Error during loading JSF Library registry", e);
                        this.upgradeStatus = new UpgradeStatus(4, true, Messages.JSFLibraryRegistryUpgradeUtil_Error);
                    }
                } else {
                    this.upgradeStatus = new UpgradeStatus(4, false, Messages.JSFLibraryRegistryUpgradeUtil_Error);
                }
            } else {
                this.upgradeStatus = new UpgradeStatus();
            }
        }
        catch (MalformedURLException e) {
            JSFCorePlugin.log(4, "Error during loading JSF Library registry", e);
        }
    }

    private int getCurVersion() throws MalformedURLException {
        URI v2File = JSFLibraryRegistryUpgradeUtil.getRegistryURI(".metadata/.plugins/org.eclipse.jst.jsf.core/JSFLibraryRegistryV2.xml");
        File file = new File(v2File.toFileString());
        if (file.exists()) {
            return 2;
        }
        URI v1File = JSFLibraryRegistryUpgradeUtil.getRegistryURI(JSF_LIBRARY_REGISTRY_V1_URL);
        file = new File(v1File.toFileString());
        if (file.exists()) {
            return 1;
        }
        return 0;
    }

    protected UpgradeOperation getUpgradeOperation(int curVersion) throws MalformedURLException {
        UpgradeOperation op = new UpgradeOperation(Messages.JSFLibraryRegistryUpgradeUtil_Operation);
        switch (curVersion) {
            case 1: {
                op.addVersionUpgrade(new MigrateV1toV2Operation(Messages.JSFLibraryRegistryUpgradeUtil_v1Tov2Operation, JSFLibraryRegistryUpgradeUtil.getRegistryURI(JSF_LIBRARY_REGISTRY_V1_URL), JSFLibraryRegistryUpgradeUtil.getRegistryURI(".metadata/.plugins/org.eclipse.jst.jsf.core/JSFLibraryRegistryV2.xml")));
            }
        }
        return op;
    }

    public UpgradeStatus getUpgradeStatus() {
        return this.upgradeStatus;
    }

    static void deleteFile(String fileName) {
        File f = new File(fileName);
        if (f.exists()) {
            f.delete();
            if (f.exists()) {
                f.deleteOnExit();
            }
        }
    }

    static void copyFile(String srcFileName, String destFileName) {
        block21: {
            File srcFile = new File(srcFileName);
            File destFile = new File(destFileName);
            FileInputStream from = null;
            FileOutputStream to = null;
            try {
                try {
                    int bytesRead;
                    from = new FileInputStream(srcFile);
                    to = new FileOutputStream(destFile);
                    byte[] buffer = new byte[4096];
                    while ((bytesRead = from.read(buffer)) != -1) {
                        to.write(buffer, 0, bytesRead);
                    }
                }
                catch (IOException ioe) {
                    JSFCorePlugin.log(ioe, "Error during file copy");
                    if (from != null) {
                        try {
                            from.close();
                        }
                        catch (IOException e) {
                            JSFCorePlugin.log(e, "Error during file close");
                        }
                    }
                    if (to == null) break block21;
                    try {
                        to.close();
                    }
                    catch (IOException e) {
                        JSFCorePlugin.log(e, "Error during file close");
                    }
                }
            }
            finally {
                if (from != null) {
                    try {
                        from.close();
                    }
                    catch (IOException e) {
                        JSFCorePlugin.log(e, "Error during file close");
                    }
                }
                if (to != null) {
                    try {
                        to.close();
                    }
                    catch (IOException e) {
                        JSFCorePlugin.log(e, "Error during file close");
                    }
                }
            }
        }
    }
}

