/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.internal.view.model;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jst.jsf.common.internal.RunOnCompletionPattern;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.Namespace;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.designtime.internal.view.model.ITagRegistry;

public abstract class AbstractTagRegistry
implements ITagRegistry {
    private final List<ITagRegistry.ITagRegistryListener> _listeners;
    private final AtomicBoolean _isDisposed = new AtomicBoolean(false);

    protected AbstractTagRegistry() {
        this._listeners = new CopyOnWriteArrayList<ITagRegistry.ITagRegistryListener>();
    }

    @Override
    public final void addListener(ITagRegistry.ITagRegistryListener listener) {
        if (!this._listeners.contains(listener)) {
            this._listeners.add(listener);
        }
    }

    @Override
    public final void removeListener(ITagRegistry.ITagRegistryListener listener) {
        this._listeners.remove(listener);
    }

    protected final void fireEvent(ITagRegistry.TagRegistryChangeEvent event) {
        for (ITagRegistry.ITagRegistryListener listener : this._listeners) {
            try {
                listener.registryChanged(event);
            }
            catch (Exception e) {
                JSFCorePlugin.log(new Exception(e), "During change event notification");
            }
        }
    }

    @Override
    public abstract Collection<? extends Namespace> getAllTagLibraries();

    @Override
    public abstract Namespace getTagLibrary(String var1);

    @Override
    public final boolean isDisposed() {
        return this._isDisposed.get();
    }

    public final void destroy() {
        this.cleanupPersistentState();
        this.dispose();
    }

    protected abstract void cleanupPersistentState();

    public final void dispose() {
        if (this._isDisposed.compareAndSet(false, true)) {
            this.fireEvent(new ITagRegistry.TagRegistryChangeEvent(this, ITagRegistry.TagRegistryChangeEvent.EventType.REGISTRY_DISPOSED));
            this.doDispose();
        }
    }

    protected abstract void doDispose();

    @Override
    public final void refresh(Runnable runAfter, boolean flushCaches) {
        Job refreshJob = this.getRefreshJob(flushCaches);
        RunOnCompletionPattern runPattern = new RunOnCompletionPattern(refreshJob, runAfter);
        runPattern.run();
    }

    protected abstract Job getRefreshJob(boolean var1);
}

