/**
 * Copyright (c) 2016-2018 TypeFox and others.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */
package org.eclipse.lsp4j;

import org.eclipse.lsp4j.jsonrpc.ProtocolDraft;
import org.eclipse.lsp4j.jsonrpc.ProtocolSince;
import org.eclipse.lsp4j.jsonrpc.util.ToStringBuilder;

/**
 * Server capabilities specific to the diagnostic pull model.
 */
@ProtocolDraft
@ProtocolSince("3.18.0")
@SuppressWarnings("all")
public class DiagnosticServerCapabilities {
  /**
   * Whether the server supports {@link MarkupContent} in diagnostic messages.
   */
  private Boolean markupMessageSupport;

  public DiagnosticServerCapabilities() {
  }

  /**
   * Whether the server supports {@link MarkupContent} in diagnostic messages.
   */
  public Boolean getMarkupMessageSupport() {
    return this.markupMessageSupport;
  }

  /**
   * Whether the server supports {@link MarkupContent} in diagnostic messages.
   */
  public void setMarkupMessageSupport(final Boolean markupMessageSupport) {
    this.markupMessageSupport = markupMessageSupport;
  }

  @Override
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("markupMessageSupport", this.markupMessageSupport);
    return b.toString();
  }

  @Override
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    DiagnosticServerCapabilities other = (DiagnosticServerCapabilities) obj;
    if (this.markupMessageSupport == null) {
      if (other.markupMessageSupport != null)
        return false;
    } else if (!this.markupMessageSupport.equals(other.markupMessageSupport))
      return false;
    return true;
  }

  @Override
  public int hashCode() {
    return 31 * 1 + ((this.markupMessageSupport== null) ? 0 : this.markupMessageSupport.hashCode());
  }
}
