/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class ProjectUtils {
    public static String getRelativePath(IProject project, String absolutePath) {
        File basedir = project.getLocation().toFile();
        String relative = absolutePath.equals(basedir.getAbsolutePath()) ? "." : (absolutePath.startsWith(basedir.getAbsolutePath()) ? absolutePath.substring(basedir.getAbsolutePath().length() + 1) : absolutePath);
        return relative.replace('\\', '/');
    }

    public static IPath getM2eclipseWtpFolder(MavenProject mavenProject, IProject project) {
        return ProjectUtils.getBuildFolder(mavenProject, project).append("m2e-wtp");
    }

    public static IPath getBuildFolder(MavenProject mavenProject, IProject project) {
        String buildOutputDir = mavenProject.getBuild().getDirectory();
        String relativeBuildOutputDir = ProjectUtils.getRelativePath(project, buildOutputDir);
        return new Path(relativeBuildOutputDir);
    }

    public static IFolder getGeneratedWebResourcesFolder(MavenProject mavenProject, IProject project) {
        IPath m2eWtpFolder = ProjectUtils.getM2eclipseWtpFolder(mavenProject, project);
        return project.getFolder(m2eWtpFolder).getFolder("web-resources");
    }

    public static void hideM2eclipseWtpFolder(MavenProject mavenProject, IProject project) throws CoreException {
        IPath m2eclipseWtpPath = ProjectUtils.getM2eclipseWtpFolder(mavenProject, project);
        IFolder folder = project.getFolder(m2eclipseWtpPath);
        if (folder.exists()) {
            NullProgressMonitor monitor = new NullProgressMonitor();
            if (!folder.isDerived()) {
                folder.setDerived(true);
            }
            if (!folder.isHidden()) {
                folder.setHidden(true);
            }
            folder.getParent().refreshLocal(0, (IProgressMonitor)monitor);
        }
    }

    public static void createFolder(IFolder folder, IProgressMonitor monitor) throws CoreException {
        if (folder == null || folder.exists()) {
            return;
        }
        IContainer parent = folder.getParent();
        if (parent instanceof IFolder) {
            ProjectUtils.createFolder((IFolder)parent, monitor);
        }
        folder.create(true, true, monitor);
    }

    public static void removeNature(IProject project, String natureId, IProgressMonitor monitor) throws CoreException {
        if (project.hasNature(natureId)) {
            IProjectDescription description = project.getDescription();
            String[] prevNatures = description.getNatureIds();
            String[] newNatures = new String[prevNatures.length - 1];
            int i = 0;
            int j = 0;
            while (i < prevNatures.length) {
                if (!prevNatures[i].equals(natureId)) {
                    newNatures[j++] = prevNatures[i];
                }
                ++i;
            }
            description.setNatureIds(newNatures);
            project.setDescription(description, monitor);
        }
    }

    public static int refreshHierarchy(File basedir, int refreshDepth, IProgressMonitor monitor) throws CoreException {
        try {
            IContainer[] containers;
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            LinkedHashSet<IProject> projects = new LinkedHashSet<IProject>();
            IContainer[] iContainerArray = containers = root.findContainersForLocationURI(basedir.toURI());
            int n = containers.length;
            int n2 = 0;
            while (n2 < n) {
                IContainer container = iContainerArray[n2];
                if (monitor.isCanceled()) {
                    return 0;
                }
                ProjectUtils.collectProjects(container, projects);
                ++n2;
            }
            for (IProject p : projects) {
                if (monitor.isCanceled()) break;
                if (!p.isAccessible()) continue;
                p.refreshLocal(refreshDepth, monitor);
            }
            int n3 = projects.size();
            return n3;
        }
        finally {
            monitor.done();
        }
    }

    private static void collectProjects(IContainer c, Set<IProject> projects) {
        if (c == null) {
            return;
        }
        if (c instanceof IProject) {
            projects.add((IProject)c);
        } else if (c instanceof IFolder) {
            IFolder f = (IFolder)c;
            if (f.getProject() != null) {
                projects.add(f.getProject());
            }
            ProjectUtils.collectProjects(f.getParent(), projects);
        }
    }

    public static IFile getWebResourceFile(IProject project, String path) {
        IContainer[] underlyingFolders;
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component == null) {
            return null;
        }
        Path filePath = new Path(path);
        IContainer[] iContainerArray = underlyingFolders = component.getRootFolder().getUnderlyingFolders();
        int n = underlyingFolders.length;
        int n2 = 0;
        while (n2 < n) {
            IContainer underlyingFolder = iContainerArray[n2];
            IPath p = underlyingFolder.getProjectRelativePath().append((IPath)filePath);
            IFile f = project.getFile(p);
            if (f.exists()) {
                return f;
            }
            ++n2;
        }
        return null;
    }
}

