/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.facet.util.ui.internal.exported.util.tree.menu;

import java.util.Map;
import org.eclipse.modisco.facet.util.ui.internal.exported.util.tree.item.AbstractTreeItem;
import org.eclipse.modisco.facet.util.ui.internal.exported.util.tree.menu.ExtendedTreeMenu;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public abstract class AbstractTreeMenu<T> {
    private ExtendedTreeMenu<T> treeMenu;
    private MenuItem menuItem;
    private boolean menuItemCreated;
    private Map<String, Object> properties;

    public void refresh(ExtendedTreeMenu<T> menu) {
        this.treeMenu = menu;
        this.refreshMenu(this.treeMenu.getMenu());
    }

    public void refresh(ExtendedTreeMenu<T> menuTree, Menu menu) {
        this.treeMenu = menuTree;
        this.refreshMenu(menu);
    }

    private void refreshMenu(Menu menu) {
        if (this.isEnabled()) {
            if (this.isMenuItemCreated()) {
                this.deleteMenuItem();
            }
            this.setMenuItemCreated(true);
            this.menuItem = this.createMenuItem(menu);
        } else {
            this.deleteMenuItem();
            this.setMenuItemCreated(false);
        }
    }

    public boolean isEnabled(ExtendedTreeMenu<T> menuTree) {
        this.treeMenu = menuTree;
        return this.isEnabled();
    }

    public abstract boolean isEnabled();

    protected MenuItem createMenuItem(Menu parent) {
        MenuItem item = new MenuItem(parent, 0);
        item.setText(this.getMenuName());
        item.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AbstractTreeMenu.this.onMenuItemSelection();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        return item;
    }

    public abstract String getMenuName();

    public abstract T onMenuItemSelection();

    public void deleteMenuItem() {
        if (this.isMenuItemCreated() && this.menuItem != null && !this.menuItem.isDisposed()) {
            if (this.menuItem.getMenu() != null) {
                this.menuItem.getMenu().dispose();
            }
            this.menuItem.dispose();
        }
    }

    public ExtendedTreeMenu<T> getTreeMenu() {
        return this.treeMenu;
    }

    public void setExtraProperties(Map<String, Object> extraProperties) {
        this.properties = extraProperties;
    }

    public Tree getTree() {
        return this.treeMenu.getTree();
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public boolean isMenuItemCreated() {
        return this.menuItemCreated;
    }

    public void setMenuItemCreated(boolean menuItemCreated) {
        this.menuItemCreated = menuItemCreated;
    }

    public abstract AbstractTreeItem<T> getTreeItemExtended(TreeItem var1);

    public abstract boolean removeItem(TreeItem var1);
}

