/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.api.packages;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractDownloadClient {
    protected String baseUrl;
    protected boolean baseUrlParamEncoding = false;
    private Log log = LogFactory.getLog(AbstractDownloadClient.class);
    protected String filter = null;

    public AbstractDownloadClient() {
    }

    public AbstractDownloadClient(String baseUrl) {
        this();
        this.baseUrl = baseUrl;
    }

    public AbstractDownloadClient(String baseUrl, boolean baseUrlParamEncoding) {
        this();
        this.baseUrl = baseUrl;
        this.baseUrlParamEncoding = baseUrlParamEncoding;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrlParamEncoding(boolean baseUrlParamEncoding) {
        this.baseUrlParamEncoding = baseUrlParamEncoding;
    }

    public boolean getBaseUrlParamEncoding() {
        return this.baseUrlParamEncoding;
    }

    protected String createUrl(String param) {
        try {
            if (this.baseUrlParamEncoding) {
                param = URLEncoder.encode(param, StandardCharsets.UTF_8.name());
            }
            Object url = String.format(this.baseUrl, param);
            if (this.filter != null) {
                url = ((String)url).contains("?") ? (String)url + "&type=" + this.filter : (String)url + "?type=" + this.filter;
            }
            return url;
        }
        catch (UnsupportedEncodingException e) {
            this.log.error((Object)e);
            return null;
        }
    }

    public void setFilter(String filter) throws UnsupportedEncodingException {
        this.filter = URLEncoder.encode(filter, StandardCharsets.UTF_8.name());
    }
}

