/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.ui.tools.internal.editor.provider;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.sirius.common.tools.api.resource.FileProvider;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.ext.jface.viewers.IToolTipProvider;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.sirius.tree.TreeItemStyle;
import org.eclipse.sirius.tree.ui.provider.Messages;
import org.eclipse.sirius.tree.ui.provider.TreeUIPlugin;
import org.eclipse.sirius.ui.tools.api.color.VisualBindingManager;
import org.eclipse.sirius.ui.tools.api.provider.DSemanticTargetBasedLabelProvider;
import org.eclipse.sirius.ui.tools.internal.editor.DefaultFontStyler;
import org.eclipse.sirius.viewpoint.BasicLabelStyle;
import org.eclipse.sirius.viewpoint.FontFormat;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class DTreeItemLabelProvider
extends DSemanticTargetBasedLabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    public DTreeItemLabelProvider(AdapterFactory adapterFactoryLabelProvider) {
        super(adapterFactoryLabelProvider);
    }

    public Color getBackground(Object element) {
        RGBValues rgb;
        DTreeItem item;
        Color result = null;
        if (element instanceof DTreeItem && (item = (DTreeItem)element).getOwnedStyle() != null && (rgb = item.getOwnedStyle().getBackgroundColor()) != null) {
            result = VisualBindingManager.getDefault().getColorFromRGBValues(rgb);
        }
        return result;
    }

    public Font getFont(Object element) {
        DTreeItem item;
        Font resultFont = null;
        if (element instanceof DTreeItem && (item = (DTreeItem)element).getOwnedStyle() != null) {
            TreeItemStyle style = item.getOwnedStyle();
            resultFont = TreeUIPlugin.getPlugin().useStandardFont() ? VisualBindingManager.getDefault().getDefaultFontWithWorkbenchDefaultSizeAndFromLabelFormat((List)style.getLabelFormat()) : VisualBindingManager.getDefault().getFontFromLabelFormatAndSize((List)style.getLabelFormat(), style.getLabelSize());
        }
        return resultFont;
    }

    public Color getForeground(Object element) {
        RGBValues rgb;
        DTreeItem item;
        if (element instanceof DTreeItem && (item = (DTreeItem)element).getOwnedStyle() != null && item.getOwnedStyle().getLabelColor() != null && (rgb = item.getOwnedStyle().getLabelColor()) != null) {
            return VisualBindingManager.getDefault().getLabelColorFromRGBValues(rgb);
        }
        return null;
    }

    public Image getImage(Object element) {
        DTreeItem item;
        if (element instanceof DTreeItem && (item = (DTreeItem)element).getOwnedStyle() != null && item.getOwnedStyle().isShowIcon()) {
            Image labelImage = null;
            labelImage = StringUtil.isEmpty((String)item.getOwnedStyle().getIconPath()) ? super.getImage(element) : this.getCustomImage((BasicLabelStyle)item.getOwnedStyle());
            return labelImage;
        }
        return null;
    }

    private Image getCustomImage(BasicLabelStyle bls) {
        Image customImage = null;
        if (bls != null && !StringUtil.isEmpty((String)bls.getIconPath())) {
            ImageDescriptor descriptor = null;
            String iconPath = bls.getIconPath();
            File imageFile = FileProvider.getDefault().getFile((IPath)new Path(iconPath));
            if (imageFile != null && imageFile.exists() && imageFile.canRead()) {
                try {
                    descriptor = ImageDescriptor.createFromURL((URL)imageFile.toURI().toURL());
                }
                catch (MalformedURLException malformedURLException) {}
            }
            if (descriptor == null) {
                SiriusPlugin.getDefault().warning(MessageFormat.format(Messages.DTreeItemLabelProvider_iconFileNotFound, iconPath), null);
                descriptor = ImageDescriptor.getMissingImageDescriptor();
            }
            customImage = TreeUIPlugin.getImage(descriptor);
        }
        return customImage;
    }

    public String getText(Object element) {
        String result = "";
        if (element instanceof DTreeItem) {
            DTreeItem item = (DTreeItem)element;
            result = item.getName();
        }
        return result;
    }

    public StyledString getStyledText(Object element) {
        String text = this.getText(element);
        DefaultFontStyler styler = new DefaultFontStyler(this.getFont(element), this.getForeground(element), this.getBackground(element), this.getUnderline(element), this.getStrikeout(element));
        if (text == null) {
            text = "";
        }
        StyledString styledString = new StyledString(text, (StyledString.Styler)styler);
        return styledString;
    }

    private boolean getStrikeout(Object element) {
        EList labelFormat;
        DTreeItem item;
        TreeItemStyle ownedStyle;
        if (element instanceof DTreeItem && (ownedStyle = (item = (DTreeItem)element).getOwnedStyle()) != null && (labelFormat = ownedStyle.getLabelFormat()) != null) {
            return labelFormat.contains(FontFormat.STRIKE_THROUGH_LITERAL);
        }
        return false;
    }

    private boolean getUnderline(Object element) {
        EList labelFormat;
        DTreeItem item;
        TreeItemStyle ownedStyle;
        if (element instanceof DTreeItem && (ownedStyle = (item = (DTreeItem)element).getOwnedStyle()) != null && (labelFormat = ownedStyle.getLabelFormat()) != null) {
            return labelFormat.contains(FontFormat.UNDERLINE_LITERAL);
        }
        return false;
    }

    public String getToolTipText(Object element) {
        String tooltip = null;
        IToolTipProvider tooltipProvider = (IToolTipProvider)Platform.getAdapterManager().getAdapter(element, IToolTipProvider.class);
        if (tooltipProvider != null) {
            tooltip = tooltipProvider.getToolTipText(element);
        }
        return tooltip;
    }
}

