/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.internal.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.UMLPlugin;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.uml2.uml.internal.operations.NamespaceOperations;
import org.eclipse.uml2.uml.util.UMLUtil;

public class PackageOperations
extends NamespaceOperations {
    protected PackageOperations() {
    }

    public static boolean validateElementsPublicOrPrivate(Package package_, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        for (Element ownedElement : package_.getOwnedElements()) {
            VisibilityKind visibility;
            if (!(ownedElement instanceof NamedElement) || (visibility = ((NamedElement)ownedElement).getVisibility()) == null || visibility == VisibilityKind.PUBLIC_LITERAL || visibility == VisibilityKind.PRIVATE_LITERAL) continue;
            result = false;
            if (diagnostics == null) {
                return result;
            }
            diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 29, UMLPlugin.INSTANCE.getString("_UI_Package_ElementsPublicOrPrivate_diagnostic", PackageOperations.getMessageSubstitutions(context, (Object)ownedElement, (Object)package_)), new Object[]{package_, ownedElement}));
        }
        return result;
    }

    public static Class createOwnedClass(Package package_, String name, boolean isAbstract) {
        Class ownedClass = (Class)package_.createOwnedType(name, UMLPackage.Literals.CLASS);
        ownedClass.setIsAbstract(isAbstract);
        return ownedClass;
    }

    public static Enumeration createOwnedEnumeration(Package package_, String name) {
        return (Enumeration)package_.createOwnedType(name, UMLPackage.Literals.ENUMERATION);
    }

    public static PrimitiveType createOwnedPrimitiveType(Package package_, String name) {
        return (PrimitiveType)package_.createOwnedType(name, UMLPackage.Literals.PRIMITIVE_TYPE);
    }

    public static Stereotype createOwnedStereotype(Package package_, String name, boolean isAbstract) {
        Stereotype ownedStereotype = (Stereotype)package_.createOwnedType(name, UMLPackage.Literals.STEREOTYPE);
        ownedStereotype.setIsAbstract(isAbstract);
        return ownedStereotype;
    }

    public static boolean isProfileApplied(Package package_, Profile profile) {
        return PackageOperations.getProfileApplication(package_, profile) != null;
    }

    public static EList<Type> getOwnedTypes(Package package_) {
        return package_.getOwnedTypes();
    }

    public static EList<EObject> applyProfile(Package package_, Profile profile) {
        return PackageOperations.applyProfiles(package_, (EList<Profile>)(profile == null ? ECollections.emptyEList() : ECollections.singletonEList((Object)profile)));
    }

    public static EList<EObject> unapplyProfile(Package package_, Profile profile) {
        if (profile == null) {
            throw new IllegalArgumentException("null profile");
        }
        if (package_.getProfileApplication(profile) == null) {
            throw new IllegalArgumentException(String.format("profile \"%s\" is not applied", profile.getQualifiedName()));
        }
        UniqueEList.FastCompare profileApplications = new UniqueEList.FastCompare();
        TreeIterator allContents = PackageOperations.getAllContents((EObject)package_, (boolean)true, (boolean)false);
        while (allContents.hasNext()) {
            EObject eObject = (EObject)allContents.next();
            if (!(eObject instanceof Package)) continue;
            for (ProfileApplication profileApplication : ((Package)eObject).getProfileApplications()) {
                if (profileApplication.getAppliedProfile() != profile) continue;
                profileApplications.add((Object)profileApplication);
            }
        }
        UMLUtil.destroyAll((Collection)profileApplications);
        return package_.getAllAppliedProfiles().contains((Object)profile) ? ECollections.emptyEList() : PackageOperations.unapplyAllNonApplicableStereotypes(package_);
    }

    public static EList<EObject> applyProfiles(Package package_, EList<Profile> profiles) {
        if (profiles == null || profiles.isEmpty()) {
            throw new IllegalArgumentException("No profile specified");
        }
        for (Profile profile : profiles) {
            EPackage profileDefinition = profile.getDefinition();
            if (profileDefinition != null) continue;
            throw new IllegalArgumentException(String.format("profile \"%s\" has no Ecore definition", profile.getQualifiedName()));
        }
        for (Profile profile : profiles) {
            if (package_.getProfileApplication(profile) != null) continue;
            package_.createProfileApplication().setAppliedProfile(profile);
        }
        UniqueEList.FastCompare stereotypeApplications = new UniqueEList.FastCompare();
        StereotypeApplicationCopier copier = new StereotypeApplicationCopier((List<Profile>)profiles);
        TreeIterator allContents = PackageOperations.getAllContents((EObject)package_, (boolean)true, (boolean)false);
        while (allContents.hasNext()) {
            EObject eObject = (EObject)allContents.next();
            if (!(eObject instanceof Element)) continue;
            Element element = (Element)eObject;
            if (element instanceof Package) {
                for (ProfileApplication profileApplication : ((Package)element).getProfileApplications()) {
                    Profile appliedProfile = profileApplication.getAppliedProfile();
                    if (!profiles.contains((Object)appliedProfile)) continue;
                    EList references = PackageOperations.getEAnnotation((EModelElement)profileApplication, (String)"http://www.eclipse.org/uml2/2.0.0/UML", (boolean)true).getReferences();
                    if (references.isEmpty()) {
                        references.add((Object)appliedProfile.getDefinition());
                        continue;
                    }
                    references.set(0, (Object)appliedProfile.getDefinition());
                }
            }
            for (EObject stereotypeApplication : element.getStereotypeApplications()) {
                Stereotype stereotype = PackageOperations.getStereotype(stereotypeApplication);
                if (stereotype == null || !profiles.contains((Object)stereotype.getProfile())) continue;
                if (element.isStereotypeApplicable(stereotype)) {
                    EObject copy = copier.copy(stereotypeApplication);
                    Resource eResource = stereotypeApplication.eResource();
                    if (eResource != null) {
                        EList contents = eResource.getContents();
                        if (eResource == copy.eResource()) {
                            contents.move(contents.indexOf((Object)stereotypeApplication), (Object)copy);
                        } else {
                            contents.set(contents.indexOf((Object)stereotypeApplication), (Object)copy);
                        }
                    }
                }
                stereotypeApplications.add((Object)stereotypeApplication);
            }
        }
        copier.copyReferences();
        for (EObject key : copier.keySet()) {
            EObject copy = (EObject)copier.get(key);
            Resource eResource = key.eResource();
            if (eResource instanceof XMLResource) {
                XMLResource xmlResource = (XMLResource)eResource;
                String id = xmlResource.getID(key);
                xmlResource.setID(key, null);
                xmlResource.setID(copy, id);
            }
            for (EStructuralFeature.Setting setting : new ArrayList(PackageOperations.getNonNavigableInverseReferences((EObject)key))) {
                EStructuralFeature eStructuralFeature;
                EObject eObject = setting.getEObject();
                if (copier.containsKey(eObject) || (eStructuralFeature = setting.getEStructuralFeature()) == null || !eStructuralFeature.isChangeable()) continue;
                if (eStructuralFeature.isMany()) {
                    Object value = eObject.eGet(eStructuralFeature);
                    EList list = (EList)value;
                    list.set(list.indexOf((Object)key), (Object)copy);
                    continue;
                }
                setting.set((Object)copy);
            }
        }
        UMLUtil.destroyAll((Collection)stereotypeApplications);
        for (Profile profile : profiles) {
            if (profile.getOwnedExtensions(true).size() <= 0) continue;
            return PackageOperations.applyAllRequiredStereotypes(package_);
        }
        return ECollections.emptyEList();
    }

    public static EList<Stereotype> allApplicableStereotypes(Package package_) {
        return PackageOperations.allApplicableStereotypes(package_, (EList<Stereotype>)new UniqueEList.FastCompare());
    }

    protected static EList<Stereotype> allApplicableStereotypes(Package package_, EList<Stereotype> allApplicableStereotypes) {
        allApplicableStereotypes.addAll(package_.getOwnedStereotypes());
        for (Package nestedPackage : package_.getNestedPackages()) {
            PackageOperations.allApplicableStereotypes(nestedPackage, allApplicableStereotypes);
        }
        return allApplicableStereotypes;
    }

    public static Profile containingProfile(Package package_) {
        return (Profile)(package_ instanceof Profile ? package_ : PackageOperations.getOwningElement(package_, UMLPackage.Literals.PROFILE, true));
    }

    protected static EList<Profile> getAppliedProfiles(Package package_, EList<Profile> appliedProfiles) {
        for (ProfileApplication profileApplication : package_.getProfileApplications()) {
            Profile appliedProfile = profileApplication.getAppliedProfile();
            if (appliedProfile == null) continue;
            appliedProfiles.add((Object)appliedProfile);
        }
        return appliedProfiles;
    }

    public static EList<Profile> getAppliedProfiles(Package package_) {
        return PackageOperations.getAppliedProfiles(package_, (EList<Profile>)new UniqueEList.FastCompare());
    }

    public static Profile getAppliedProfile(Package package_, String qualifiedName) {
        for (ProfileApplication profileApplication : package_.getProfileApplications()) {
            Profile appliedProfile = profileApplication.getAppliedProfile();
            if (appliedProfile == null || !PackageOperations.safeEquals((Object)appliedProfile.getQualifiedName(), (Object)qualifiedName)) continue;
            return appliedProfile;
        }
        return null;
    }

    public static Profile getAppliedProfile(Package package_, String qualifiedName, boolean recurse) {
        Profile appliedProfile = package_.getAppliedProfile(qualifiedName);
        if (appliedProfile == null && recurse) {
            Iterator<Package> otherApplyingPackages = UMLUtil.ProfileApplicationHelper.getInstance((Notifier)package_).getOtherApplyingPackages(package_).iterator();
            while (otherApplyingPackages.hasNext() && appliedProfile == null) {
                appliedProfile = otherApplyingPackages.next().getAppliedProfile(qualifiedName);
            }
        }
        return appliedProfile;
    }

    public static EList<ProfileApplication> getAllProfileApplications(Package package_) {
        UniqueEList.FastCompare allProfileApplications = new UniqueEList.FastCompare(package_.getProfileApplications());
        for (Package applyingPackage : UMLUtil.ProfileApplicationHelper.getInstance((Notifier)package_).getOtherApplyingPackages(package_)) {
            allProfileApplications.addAll(applyingPackage.getProfileApplications());
        }
        return ECollections.unmodifiableEList((EList)allProfileApplications);
    }

    public static ProfileApplication getProfileApplication(Package package_, Profile profile) {
        for (ProfileApplication profileApplication : package_.getProfileApplications()) {
            if (profileApplication.getAppliedProfile() != profile) continue;
            return profileApplication;
        }
        return null;
    }

    public static ProfileApplication getProfileApplication(Package package_, Profile profile, boolean recurse) {
        ProfileApplication profileApplication = package_.getProfileApplication(profile);
        if (profileApplication == null && recurse) {
            Iterator<Package> otherApplyingPackages = UMLUtil.ProfileApplicationHelper.getInstance((Notifier)package_).getOtherApplyingPackages(package_).iterator();
            while (otherApplyingPackages.hasNext() && profileApplication == null) {
                profileApplication = otherApplyingPackages.next().getProfileApplication(profile);
            }
        }
        return profileApplication;
    }

    public static Interface createOwnedInterface(Package package_, String name) {
        return (Interface)package_.createOwnedType(name, UMLPackage.Literals.INTERFACE);
    }

    public static boolean isModelLibrary(Package package_) {
        return package_.getAppliedStereotype("StandardProfile::ModelLibrary") != null;
    }

    public static EList<Profile> getAllAppliedProfiles(Package package_) {
        EList<Profile> allAppliedProfiles = PackageOperations.getAppliedProfiles(package_, (EList<Profile>)new UniqueEList.FastCompare());
        for (Package applyingPackage : UMLUtil.ProfileApplicationHelper.getInstance((Notifier)package_).getOtherApplyingPackages(package_)) {
            PackageOperations.getAppliedProfiles(applyingPackage, allAppliedProfiles);
        }
        return ECollections.unmodifiableEList(allAppliedProfiles);
    }

    protected static EList<Package> getAllImportedPackages(Package package_, EList<Package> allImportedPackages) {
        for (PackageImport packageImport : package_.getPackageImports()) {
            Package importedPackage;
            if (packageImport.getVisibility() != VisibilityKind.PUBLIC_LITERAL || (importedPackage = packageImport.getImportedPackage()) == null || !allImportedPackages.add((Object)importedPackage)) continue;
            PackageOperations.getAllImportedPackages(importedPackage, allImportedPackages);
        }
        return allImportedPackages;
    }

    protected static EList<PackageableElement> visibleMembers(Package package_, EList<PackageableElement> visibleMembers) {
        for (NamedElement ownedMember : package_.getOwnedMembers()) {
            if (!(ownedMember instanceof PackageableElement) || ownedMember.getVisibility() != VisibilityKind.PUBLIC_LITERAL) continue;
            visibleMembers.add((Object)((PackageableElement)ownedMember));
        }
        for (ElementImport elementImport : package_.getElementImports()) {
            PackageableElement importedElement;
            if (elementImport.getVisibility() != VisibilityKind.PUBLIC_LITERAL || (importedElement = elementImport.getImportedElement()) == null) continue;
            visibleMembers.add((Object)importedElement);
        }
        return visibleMembers;
    }

    public static EList<PackageableElement> visibleMembers(Package package_) {
        EList<PackageableElement> visibleMembers = PackageOperations.visibleMembers(package_, (EList<PackageableElement>)new UniqueEList.FastCompare());
        for (Package importedPackage : PackageOperations.getAllImportedPackages(package_, (EList<Package>)new UniqueEList.FastCompare())) {
            PackageOperations.visibleMembers(importedPackage, visibleMembers);
        }
        return ECollections.unmodifiableEList(visibleMembers);
    }

    public static boolean makesVisible(Package package_, NamedElement el) {
        if (package_.getOwnedMembers().contains((Object)el)) {
            return el.getVisibility() == VisibilityKind.PUBLIC_LITERAL;
        }
        for (ElementImport elementImport : package_.getElementImports()) {
            if (!PackageOperations.safeEquals((Object)elementImport.getImportedElement(), (Object)el)) continue;
            return elementImport.getVisibility() == VisibilityKind.PUBLIC_LITERAL;
        }
        for (PackageImport packageImport : package_.getPackageImports()) {
            if (packageImport.getVisibility() != VisibilityKind.PUBLIC_LITERAL) continue;
            Package importedPackage = packageImport.getImportedPackage();
            return importedPackage != null && importedPackage.visibleMembers().contains((Object)el);
        }
        return false;
    }

    public static EList<Package> getNestedPackages(Package package_) {
        return package_.getNestedPackages();
    }

    public static EList<Stereotype> getOwnedStereotypes(Package package_) {
        return package_.getOwnedStereotypes();
    }

    public static boolean mustBeOwned(Package package_) {
        return false;
    }

    protected static boolean containsSpecializations(Package package_, Classifier classifier) {
        for (Type ownedType : package_.getOwnedTypes()) {
            if (!(ownedType instanceof Classifier) || !((Classifier)ownedType).allParents().contains((Object)classifier)) continue;
            return true;
        }
        return false;
    }

    protected static class StereotypeApplicationCopier
    extends EcoreUtil.Copier {
        private static final long serialVersionUID = 1L;
        @Deprecated
        protected final Profile profile;
        protected final List<Profile> profiles;
        protected final Map<EClass, EClass> targetClasses = new HashMap<EClass, EClass>();
        protected final Map<EStructuralFeature, EStructuralFeature> targetFeatures = new HashMap<EStructuralFeature, EStructuralFeature>();

        protected StereotypeApplicationCopier(Profile profile) {
            this(profile == null ? Collections.emptyList() : Collections.singletonList(profile));
        }

        protected StereotypeApplicationCopier(List<Profile> profiles) {
            this.profiles = profiles;
            this.profile = profiles.isEmpty() ? null : profiles.get(0);
        }

        protected EObject createCopy(EObject eObject) {
            Element baseElement = PackageOperations.getBaseElement(eObject);
            return baseElement == null ? super.createCopy(eObject) : PackageOperations.applyStereotype(baseElement, this.getTarget(eObject.eClass()), null);
        }

        protected EClass getTarget(EClass eClass) {
            if (this.targetClasses.containsKey(eClass)) {
                return this.targetClasses.get(eClass);
            }
            NamedElement namedElement = this.getNamedElement((ENamedElement)eClass);
            EClass definition = (EClass)this.getDefinition(namedElement);
            this.targetClasses.put(eClass, definition);
            if (definition != null) {
                return definition;
            }
            String qualifiedName = namedElement != null ? PackageOperations.getQualifiedName(namedElement) : PackageOperations.getQualifiedName((ENamedElement)eClass, (String)"::");
            throw new IllegalStateException("Definition for class '" + qualifiedName + "' not found.");
        }

        protected EStructuralFeature getTarget(EStructuralFeature eStructuralFeature) {
            if (this.targetFeatures.containsKey(eStructuralFeature)) {
                return this.targetFeatures.get(eStructuralFeature);
            }
            NamedElement namedElement = this.getNamedElement((ENamedElement)eStructuralFeature);
            EStructuralFeature definition = (EStructuralFeature)this.getDefinition(namedElement);
            this.targetFeatures.put(eStructuralFeature, definition);
            if (definition != null) {
                return definition;
            }
            String qualifiedName = namedElement != null ? PackageOperations.getQualifiedName(namedElement) : PackageOperations.getQualifiedName((ENamedElement)eStructuralFeature, (String)"::");
            throw new IllegalStateException("Definition for property '" + qualifiedName + "' not found.");
        }

        protected NamedElement getNamedElement(ENamedElement element) {
            if (element != null) {
                for (Profile profile : this.profiles) {
                    NamedElement namedElement = PackageOperations.getNamedElement(element, (EObject)profile);
                    if (namedElement == null) continue;
                    return namedElement;
                }
            }
            return null;
        }

        protected ENamedElement getDefinition(NamedElement element) {
            if (element != null) {
                for (Profile profile : this.profiles) {
                    ENamedElement definition = profile.getDefinition(element);
                    if (definition == null) continue;
                    return definition;
                }
            }
            return null;
        }

        protected void copyAttribute(EAttribute eAttribute, EObject eObject, EObject copyEObject) {
            if (!eAttribute.isUnsettable() || eObject.eIsSet((EStructuralFeature)eAttribute)) {
                try {
                    if (UMLUtil.isEnumType(eAttribute.getEType())) {
                        this.copyEEnumAttribute(eAttribute, eObject, copyEObject);
                    } else {
                        this.copyEDataTypeAttribute(eAttribute, eObject, copyEObject);
                    }
                }
                catch (Exception e) {
                    this.handleException(e);
                }
            }
        }

        protected void handleException(Exception exception) {
            UMLPlugin.INSTANCE.log(exception);
        }

        protected void copyEDataTypeAttribute(EAttribute eAttribute, EObject eObject, EObject copyEObject) {
            EDataType eDataType = eAttribute.getEAttributeType();
            EFactory eFactory = eDataType.getEPackage().getEFactoryInstance();
            EAttribute targetEAttribute = (EAttribute)this.getTarget((EStructuralFeature)eAttribute);
            if (targetEAttribute != null && targetEAttribute.isChangeable()) {
                EDataType targetEDataType = targetEAttribute.getEAttributeType();
                EFactory targetEFactory = targetEDataType.getEPackage().getEFactoryInstance();
                if (targetEAttribute.isMany()) {
                    EList copyValues = (EList)copyEObject.eGet((EStructuralFeature)targetEAttribute);
                    if (eAttribute.isMany()) {
                        EList values = (EList)eObject.eGet((EStructuralFeature)eAttribute);
                        int i = 0;
                        int size = values.size();
                        while (i < size) {
                            copyValues.add(i, targetEFactory.createFromString(targetEDataType, eFactory.convertToString(eDataType, values.get(i))));
                            ++i;
                        }
                    } else {
                        copyValues.add(targetEFactory.createFromString(targetEDataType, eFactory.convertToString(eDataType, eObject.eGet((EStructuralFeature)eAttribute))));
                    }
                } else {
                    copyEObject.eSet((EStructuralFeature)targetEAttribute, targetEFactory.createFromString(targetEDataType, eFactory.convertToString(eDataType, eAttribute.isMany() ? ((EList)eObject.eGet((EStructuralFeature)eAttribute)).get(0) : eObject.eGet((EStructuralFeature)eAttribute))));
                }
            }
        }

        protected void copyEEnumAttribute(EAttribute eAttribute, EObject eObject, EObject copyEObject) {
            EAttribute targetEAttribute = (EAttribute)this.getTarget((EStructuralFeature)eAttribute);
            if (targetEAttribute != null && targetEAttribute.isChangeable()) {
                EEnum targetEEnum = UMLUtil.getEnumType((EClassifier)targetEAttribute.getEAttributeType());
                if (targetEAttribute.isMany()) {
                    EList copyValues = (EList)copyEObject.eGet((EStructuralFeature)targetEAttribute);
                    if (eAttribute.isMany()) {
                        EList values = (EList)eObject.eGet((EStructuralFeature)eAttribute);
                        int i = 0;
                        int size = values.size();
                        while (i < size) {
                            EEnumLiteral targetEEnumLiteral = targetEEnum.getEEnumLiteral(((Enumerator)values.get(i)).getName());
                            if (targetEEnumLiteral != null) {
                                copyValues.add((Object)targetEEnumLiteral.getInstance());
                            }
                            ++i;
                        }
                    } else {
                        EEnumLiteral targetEEnumLiteral;
                        Enumerator value = (Enumerator)eObject.eGet((EStructuralFeature)eAttribute);
                        if (value != null && (targetEEnumLiteral = targetEEnum.getEEnumLiteral(value.getName())) != null) {
                            copyValues.add((Object)targetEEnumLiteral.getInstance());
                        }
                    }
                } else {
                    EEnumLiteral targetEEnumLiteral;
                    Enumerator value = (Enumerator)(eAttribute.isMany() ? ((EList)eObject.eGet((EStructuralFeature)eAttribute)).get(0) : eObject.eGet((EStructuralFeature)eAttribute));
                    if (value != null && (targetEEnumLiteral = targetEEnum.getEEnumLiteral(value.getName())) != null) {
                        copyEObject.eSet((EStructuralFeature)targetEAttribute, (Object)targetEEnumLiteral.getInstance());
                    }
                }
            }
        }

        protected void copyContainment(EReference eReference, EObject eObject, EObject copyEObject) {
            if (eObject.eIsSet((EStructuralFeature)eReference)) {
                Object value = eObject.eGet((EStructuralFeature)eReference);
                try {
                    EReference targetEReference = (EReference)this.getTarget((EStructuralFeature)eReference);
                    if (targetEReference != null && targetEReference.isChangeable()) {
                        if (targetEReference.isMany()) {
                            EList copyValues = (EList)copyEObject.eGet((EStructuralFeature)targetEReference);
                            if (eReference.isMany()) {
                                EList values = (EList)value;
                                copyValues.addAll(this.copyAll((Collection)values));
                            } else if (value != null) {
                                copyValues.add((Object)this.copy((EObject)value));
                            }
                        } else if (eReference.isMany()) {
                            EList values = (EList)value;
                            copyEObject.eSet((EStructuralFeature)targetEReference, (Object)this.copy((EObject)values.get(0)));
                        } else {
                            copyEObject.eSet((EStructuralFeature)targetEReference, (Object)this.copy((EObject)value));
                        }
                    }
                }
                catch (Exception e) {
                    this.handleException(e);
                }
            }
        }

        protected void copyReference(EReference eReference, EObject eObject, EObject copyEObject) {
            if (eObject.eIsSet((EStructuralFeature)eReference)) {
                Object value2 = eObject.eGet((EStructuralFeature)eReference);
                try {
                    EReference targetEReference = (EReference)this.getTarget((EStructuralFeature)eReference);
                    if (targetEReference != null && targetEReference.isChangeable()) {
                        if (targetEReference.isMany()) {
                            InternalEList copyValues = (InternalEList)copyEObject.eGet((EStructuralFeature)targetEReference);
                            if (eReference.isMany()) {
                                EReference targetEOpposite = targetEReference.getEOpposite();
                                int index = 0;
                                for (Object value2 : (EList)value2) {
                                    EObject copyValue = (EObject)this.get(value2);
                                    if (copyValue == null) {
                                        if (targetEOpposite != null) continue;
                                        copyValues.addUnique(index++, (Object)((EObject)value2));
                                        continue;
                                    }
                                    if (targetEOpposite != null) {
                                        int position = copyValues.indexOf((Object)copyValue);
                                        if (position == -1) {
                                            copyValues.addUnique(index++, (Object)copyValue);
                                            continue;
                                        }
                                        if (position == index) continue;
                                        copyValues.move(index++, (Object)copyValue);
                                        continue;
                                    }
                                    copyValues.addUnique(index++, (Object)copyValue);
                                }
                            } else if (value2 != null) {
                                EObject copyValue = (EObject)this.get(value2);
                                if (copyValue == null) {
                                    if (targetEReference.getEOpposite() == null) {
                                        copyValues.addUnique((Object)((EObject)value2));
                                    }
                                } else {
                                    copyValues.addUnique((Object)copyValue);
                                }
                            }
                        } else {
                            Object copyValue;
                            if (eReference.isMany()) {
                                EList values = (EList)value2;
                                value2 = values.get(0);
                            }
                            if ((copyValue = this.get(value2)) == null) {
                                if (targetEReference.getEOpposite() == null) {
                                    copyEObject.eSet((EStructuralFeature)targetEReference, value2);
                                }
                            } else {
                                copyEObject.eSet((EStructuralFeature)targetEReference, copyValue);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    this.handleException(e);
                }
            }
        }
    }
}

