/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.draw2d;

import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;

public class Figure
extends org.eclipse.draw2d.Figure {
    public <T> Iterator<T> getListeners(Class<T> listenerClass) {
        return super.getListeners(listenerClass);
    }

    public final void paint(Graphics graphics) {
        if (this.getBackgroundColor() != null) {
            graphics.setBackgroundColor(this.getBackgroundColor());
        }
        if (this.getForegroundColor() != null) {
            graphics.setForegroundColor(this.getForegroundColor());
        }
        if (this.getFont() != null) {
            graphics.setFont(this.getFont());
        }
        graphics.pushState();
        try {
            this.paintFigure(graphics);
            this.paintChildren(graphics);
            this.paintBorder(graphics);
        }
        finally {
            graphics.popState();
        }
    }

    protected void paintFigure(Graphics graphics) {
        if (this.isOpaque()) {
            Rectangle bounds = this.getBounds();
            graphics.fillRectangle(0, 0, bounds.width, bounds.height);
        }
        Insets insets = this.getInsets();
        graphics.translate(insets.left, insets.top);
        this.paintClientArea(graphics);
        graphics.restoreState();
    }

    protected void paintChildren(Graphics graphics) {
        List children = this.getChildren();
        if (children.isEmpty()) {
            return;
        }
        Insets insets = this.getInsets();
        graphics.translate(insets.left, insets.top);
        graphics.pushState();
        for (IFigure childFigure : children) {
            Figure f;
            if (!childFigure.isVisible() || !childFigure.intersects(graphics.getClip(new Rectangle()))) continue;
            Rectangle childBounds = childFigure.getBounds();
            graphics.clipRect(childBounds);
            if (childFigure instanceof Figure && (f = (Figure)childFigure).useLocalCoordinates()) {
                graphics.translate(childBounds.x, childBounds.y);
            }
            childFigure.paint(graphics);
            graphics.restoreState();
        }
        graphics.popState();
        graphics.restoreState();
    }

    protected void paintClientArea(Graphics graphics) {
    }

    protected boolean useLocalCoordinates() {
        return true;
    }
}

