/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.ui;

import java.io.InputStream;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class DrawUtils {
    private static final String DOTS = "...";

    public static final void drawStringCV(Graphics graphics, String text, int x, int y, int width, int height) {
        try {
            graphics.pushState();
            graphics.setClip(new org.eclipse.draw2d.geometry.Rectangle(x, y, width, height));
            int textStartY = y + (height - graphics.getFontMetrics().getHeight()) / 2;
            graphics.drawString(DrawUtils.clipString(graphics, text, width), x, textStartY);
        }
        finally {
            graphics.popState();
        }
    }

    public static final void drawStringCHCV(Graphics graphics, String text, int x, int y, int width, int height) {
        int textStartY = y + (height - graphics.getFontMetrics().getHeight()) / 2;
        int textWidth = DrawUtils.getStringWidth(graphics, text);
        if (textWidth > width) {
            graphics.drawString(DrawUtils.clipString(graphics, text, width), x, textStartY);
        } else {
            graphics.drawString(text, x + (width - textWidth) / 2, textStartY);
        }
    }

    public static final void drawImageCV(Graphics graphics, Image image, int x, int y, int height) {
        if (image != null) {
            Rectangle imageBounds = image.getBounds();
            graphics.drawImage(image, x, y + (height - imageBounds.height) / 2);
        }
    }

    public static final void drawImageCHCV(GC gc, Image image, int x, int y, int width, int height) {
        if (image != null) {
            Rectangle imageBounds = image.getBounds();
            int centerX = (width - imageBounds.width) / 2;
            int centerY = y + (height - imageBounds.height) / 2;
            gc.drawImage(image, x + centerX, centerY);
        }
    }

    public static void drawScaledImage(GC gc, Image image, Rectangle targetRectangle) {
        int newImageHeight;
        int newImageWidth;
        int imageWidth = image.getBounds().width;
        int imageHeight = image.getBounds().height;
        if (imageWidth <= targetRectangle.width && imageHeight <= targetRectangle.height) {
            newImageWidth = imageWidth;
            newImageHeight = imageHeight;
        } else {
            double k_w = (double)targetRectangle.width / (double)imageWidth;
            double k_h = (double)targetRectangle.height / (double)imageHeight;
            double k = Math.min(k_w, k_h);
            newImageWidth = (int)((double)imageWidth * k);
            newImageHeight = (int)((double)imageHeight * k);
        }
        int destX = targetRectangle.x + (targetRectangle.width - newImageWidth) / 2;
        int destY = targetRectangle.y + (targetRectangle.height - newImageHeight) / 2;
        gc.drawImage(image, 0, 0, imageWidth, imageHeight, destX, destY, newImageWidth, newImageHeight);
    }

    /*
     * Unable to fully structure code
     */
    public static String clipString(Graphics graphics, String text, int width) {
        block4: {
            if (width <= 0) {
                return "";
            }
            if (DrawUtils.getStringWidth(graphics, text) <= width) {
                return text;
            }
            count = Math.min(width / graphics.getFontMetrics().getAverageCharWidth(), text.length());
            if (DrawUtils.getStringWidth(graphics, text.substring(0, count) + "...") <= width) ** GOTO lbl12
            while (count > 0 && DrawUtils.getStringWidth(graphics, text.substring(0, count) + "...") > width) {
                --count;
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                ++count;
lbl12:
                // 2 sources

                ** while (count < text.length() - 1 && DrawUtils.getStringWidth((Graphics)graphics, (String)(text.substring((int)0, (int)(count + 1)) + "...")) < width)
            }
        }
        return text.substring(0, count) + "...";
    }

    private static int getStringWidth(Graphics graphics, String text) {
        return FigureUtilities.getTextWidth((String)text, (Font)graphics.getFont());
    }

    public static void drawTextWrap(GC gc, String text, int x, int y, int width, int height) {
        int y_ = y;
        int x_ = x;
        int lineHeight = 0;
        int i = 0;
        while (i < text.length()) {
            String c = text.substring(i, i + 1);
            Point extent = gc.stringExtent(c);
            if (x_ + extent.x > x + width) {
                if ((y_ += lineHeight) > y + height) {
                    return;
                }
                x_ = x;
            }
            gc.drawText(c, x_, y_);
            x_ += extent.x;
            lineHeight = Math.max(lineHeight, extent.y);
            ++i;
        }
    }

    public static void drawHighlightRectangle(GC gc, int x, int y, int width, int height) {
        int right = x + width - 1;
        int bottom = y + height - 1;
        Color oldForeground = gc.getForeground();
        try {
            gc.setForeground(ColorConstants.buttonLightest);
            gc.drawLine(x, y, right, y);
            gc.drawLine(x, y, x, bottom);
            gc.setForeground(ColorConstants.buttonDarker);
            gc.drawLine(right, y, right, bottom);
            gc.drawLine(x, bottom, right, bottom);
        }
        finally {
            gc.setForeground(oldForeground);
        }
    }

    public static Image loadImage(Class<?> clazz, String path) {
        block5: {
            Image image;
            URL resource = clazz.getResource(path);
            if (resource == null) break block5;
            InputStream stream = resource.openStream();
            try {
                image = new Image(null, stream);
            }
            catch (Throwable throwable) {
                try {
                    IOUtils.closeQuietly((InputStream)stream);
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
            }
            IOUtils.closeQuietly((InputStream)stream);
            return image;
        }
        return null;
    }

    public static Image getThubmnail(Image image, int minWidth, int minHeight, int maxWidth, int maxHeight) {
        Rectangle imageBounds = image.getBounds();
        int imageWidth = imageBounds.width;
        int imageHeight = imageBounds.height;
        if (imageWidth < minWidth && imageHeight < minHeight) {
            Image thumbnail = new Image(null, minWidth, minHeight);
            GC gc = new GC((Drawable)thumbnail);
            try {
                DrawUtils.drawImageCHCV(gc, image, 0, 0, minWidth, minHeight);
            }
            finally {
                gc.dispose();
            }
            try {
                ImageData thumbnailData = thumbnail.getImageData();
                thumbnailData.transparentPixel = thumbnailData.getPixel(0, 0);
                Image image2 = new Image(null, thumbnailData);
                return image2;
            }
            finally {
                thumbnail.dispose();
            }
        }
        if (imageWidth <= maxWidth && imageHeight <= maxHeight) {
            return new Image(null, image, 0);
        }
        double kX = (double)maxWidth / (double)imageWidth;
        double kY = (double)maxHeight / (double)imageHeight;
        double k = Math.max(kX, kY);
        int dWidth = (int)((double)imageWidth * k);
        int dHeight = (int)((double)imageHeight * k);
        ImageData scaledImageData = image.getImageData().scaledTo(dWidth, dHeight);
        return new Image(null, scaledImageData);
    }

    public static Image createTransparentPart(Image original, org.eclipse.draw2d.geometry.Rectangle bounds, int alpha) {
        Image image = new Image(null, bounds.width, bounds.height);
        GC gc = new GC((Drawable)image);
        try {
            try {
                gc.drawImage(original, bounds.x, bounds.y, bounds.width, bounds.height, 0, 0, bounds.width, bounds.height);
            }
            catch (Throwable e) {
                image.dispose();
                gc.dispose();
                return null;
            }
        }
        finally {
            gc.dispose();
        }
        ImageData imageData = image.getImageData();
        int y = 0;
        while (y < imageData.height) {
            int x = 0;
            while (x < imageData.width) {
                imageData.setAlpha(x, y, alpha);
                ++x;
            }
            ++y;
        }
        Image alphaImage = new Image(null, imageData);
        image.dispose();
        return alphaImage;
    }

    public static Color getShiftedColor(Color color, int delta) {
        int r = Math.max(0, Math.min(color.getRed() + delta, 255));
        int g = Math.max(0, Math.min(color.getGreen() + delta, 255));
        int b = Math.max(0, Math.min(color.getBlue() + delta, 255));
        return new Color(color.getDevice(), r, g, b);
    }

    public static boolean isDarkColor(Color c) {
        int value = (int)Math.sqrt((double)(c.getRed() * c.getRed()) * 0.241 + (double)(c.getGreen() * c.getGreen()) * 0.691 + (double)(c.getBlue() * c.getBlue()) * 0.068);
        return value < 130;
    }

    public static Font getBoldFont(Font baseFont) {
        FontData[] boldData = DrawUtils.getModifiedFontData(baseFont, 1);
        return new Font((Device)Display.getCurrent(), boldData);
    }

    public static Font getBoldItalicFont(Font baseFont) {
        FontData[] boldData = DrawUtils.getModifiedFontData(baseFont, 3);
        return new Font((Device)Display.getCurrent(), boldData);
    }

    public static Font getItalicFont(Font baseFont) {
        FontData[] boldData = DrawUtils.getModifiedFontData(baseFont, 2);
        return new Font((Device)Display.getCurrent(), boldData);
    }

    private static FontData[] getModifiedFontData(Font baseFont, int style) {
        FontData[] baseData = baseFont.getFontData();
        FontData[] styleData = new FontData[baseData.length];
        int i = 0;
        while (i < styleData.length) {
            FontData base = baseData[i];
            styleData[i] = new FontData(base.getName(), base.getHeight(), base.getStyle() | style);
            ++i;
        }
        return styleData;
    }
}

