/*******************************************************************************
 * Copyright (c) 2011, 2023 Google, Inc.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * https://www.eclipse.org/legal/epl-2.0.
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *    Google, Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.wb.internal.rcp.databinding.ui.property;

import org.eclipse.wb.internal.core.databinding.model.IBindingInfo;
import org.eclipse.wb.internal.core.databinding.model.IObserveInfo;
import org.eclipse.wb.internal.core.databinding.ui.property.Context;
import org.eclipse.wb.internal.core.databinding.ui.property.SingleObserveBindingProperty;
import org.eclipse.wb.internal.rcp.databinding.model.AbstractBindingInfo;
import org.eclipse.wb.internal.rcp.databinding.model.BindableInfo;
import org.eclipse.wb.internal.rcp.databinding.ui.providers.BindingLabelProvider;

import java.util.List;

/**
 * Property for input bindable property of viewer objects.
 *
 * @author lobas_av
 * @coverage bindings.rcp.ui.properties
 */
public class InputObserveProperty extends SingleObserveBindingProperty {
	////////////////////////////////////////////////////////////////////////////
	//
	// Constructor
	//
	////////////////////////////////////////////////////////////////////////////
	public InputObserveProperty(Context context, IObserveInfo observeProperty) throws Exception {
		super(context, observeProperty);
	}

	////////////////////////////////////////////////////////////////////////////
	//
	// SingleObserveBindingProperty
	//
	////////////////////////////////////////////////////////////////////////////
	@Override
	protected IBindingInfo getBinding() throws Exception {
		BindableInfo observeProperty = (BindableInfo) m_observeProperty;
		List<AbstractBindingInfo> bindings = observeProperty.getBindings();
		return bindings.isEmpty() ? null : bindings.get(0);
	}

	@Override
	protected String getText() throws Exception {
		IBindingInfo binding = getBinding();
		return binding == null ? "" : BindingLabelProvider.getText(binding, 2);
	}
}