/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.wip;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.AbstractList;
import java.util.List;
import org.eclipse.wst.jsdt.chromium.ConnectionLogger;
import org.eclipse.wst.jsdt.chromium.TabDebugEventListener;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolParseException;
import org.eclipse.wst.jsdt.chromium.internal.transport.SocketWrapper;
import org.eclipse.wst.jsdt.chromium.internal.websocket.HandshakeUtil;
import org.eclipse.wst.jsdt.chromium.internal.websocket.Hybi17WsConnection;
import org.eclipse.wst.jsdt.chromium.internal.wip.WipBackendBase;
import org.eclipse.wst.jsdt.chromium.internal.wip.WipBrowserImpl;
import org.eclipse.wst.jsdt.chromium.internal.wip.WipTabImpl;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.WipParserAccess;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input.WipTabList;
import org.eclipse.wst.jsdt.chromium.wip.WipBrowser;
import org.eclipse.wst.jsdt.chromium.wip.WipBrowserFactory;
import org.eclipse.wst.jsdt.chromium.wip.WipBrowserTab;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class WipBackendImpl
extends WipBackendBase {
    private static final int DEFAULT_CONNECTION_TIMEOUT_MS = 1000;
    private static final boolean USE_OLD_WEBSOCKET = false;
    private static final String ID = "current development";
    private static final String DESCRIPTION = "Google Chrome/Chromium: \nChromium build: \nWebKit revision: \n";

    public WipBackendImpl() {
        super(ID, DESCRIPTION);
    }

    public List<? extends WipBrowser.WipTabConnector> getTabs(final WipBrowserImpl browserImpl) throws IOException {
        InetSocketAddress socketAddress = browserImpl.getSocketAddress();
        String content = this.readHttpResponseContent(socketAddress, "/json", browserImpl.getConnectionLoggerFactory());
        final List<WipTabList.TabDescription> list = WipBackendImpl.parseJsonReponse(content);
        return new AbstractList<WipBrowser.WipTabConnector>(){

            @Override
            public WipBrowser.WipTabConnector get(int index) {
                return new TabConnectorImpl((WipTabList.TabDescription)list.get(index), browserImpl);
            }

            @Override
            public int size() {
                return list.size();
            }
        };
    }

    private String readHttpResponseContent(InetSocketAddress socketAddress, String resource, WipBrowserFactory.LoggerFactory loggerFactory) throws IOException {
        ConnectionLogger browserConnectionLogger = loggerFactory == null ? null : loggerFactory.newBrowserConnectionLogger();
        final SocketWrapper socketWrapper = new SocketWrapper((SocketAddress)socketAddress, 1000, browserConnectionLogger, HandshakeUtil.ASCII_CHARSET);
        try {
            int length;
            if (browserConnectionLogger != null) {
                browserConnectionLogger.start();
                browserConnectionLogger.setConnectionCloser(new ConnectionLogger.ConnectionCloser(){

                    public void closeConnection() {
                        socketWrapper.getShutdownRelay().sendSignal(null, new Exception("UI close request"));
                    }
                });
            }
            SocketWrapper.LoggableOutputStream output = (SocketWrapper.LoggableOutputStream)socketWrapper.getLoggableOutput();
            WipBackendImpl.writeHttpLine(output, "GET " + resource + " HTTP/1.1");
            WipBackendImpl.writeHttpLine(output, "User-Agent: ChromeDevTools for Java SDK");
            WipBackendImpl.writeHttpLine(output, "Host: " + socketAddress.getHostName() + ":" + socketAddress.getPort());
            WipBackendImpl.writeHttpLine(output, "");
            output.getOutputStream().flush();
            SocketWrapper.LoggableInputStream input = (SocketWrapper.LoggableInputStream)socketWrapper.getLoggableInput();
            HandshakeUtil.HttpResponse httpResponse = HandshakeUtil.readHttpResponse(HandshakeUtil.createLineReader(input.getInputStream()));
            if (httpResponse.getCode() != 200) {
                throw new IOException("Unrecognized respose: " + httpResponse.getCode() + " " + httpResponse.getReasonPhrase());
            }
            String lengthStr = httpResponse.getFields().get("content-length");
            if (lengthStr == null) {
                throw new IOException("Unrecognizable respose: no content-length");
            }
            try {
                length = Integer.parseInt(lengthStr.trim());
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("Unrecognizable respose: incorrect content-length");
            }
            byte[] responseBytes = new byte[length];
            int readSoFar = 0;
            while (readSoFar < length) {
                int res = input.getInputStream().read(responseBytes, readSoFar, length - readSoFar);
                if (res == -1) {
                    throw new IOException("Unexpected EOS");
                }
                readSoFar += res;
            }
            String string = new String(responseBytes, HandshakeUtil.UTF_8_CHARSET);
            return string;
        }
        finally {
            if (browserConnectionLogger != null) {
                browserConnectionLogger.handleEos();
            }
            socketWrapper.getShutdownRelay().sendSignal(null, null);
        }
    }

    private static void writeHttpLine(SocketWrapper.LoggableOutputStream output, String line) throws IOException {
        OutputStream stream = output.getOutputStream();
        stream.write(line.getBytes(HandshakeUtil.ASCII_CHARSET));
        stream.write(13);
        stream.write(10);
    }

    private static List<WipTabList.TabDescription> parseJsonReponse(String content) throws IOException {
        Object jsonValue;
        try {
            jsonValue = new JSONParser().parse(content);
        }
        catch (ParseException e) {
            throw new IOException("Failed to parse a JSON tab list response", e);
        }
        try {
            WipTabList tabList = WipParserAccess.get().parseTabList(jsonValue);
            return tabList.asTabList();
        }
        catch (JsonProtocolParseException e) {
            throw new IOException("Failed to parse tab list response (on protocol level)", e);
        }
    }

    private class TabConnectorImpl
    implements WipBrowser.WipTabConnector {
        private final WipTabList.TabDescription description;
        private final WipBrowserImpl browserImpl;

        private TabConnectorImpl(WipTabList.TabDescription description, WipBrowserImpl browserImpl) {
            this.description = description;
            this.browserImpl = browserImpl;
        }

        public boolean isAlreadyAttached() {
            return this.description.webSocketDebuggerUrl() == null;
        }

        public String getUrl() {
            return this.description.url();
        }

        public String getTitle() {
            return this.description.title();
        }

        public WipBrowserTab attach(TabDebugEventListener listener) throws IOException {
            WipBrowserFactory.LoggerFactory connectionLoggerFactory = this.browserImpl.getConnectionLoggerFactory();
            ConnectionLogger connectionLogger = connectionLoggerFactory == null ? null : connectionLoggerFactory.newTabConnectionLogger();
            String webSocketDebuggerUrl = this.description.webSocketDebuggerUrl();
            if (webSocketDebuggerUrl == null) {
                throw new IOException("Tab is already attached");
            }
            URI uri = URI.create(webSocketDebuggerUrl);
            Hybi17WsConnection socket = Hybi17WsConnection.connect(this.browserImpl.getSocketAddress(), 1000, uri.getPath(), Hybi17WsConnection.MaskStrategy.TRANSPARENT_MASK, connectionLogger);
            return new WipTabImpl(socket, this.browserImpl, listener, this.description.url());
        }
    }
}

