/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CloseableMap<K, V> {
    private final Map<K, V> map;
    private boolean mutationClosed = false;

    public static <K, V> CloseableMap<K, V> newMap() {
        return new CloseableMap(new ConcurrentHashMap());
    }

    public static <K, V> CloseableMap<K, V> newLinkedMap() {
        return new CloseableMap<K, V>((Map)new LinkedHashMap()){

            @Override
            public synchronized V get(K key) {
                return super.get(key);
            }
        };
    }

    protected CloseableMap(Map<K, V> map) {
        this.map = map;
    }

    public V get(K key) {
        return this.map.get(key);
    }

    public synchronized Map<K, V> close() {
        if (this.mutationClosed) {
            throw new IllegalStateException();
        }
        this.mutationClosed = true;
        return this.map;
    }

    public synchronized V remove(K key) {
        if (this.mutationClosed) {
            return null;
        }
        V result = this.map.remove(key);
        if (result == null) {
            throw new IllegalArgumentException("This key is not registered");
        }
        return result;
    }

    public synchronized V removeIfContains(K key) {
        if (this.mutationClosed) {
            return null;
        }
        return this.map.remove(key);
    }

    public synchronized void put(K key, V value) {
        if (this.mutationClosed) {
            throw new IllegalStateException();
        }
        if (this.map.containsKey(key)) {
            throw new IllegalStateException("Such key is already registered");
        }
        this.map.put(key, value);
    }

    public int size() {
        return this.map.size();
    }

    public synchronized V peekFirst() {
        if (this.map.isEmpty()) {
            return null;
        }
        return this.map.values().iterator().next();
    }
}

