/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.impl;

import com.ibm.icu.util.StringTokenizer;
import java.util.Hashtable;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.IXSDFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.IXSDSimpleListFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.XSDToFragmentConfiguration;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.XSDToFragmentController;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.impl.XSDMapFragment;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDLengthFacet;
import org.eclipse.xsd.XSDMaxLengthFacet;
import org.eclipse.xsd.XSDMinLengthFacet;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class XSDSimpleListFragment
extends XSDMapFragment
implements IXSDSimpleListFragment {
    public XSDSimpleListFragment(String id, String name, XSDToFragmentConfiguration config, XSDToFragmentController controller) {
        super(id, name, config, controller);
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        IXSDFragment[] fragments = this.getAllFragments();
        int i = 0;
        while (i < fragments.length) {
            fragments[i].setName(name);
            ++i;
        }
    }

    @Override
    public boolean setParameterValuesFromInstanceDocuments(Element[] instanceDocuments) {
        Element[] instanceDocumentsCopy = this.getInstanceDocumentsByTagName(instanceDocuments, this.getName());
        String[] params = new String[instanceDocumentsCopy.length];
        boolean paramsValid = this.internalEquals(instanceDocumentsCopy, instanceDocuments);
        int i = 0;
        while (i < instanceDocumentsCopy.length) {
            params[i] = "";
            NodeList nodeList = instanceDocumentsCopy[i].getChildNodes();
            if (nodeList.getLength() > 0) {
                Node node = nodeList.item(0);
                if (nodeList.getLength() > 1) {
                    paramsValid = false;
                }
                if (node.getNodeType() != 3) {
                    paramsValid = false;
                } else {
                    params[i] = node.getNodeValue();
                }
            } else {
                paramsValid = false;
            }
            ++i;
        }
        this.removeAllFragments();
        i = 0;
        while (i < params.length) {
            IXSDFragment childFrag = this.getFragment(this.createListInstance());
            StringTokenizer st = new StringTokenizer(params[i].trim());
            String[] childParams = new String[st.countTokens()];
            int j = 0;
            while (j < childParams.length) {
                childParams[j] = st.nextToken();
                ++j;
            }
            childFrag.setParameterValues(childFrag.getID(), childParams);
            paramsValid = paramsValid && childFrag.validateAllParameterValues();
            ++i;
        }
        return paramsValid;
    }

    @Override
    public Element[] genInstanceDocumentsFromParameterValues(boolean genXSIType, Hashtable namespaceTable, Document doc) {
        IXSDFragment[] fragments = this.getAllFragments();
        Element[] instanceDocuments = new Element[fragments.length];
        String tagName = this.getInstanceDocumentTagName(namespaceTable);
        int i = 0;
        while (i < fragments.length) {
            Element instanceDocument = doc.createElement(tagName);
            StringBuffer listValue = new StringBuffer();
            String[] params = fragments[i].getParameterValues(fragments[i].getID());
            int j = 0;
            while (params != null && j < params.length) {
                if (j != 0) {
                    listValue.append(" ");
                }
                listValue.append(params[j]);
                ++j;
            }
            Text textNode = doc.createTextNode(listValue.toString());
            instanceDocument.appendChild(textNode);
            instanceDocuments[i] = instanceDocument;
            ++i;
        }
        return genXSIType ? this.addXSIType(instanceDocuments, namespaceTable) : instanceDocuments;
    }

    @Override
    public String createListInstance() {
        String newID = this.genID();
        XSDSimpleTypeDefinition simpleType = (XSDSimpleTypeDefinition)this.getXSDTypeDefinition();
        int min = 0;
        int max = -1;
        XSDLengthFacet xsdLengthFacet = simpleType.getLengthFacet();
        if (xsdLengthFacet != null) {
            min = xsdLengthFacet.getValue();
            max = xsdLengthFacet.getValue();
        } else {
            XSDMinLengthFacet xsdMinLengthFacet = simpleType.getMinLengthFacet();
            XSDMaxLengthFacet xsdMaxLengthFacet = simpleType.getMaxLengthFacet();
            if (xsdMinLengthFacet != null) {
                min = xsdMinLengthFacet.getValue();
            }
            if (xsdMaxLengthFacet != null) {
                max = xsdMaxLengthFacet.getValue();
            }
        }
        XSDToFragmentConfiguration thisConfig = this.getXSDToFragmentConfiguration();
        XSDToFragmentConfiguration xsdConfig = new XSDToFragmentConfiguration();
        xsdConfig.setXSDComponent((XSDComponent)simpleType.getItemTypeDefinition());
        xsdConfig.setStyle(thisConfig.getStyle());
        xsdConfig.setPartEncoding(thisConfig.getPartEncoding());
        xsdConfig.setWSDLPartName(thisConfig.getWSDLPartName());
        xsdConfig.setMinOccurs(min);
        xsdConfig.setMaxOccurs(max);
        IXSDFragment frag = this.getXSDToFragmentController().getFragment(xsdConfig, newID, this.getName());
        frag.setID(newID);
        frag.setName(this.getName());
        this.addFragment(newID, frag);
        return newID;
    }

    @Override
    public String createInstance() {
        return this.createListInstance();
    }
}

