/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.service.internal.policy;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.ws.service.internal.policy.DescriptorImpl;
import org.eclipse.wst.ws.service.internal.policy.PolicyStateImpl;
import org.eclipse.wst.ws.service.internal.policy.ServicePolicyImpl;
import org.eclipse.wst.ws.service.internal.policy.ServicePolicyPlatformImpl;
import org.eclipse.wst.ws.service.internal.policy.StateEnumerationItemImpl;
import org.eclipse.wst.ws.service.internal.policy.UnresolvedPolicyRelationship;
import org.eclipse.wst.ws.service.internal.policy.UnresolvedRelationship;
import org.eclipse.wst.ws.service.policy.IStateEnumerationItem;
import org.eclipse.wst.ws.service.policy.ServicePolicyActivator;
import org.eclipse.wst.ws.service.policy.listeners.IPolicyPlatformLoadListener;
import org.eclipse.wst.ws.service.policy.utils.RegistryUtils;

public class ServicePolicyRegistry {
    private final String SERVICE_POLICY_ID = "org.eclipse.wst.ws.service.policy.servicepolicy";
    private ServicePolicyPlatformImpl platform;

    public ServicePolicyRegistry(ServicePolicyPlatformImpl platform) {
        this.platform = platform;
    }

    public void load(List<IPolicyPlatformLoadListener> loadListeners, Map<String, ServicePolicyImpl> policyMap, Map<String, List<IStateEnumerationItem>> enumMap, Map<String, StateEnumerationItemImpl> enumItemMap) {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.wst.ws.service.policy.servicepolicy");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String elementName = element.getName().toLowerCase(Locale.ENGLISH);
            if (elementName.equals("servicepolicy")) {
                this.loadServicePolicy(element, loadListeners, policyMap, enumMap, enumItemMap);
            } else {
                this.error("Undefined service policy element, " + elementName + " found.");
            }
            ++n2;
        }
        for (String policyId : policyMap.keySet()) {
            ServicePolicyImpl policy = policyMap.get(policyId);
            policy.resolve();
        }
    }

    private void loadServicePolicy(IConfigurationElement element, List<IPolicyPlatformLoadListener> loadListeners, Map<String, ServicePolicyImpl> policyMap, Map<String, List<IStateEnumerationItem>> enumMap, Map<String, StateEnumerationItemImpl> enumItemMap) {
        IConfigurationElement[] childElements;
        IConfigurationElement[] iConfigurationElementArray = childElements = element.getChildren();
        int n = childElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            String childName = child.getName().toLowerCase(Locale.ENGLISH);
            if (childName.equals("loadlistener")) {
                this.loadLoadListener(child, loadListeners);
            } else if (childName.equals("policy")) {
                this.loadPolicy(child, policyMap);
            } else if (childName.equals("enumeration")) {
                this.loadEnumeration(child, enumMap, enumItemMap);
            } else if (childName.equals("enablement")) {
                this.loadEnablement(child);
            } else {
                this.error("Undefined service policy element, " + childName + " found.");
            }
            ++n2;
        }
    }

    private void loadEnablement(IConfigurationElement element) {
        try {
            Expression expression = ExpressionConverter.getDefault().perform(element);
            this.platform.addEnabledExpression(expression);
        }
        catch (CoreException exc) {
            this.error("Error loading enablement expression: " + exc.getMessage());
        }
    }

    private void loadEnumeration(IConfigurationElement element, Map<String, List<IStateEnumerationItem>> enumMap, Map<String, StateEnumerationItemImpl> enumItemMap) {
        String enumId = RegistryUtils.getAttribute(element, "id");
        String defaultEnumId = RegistryUtils.getAttribute(element, "default");
        IConfigurationElement[] childElements = element.getChildren();
        Vector<IStateEnumerationItem> enumList = new Vector<IStateEnumerationItem>();
        if (enumId == null) {
            this.error("\"Id\" attribute missing from Serivce Policy Enumeration element.");
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = childElements;
        int n = childElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            String childName = child.getName().toLowerCase(Locale.ENGLISH);
            if (childName.equals("item")) {
                this.loadItem(child, enumList, enumItemMap);
            } else {
                this.error("Undefined service policy enumeration element, " + childName + " found.");
            }
            ++n2;
        }
        if (defaultEnumId != null) {
            StateEnumerationItemImpl defaultEnum = enumItemMap.get(defaultEnumId);
            if (defaultEnum == null) {
                this.error("Default enum attribute for enumeration " + enumId + " not found.");
            } else {
                defaultEnum.setDefault(true);
            }
        }
        enumMap.put(enumId, enumList);
    }

    private void loadItem(IConfigurationElement element, List<IStateEnumerationItem> enumList, Map<String, StateEnumerationItemImpl> enumItemMap) {
        String itemId = RegistryUtils.getAttribute(element, "id");
        String shortName = RegistryUtils.getAttribute(element, "shortname");
        String longName = RegistryUtils.getAttribute(element, "longname");
        if (itemId == null) {
            this.error("\"Id\" attribute missing from Serivce Policy Enumeration item element.");
        }
        if (shortName == null && longName == null) {
            this.error("shortName or longName attribute missing from Service Policy Enumeration item element.");
        } else if (shortName == null) {
            shortName = longName;
        } else if (longName == null) {
            longName = shortName;
        }
        StateEnumerationItemImpl item = new StateEnumerationItemImpl();
        item.setId(itemId);
        item.setShortName(shortName);
        item.setLongName(longName);
        enumList.add(item);
        enumItemMap.put(itemId, item);
    }

    private void loadLoadListener(IConfigurationElement element, List<IPolicyPlatformLoadListener> loadListeners) {
        try {
            Object listener = element.createExecutableExtension("class");
            if (listener instanceof IPolicyPlatformLoadListener) {
                loadListeners.add((IPolicyPlatformLoadListener)listener);
            } else {
                this.error("Load listener, " + element.getAttribute("class") + " does not implement IPolicyPlatformLoadListener");
            }
        }
        catch (CoreException exc) {
            ServicePolicyActivator.logError("Error loading service policy loadlistener.", exc);
        }
    }

    private void loadPolicy(IConfigurationElement policy, Map<String, ServicePolicyImpl> policyMap) {
        IConfigurationElement[] policyElements = policy.getChildren();
        String parentId = RegistryUtils.getAttribute(policy, "parentpolicyid");
        String id = RegistryUtils.getAttribute(policy, "id");
        String enumListId = RegistryUtils.getAttribute(policy, "enumlistid");
        String defaultEnumId = RegistryUtils.getAttribute(policy, "defaultenumid");
        String mutableValue = RegistryUtils.getAttribute(policy, "mutable");
        boolean mutable = mutableValue != null && mutableValue.equalsIgnoreCase("true");
        DescriptorImpl descriptor = null;
        Vector<UnresolvedRelationship> relationships = new Vector<UnresolvedRelationship>();
        Vector<String[]> stateKeyValues = new Vector<String[]>();
        if (mutableValue == null && enumListId != null) {
            mutable = true;
        }
        try {
            IConfigurationElement[] iConfigurationElementArray = policyElements;
            int n = policyElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement policyElement = iConfigurationElementArray[n2];
                String name = policyElement.getName().toLowerCase(Locale.ENGLISH);
                if (name.equals("descriptor")) {
                    descriptor = RegistryUtils.loadDescriptor(policyElement);
                } else if (name.equals("relationship")) {
                    this.loadRelationship(policyElement, relationships);
                } else if (name.equals("state")) {
                    String key = RegistryUtils.getAttribute(policyElement, "key");
                    String value = RegistryUtils.getAttribute(policyElement, "value");
                    if (key == null) {
                        this.error("Service policy state missing attribute \"key\".");
                    }
                    if (value == null) {
                        this.error("Service policy state missing attribute \"value\".");
                    }
                    if (key != null && value != null) {
                        stateKeyValues.add(new String[]{key, value});
                    }
                } else {
                    this.error("Undefined service policy element, " + name + " found.");
                }
                ++n2;
            }
            ServicePolicyImpl newPolicy = new ServicePolicyImpl(true, id, this.platform);
            newPolicy.setUnresolvedParent(parentId);
            newPolicy.setUnresolvedRelationships(relationships);
            newPolicy.setDescriptor(descriptor);
            newPolicy.setEnumListId(enumListId);
            newPolicy.setDefaultEnumId(defaultEnumId);
            policyMap.put(id, newPolicy);
            PolicyStateImpl policyState = (PolicyStateImpl)newPolicy.getPolicyState();
            policyState.internalSetMutable(true);
            for (String[] keyValue : stateKeyValues) {
                policyState.putValue(keyValue[0], keyValue[1]);
            }
            policyState.internalSetMutable(mutable);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.error("An error was found loading a service policy.");
        }
    }

    private void loadRelationship(IConfigurationElement relationshipElement, List<UnresolvedRelationship> relationships) {
        String enumValueAttr = RegistryUtils.getAttribute(relationshipElement, "enumlist");
        if (enumValueAttr == null) {
            this.error("Service policy relationship missing attribute \"enumList\".");
            throw new IllegalArgumentException();
        }
        List<String> sourceEnumList = Arrays.asList(enumValueAttr.split(" "));
        IConfigurationElement[] children = relationshipElement.getChildren();
        Vector<UnresolvedPolicyRelationship> targetRelationshipList = new Vector<UnresolvedPolicyRelationship>();
        IConfigurationElement[] iConfigurationElementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            String name = child.getName().toLowerCase(Locale.ENGLISH);
            if (name.equals("targetpolicy")) {
                this.loadPolicyRelationship(child, targetRelationshipList);
            } else {
                this.error("Undefined service policy element, " + name + " found.");
            }
            ++n2;
        }
        UnresolvedRelationship relationship = new UnresolvedRelationship(sourceEnumList, targetRelationshipList);
        relationships.add(relationship);
    }

    private void loadPolicyRelationship(IConfigurationElement policyElement, List<UnresolvedPolicyRelationship> policyRelationshipList) {
        String itemListAttr = RegistryUtils.getAttribute(policyElement, "itemlist");
        String policyId = RegistryUtils.getAttribute(policyElement, "id");
        if (itemListAttr == null) {
            this.error("Service policy relationship missing attribute \"enumList\".");
            throw new IllegalArgumentException();
        }
        if (policyId == null) {
            this.error("Service policy relationship missing attribute \"id\".");
            throw new IllegalArgumentException();
        }
        List<String> targetEnumList = Arrays.asList(itemListAttr.split(" "));
        UnresolvedPolicyRelationship policyRelationship = new UnresolvedPolicyRelationship(policyId, targetEnumList);
        policyRelationshipList.add(policyRelationship);
    }

    private void error(String message) {
        ServicePolicyActivator.logError(message, null);
    }
}

