/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.xml.schema;

import com.ibm.wsdl.util.xml.DOM2Writer;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.util.TestUtils;
import org.eclipse.wst.wsi.internal.core.xml.XMLUtils;
import org.eclipse.wst.wsi.internal.core.xml.schema.XMLSchemaProcessor;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XMLSchemaValidator
extends XMLSchemaProcessor {
    private static final String XMLNS_PREFIX = "xmlns:";

    public XMLSchemaValidator(String context) {
        super(context);
    }

    @Override
    protected void processSchema(Element element) {
        block9: {
            HashMap<String, String> elementMap = new HashMap<String, String>();
            HashMap nsMap = new HashMap();
            try {
                String schema = DOM2Writer.nodeToString((Node)element);
                NamedNodeMap attrList = element.getAttributes();
                if (attrList != null) {
                    this.addNamespaces(attrList, elementMap, null);
                }
                if (elementMap.get(XMLNS_PREFIX + element.getPrefix()) == null) {
                    elementMap.put(XMLNS_PREFIX + element.getPrefix(), element.getNamespaceURI());
                }
                Node parentNode = element.getParentNode();
                while (parentNode != null) {
                    if (parentNode.getNodeType() == 1 && (attrList = parentNode.getAttributes()) != null) {
                        this.addNamespaces(attrList, nsMap, elementMap);
                    }
                    parentNode = parentNode.getParentNode();
                }
                if (nsMap.size() > 0) {
                    String namespaceList = "";
                    for (String attr : nsMap.keySet()) {
                        namespaceList = String.valueOf(namespaceList) + " " + attr + "=\"" + nsMap.get(attr) + "\"";
                    }
                    int index = schema.indexOf(">");
                    if (index > 0) {
                        String start = schema.substring(0, index);
                        String end = schema.substring(index);
                        schema = String.valueOf(start) + namespaceList + end;
                    }
                }
                XMLUtils.parseXML(schema, TestUtils.getXMLSchemaLocation());
            }
            catch (WSIException we) {
                Throwable t = we.getTargetException();
                if (t == null) break block9;
                this.returnList.add(t.getMessage());
            }
        }
    }

    private void addNamespaces(NamedNodeMap attrList, Map nsMap, Map elementMap) {
        int i = 0;
        while (i < attrList.getLength()) {
            Node attr = attrList.item(i);
            String nodeName = attr.getNodeName();
            if (nodeName.startsWith(XMLNS_PREFIX) && (elementMap == null || elementMap != null && elementMap.get(nodeName) == null) && nsMap.get(nodeName) == null) {
                nsMap.put(nodeName, attr.getNodeValue());
            }
            ++i;
        }
    }
}

