/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.search.JavaSearchResultPage;
import org.eclipse.jdt.internal.ui.search.SearchLabelProvider;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public class SortingLabelProvider
extends SearchLabelProvider {
    public static final int SHOW_ELEMENT_CONTAINER = 1;
    public static final int SHOW_CONTAINER_ELEMENT = 2;
    public static final int SHOW_PATH = 3;
    private static final long FLAGS_QUALIFIED = 36065220642538633L;
    private int fCurrentOrder = 1;

    public SortingLabelProvider(JavaSearchResultPage page) {
        super(page);
    }

    @Override
    public Image getImage(Object element) {
        Image image = null;
        if (element instanceof IJavaElement || element instanceof IResource) {
            image = super.getImage(element);
        }
        if (image != null) {
            return image;
        }
        return this.getParticipantImage(element);
    }

    @Override
    public final String getText(Object element) {
        String text;
        if (element instanceof IImportDeclaration) {
            element = ((IImportDeclaration)element).getParent().getParent();
        }
        if ((text = super.getText(element)).length() > 0) {
            String labelWithCount = this.getLabelWithCounts(element, text);
            if (this.fCurrentOrder == 1) {
                labelWithCount = String.valueOf(labelWithCount) + this.getPostQualification(element);
            }
            return labelWithCount;
        }
        return this.getParticipantText(element);
    }

    @Override
    public StyledString getStyledText(Object element) {
        StyledString text;
        if (element instanceof IImportDeclaration) {
            element = ((IImportDeclaration)element).getParent().getParent();
        }
        if ((text = super.getStyledText(element)).length() > 0) {
            StyledString countLabel = this.getColoredLabelWithCounts(element, text);
            if (this.fCurrentOrder == 1) {
                countLabel.append(this.getPostQualification(element), StyledString.QUALIFIER_STYLER);
            }
            return countLabel;
        }
        return this.getStyledParticipantText(element);
    }

    private String getPostQualification(Object element) {
        String textLabel = JavaElementLabels.getTextLabel(element, JavaElementLabels.ALL_POST_QUALIFIED);
        int indexOf = textLabel.indexOf(JavaElementLabels.CONCAT_STRING);
        if (indexOf != -1) {
            return textLabel.substring(indexOf);
        }
        return new String();
    }

    public void setOrder(int orderFlag) {
        this.fCurrentOrder = orderFlag;
        long flags = 0L;
        if (orderFlag == 1) {
            flags = 36421324767241L;
        } else if (orderFlag == 2) {
            flags = 36065220642538633L;
        } else if (orderFlag == 3) {
            flags = 36082812828583049L;
        }
        this.setTextFlags(flags);
    }
}

