/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.typehierarchy;

import java.util.HashSet;
import java.util.List;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.internal.ui.typehierarchy.TypeHierarchyContentProvider;
import org.eclipse.jdt.internal.ui.typehierarchy.TypeHierarchyLifeCycle;
import org.eclipse.jdt.internal.ui.typehierarchy.TypeHierarchyViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class SuperTypeHierarchyViewer
extends TypeHierarchyViewer {
    public SuperTypeHierarchyViewer(Composite parent, TypeHierarchyLifeCycle lifeCycle) {
        super(parent, (IContentProvider)new SuperTypeHierarchyContentProvider(lifeCycle), lifeCycle);
    }

    @Override
    public void updateContent(boolean expand) {
        this.getTree().setRedraw(false);
        this.refresh();
        if (expand) {
            TreeItem[] rootNodes;
            HashSet<Object> visited = new HashSet<Object>();
            TreeItem[] treeItemArray = rootNodes = this.getTree().getItems();
            int n = rootNodes.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem rootNode = treeItemArray[n2];
                this.expandNode(rootNode, visited);
                ++n2;
            }
        }
        this.getTree().setRedraw(true);
    }

    private void expandNode(TreeItem treeItem, HashSet<Object> visited) {
        this.internalExpandToLevel((Widget)treeItem, 1);
        visited.add(treeItem.getData());
        TreeItem[] treeItemArray = treeItem.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem child = treeItemArray[n2];
            if (!visited.contains(child.getData())) {
                this.expandNode(child, visited);
            }
            ++n2;
        }
    }

    public static class SuperTypeHierarchyContentProvider
    extends TypeHierarchyContentProvider {
        public SuperTypeHierarchyContentProvider(TypeHierarchyLifeCycle lifeCycle) {
            super(lifeCycle);
        }

        @Override
        protected final void getTypesInHierarchy(IType type, List<IType> res) {
            ITypeHierarchy hierarchy = this.getHierarchy();
            if (hierarchy != null) {
                IType[] types = hierarchy.getSupertypes(type);
                int i = 0;
                while (i < types.length) {
                    res.add(types[i]);
                    ++i;
                }
            }
        }

        @Override
        protected IType getParentType(IType type) {
            return null;
        }
    }
}

