/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.core.filebuffers.IDocumentSetupParticipantExtension;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.ProjectSpecificLanguageServerWrapper;

public class ConnectDocumentToLanguageServerSetupParticipant
implements IDocumentSetupParticipant,
IDocumentSetupParticipantExtension {
    public void setup(IDocument document) {
        ITextFileBuffer buffer = ITextFileBufferManager.DEFAULT.getTextFileBuffer(document);
        if (buffer == null || buffer.getLocation() == null) {
            return;
        }
        this.setup(document, buffer.getLocation(), LocationKind.IFILE);
    }

    public void setup(final IDocument document, final IPath location, final LocationKind locationKind) {
        Job job = new Job("Initialize Language Servers for " + location.toFile().getName()){

            protected IStatus run(IProgressMonitor monitor) {
                String fileName = location.segment(location.segmentCount() - 1);
                IContentType[] fileContentTypes = new IContentType[]{};
                try {
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try (DocumentInputStream contents = new DocumentInputStream(document);){
                        fileContentTypes = Platform.getContentTypeManager().findContentTypesFor((InputStream)contents, fileName);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    LanguageServerPlugin.logError(e);
                }
                if (locationKind == LocationKind.IFILE) {
                    IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(location);
                    if (!file.exists()) {
                        return Status.OK_STATUS;
                    }
                    IProject project = file.getProject();
                    IContentType[] iContentTypeArray = fileContentTypes;
                    int n = fileContentTypes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IContentType contentType = iContentTypeArray[n2];
                        for (LanguageServersRegistry.LanguageServerDefinition serverDefinition : LanguageServersRegistry.getInstance().findProviderFor(contentType)) {
                            if (serverDefinition == null) continue;
                            try {
                                IPath fileLocation;
                                ProjectSpecificLanguageServerWrapper lsWrapperForConnection = LanguageServiceAccessor.getLSWrapperForConnection(project, contentType, serverDefinition);
                                if (lsWrapperForConnection == null || (fileLocation = file.getLocation()) == null) continue;
                                lsWrapperForConnection.connect(fileLocation, document);
                            }
                            catch (IOException e) {
                                return new Status(4, "org.eclipse.lsp4e", e.getMessage(), (Throwable)e);
                            }
                        }
                        ++n2;
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.setPriority(10);
        job.schedule(100L);
    }

    private static final class DocumentInputStream
    extends InputStream {
        private int index = 0;
        private IDocument document;

        DocumentInputStream(IDocument document) {
            this.document = document;
        }

        @Override
        public int read() throws IOException {
            if (this.index < this.document.getLength()) {
                try {
                    char res = this.document.getChar(this.index);
                    ++this.index;
                    return res;
                }
                catch (BadLocationException e) {
                    throw new IOException(e);
                }
            }
            return -1;
        }
    }
}

