/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.lsp4e.ContentTypeToLSPLaunchConfigEntry;
import org.eclipse.lsp4e.ContentTypeToLanguageServerDefinition;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LaunchConfigurationStreamProvider;
import org.eclipse.lsp4e.server.StreamConnectionProvider;

public class LanguageServersRegistry {
    private static final String CONTENT_TYPE_TO_LSP_LAUNCH_PREF_KEY = "contentTypeToLSPLauch";
    private static final String EXTENSION_POINT_ID = "org.eclipse.lsp4e.languageServer";
    private static final String LS_ELEMENT = "server";
    private static final String MAPPING_ELEMENT = "contentTypeMapping";
    private static final String ID_ATTRIBUTE = "id";
    private static final String CONTENT_TYPE_ATTRIBUTE = "contentType";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String LABEL_ATTRIBUTE = "label";
    private static LanguageServersRegistry INSTANCE = null;
    private List<ContentTypeToLanguageServerDefinition> connections = new ArrayList<ContentTypeToLanguageServerDefinition>();
    private IPreferenceStore preferenceStore = LanguageServerPlugin.getDefault().getPreferenceStore();

    public static LanguageServersRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LanguageServersRegistry();
        }
        return INSTANCE;
    }

    private LanguageServersRegistry() {
        this.initialize();
    }

    /*
     * WARNING - void declaration
     */
    private void initialize() {
        Object mapping;
        int n;
        String prefs = this.preferenceStore.getString(CONTENT_TYPE_TO_LSP_LAUNCH_PREF_KEY);
        if (prefs != null && !prefs.isEmpty()) {
            void var4_9;
            String[] entries;
            String[] stringArray = entries = prefs.split(",");
            n = entries.length;
            boolean n2 = false;
            while (var4_9 < n) {
                String entry = stringArray[var4_9];
                mapping = ContentTypeToLSPLaunchConfigEntry.readFromPreference(entry);
                if (mapping != null) {
                    this.connections.add((ContentTypeToLanguageServerDefinition)mapping);
                }
                ++var4_9;
            }
        }
        HashMap<String, ExtensionLanguageServerDefinition> servers = new HashMap<String, ExtensionLanguageServerDefinition>();
        ArrayList<AbstractMap.SimpleEntry<IContentType, String>> contentTypes = new ArrayList<AbstractMap.SimpleEntry<IContentType, String>>();
        mapping = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n3 = ((IConfigurationElement[])mapping).length;
        n = 0;
        while (n < n3) {
            IConfigurationElement iConfigurationElement = mapping[n];
            String id = iConfigurationElement.getAttribute(ID_ATTRIBUTE);
            if (id != null && !id.isEmpty()) {
                IContentType contentType;
                if (iConfigurationElement.getName().equals(LS_ELEMENT)) {
                    servers.put(id, new ExtensionLanguageServerDefinition(iConfigurationElement));
                } else if (iConfigurationElement.getName().equals(MAPPING_ELEMENT) && (contentType = Platform.getContentTypeManager().getContentType(iConfigurationElement.getAttribute(CONTENT_TYPE_ATTRIBUTE))) != null) {
                    contentTypes.add(new AbstractMap.SimpleEntry<IContentType, String>(contentType, id));
                }
            }
            ++n;
        }
        for (Map.Entry entry : contentTypes) {
            IContentType contentType = (IContentType)entry.getKey();
            LanguageServerDefinition lsDefinition = (LanguageServerDefinition)servers.get(entry.getValue());
            if (lsDefinition != null) {
                this.registerAssociation(contentType, lsDefinition);
                continue;
            }
            LanguageServerPlugin.logWarning("server '" + (String)entry.getValue() + "' not available", null);
        }
    }

    private void persistContentTypeToLaunchConfigurationMapping() {
        StringBuilder builder = new StringBuilder();
        for (ContentTypeToLSPLaunchConfigEntry entry : this.getContentTypeToLSPLaunches()) {
            entry.appendPreferenceTo(builder);
            builder.append(',');
        }
        if (builder.length() > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
        this.preferenceStore.setValue(CONTENT_TYPE_TO_LSP_LAUNCH_PREF_KEY, builder.toString());
        if (this.preferenceStore instanceof IPersistentPreferenceStore) {
            try {
                ((IPersistentPreferenceStore)this.preferenceStore).save();
            }
            catch (IOException e) {
                LanguageServerPlugin.logError(e);
            }
        }
    }

    public List<LanguageServerDefinition> findProviderFor(IContentType contentType) {
        return this.connections.stream().filter(entry -> ((IContentType)entry.getKey()).equals(contentType)).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    public void registerAssociation(@NonNull IContentType contentType, @NonNull ILaunchConfiguration launchConfig, @NonNull Set<String> launchMode) {
        ContentTypeToLSPLaunchConfigEntry mapping = new ContentTypeToLSPLaunchConfigEntry(contentType, launchConfig, launchMode);
        this.connections.add(mapping);
        this.persistContentTypeToLaunchConfigurationMapping();
    }

    public void registerAssociation(@NonNull IContentType contentType, @NonNull LanguageServerDefinition serverDefinition) {
        this.connections.add(new ContentTypeToLanguageServerDefinition(contentType, serverDefinition));
    }

    public void setAssociations(List<ContentTypeToLSPLaunchConfigEntry> wc) {
        this.connections.removeIf(ContentTypeToLSPLaunchConfigEntry.class::isInstance);
        this.connections.addAll(wc);
        this.persistContentTypeToLaunchConfigurationMapping();
    }

    public List<ContentTypeToLSPLaunchConfigEntry> getContentTypeToLSPLaunches() {
        return this.connections.stream().filter(ContentTypeToLSPLaunchConfigEntry.class::isInstance).map(ContentTypeToLSPLaunchConfigEntry.class::cast).collect(Collectors.toList());
    }

    public List<ContentTypeToLanguageServerDefinition> getContentTypeToLSPExtensions() {
        return this.connections.stream().filter(mapping -> mapping.getValue() instanceof ExtensionLanguageServerDefinition).collect(Collectors.toList());
    }

    static class ExtensionLanguageServerDefinition
    extends LanguageServerDefinition {
        private IConfigurationElement extension;

        public ExtensionLanguageServerDefinition(IConfigurationElement element) {
            super(element.getAttribute(LanguageServersRegistry.ID_ATTRIBUTE), element.getAttribute(LanguageServersRegistry.LABEL_ATTRIBUTE));
            this.extension = element;
        }

        @Override
        public StreamConnectionProvider createConnectionProvider() {
            try {
                return (StreamConnectionProvider)this.extension.createExecutableExtension(LanguageServersRegistry.CLASS_ATTRIBUTE);
            }
            catch (CoreException e) {
                return null;
            }
        }
    }

    public static abstract class LanguageServerDefinition {
        private final @NonNull String id;
        private final @NonNull String label;

        public LanguageServerDefinition(@NonNull String id, @NonNull String label) {
            this.id = id;
            this.label = label;
        }

        public String getId() {
            return this.id;
        }

        public String getLabel() {
            return this.label;
        }

        public abstract StreamConnectionProvider createConnectionProvider();
    }

    static class LaunchConfigurationLanguageServerDefinition
    extends LanguageServerDefinition {
        final ILaunchConfiguration launchConfiguration;
        final Set<String> launchModes;

        public LaunchConfigurationLanguageServerDefinition(ILaunchConfiguration launchConfiguration, Set<String> launchModes) {
            super(launchConfiguration.getName(), launchConfiguration.getName());
            this.launchConfiguration = launchConfiguration;
            this.launchModes = launchModes;
        }

        @Override
        public StreamConnectionProvider createConnectionProvider() {
            return new LaunchConfigurationStreamProvider(this.launchConfiguration, this.launchModes);
        }
    }
}

