/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.osgi.framework.Bundle;

public abstract class DocumentProvider
extends AbstractDocumentProvider {
    protected static final int DEFAULT_FILE_SIZE = 15360;
    private final ISaveablePart part;

    public DocumentProvider() {
        this(null);
    }

    public DocumentProvider(ISaveablePart part) {
        this.part = part;
    }

    protected void setDocumentContent(IDocument document, InputStream contentStream) throws CoreException {
        this.setDocumentContent(document, contentStream, null);
    }

    protected void setDocumentContent(IDocument document, InputStream contentStream, String encoding) throws CoreException {
        Reader in = null;
        try {
            try {
                if (encoding == null) {
                    encoding = this.getDefaultEncoding();
                }
                in = new BufferedReader(new InputStreamReader(contentStream, encoding), 15360);
                StringBuffer buffer = new StringBuffer(15360);
                char[] readBuffer = new char[2048];
                int n = in.read(readBuffer);
                while (n > 0) {
                    buffer.append(readBuffer, 0, n);
                    n = in.read(readBuffer);
                }
                document.set(buffer.toString());
            }
            catch (IOException x) {
                String message = x.getMessage() != null ? x.getMessage() : "";
                Status s = new Status(4, "org.eclipse.ui", 0, message, (Throwable)x);
                throw new CoreException((IStatus)s);
            }
        }
        catch (Throwable throwable) {
            try {
                if (in != null) {
                    in.close();
                } else {
                    contentStream.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (in != null) {
                in.close();
            } else {
                contentStream.close();
            }
        }
        catch (IOException iOException) {}
    }

    protected boolean setDocumentContent(IDocument document, IEditorInput editorInput) throws CoreException {
        return this.setDocumentContent(document, editorInput, null);
    }

    protected abstract boolean setDocumentContent(IDocument var1, IEditorInput var2, String var3) throws CoreException;

    protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
        return null;
    }

    protected IDocument createEmptyDocument() {
        return new Document();
    }

    protected IDocument createDocument(Object element) throws CoreException {
        IDocument document;
        String encoding = null;
        ModuleHandle module = SessionHandleAdapter.getInstance().getReportDesignHandle();
        encoding = module != null ? module.getFileEncoding() : "UTF-8";
        if (element instanceof IEditorInput && this.setDocumentContent(document = this.createEmptyDocument(), (IEditorInput)element, encoding)) {
            this.setupDocument(element, document);
            return document;
        }
        return null;
    }

    protected void setupDocument(Object element, IDocument document) {
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        if (this.part != null) {
            this.part.doSave(monitor);
        }
    }

    protected void handleCoreException(CoreException exception, String message) {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.ui");
        ILog log = Platform.getLog((Bundle)bundle);
        if (message != null) {
            log.log((IStatus)new Status(4, "org.eclipse.ui", 0, message, (Throwable)exception));
        } else {
            log.log(exception.getStatus());
        }
    }

    public String getDefaultEncoding() {
        return ResourcesPlugin.getEncoding();
    }

    protected abstract String getPersistedEncoding(Object var1);

    protected IRunnableContext getOperationRunner(IProgressMonitor monitor) {
        return null;
    }
}

