/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.language.contentassist;

import com.google.inject.Injector;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.dot.internal.ui.language.internal.DotActivator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtext.linking.lazy.LazyLinkingResource;
import org.eclipse.xtext.resource.IResourceFactory;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.ui.editor.XtextSourceViewer;
import org.eclipse.xtext.ui.editor.XtextSourceViewerConfiguration;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.model.DocumentPartitioner;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.StringInputStream;
import org.eclipse.xtext.util.Strings;

public class DotProposalProviderDelegator {
    private Injector injector;

    public DotProposalProviderDelegator(String language) {
        this.injector = DotActivator.getInstance().getInjector(language);
    }

    public List<ConfigurableCompletionProposal> computeConfigurableCompletionProposals(String text, int cursorPosition) {
        ArrayList<ConfigurableCompletionProposal> configurableCompletionProposal = new ArrayList<ConfigurableCompletionProposal>();
        ICompletionProposal[] completionProposals = new ICompletionProposal[]{};
        try {
            completionProposals = this.computeCompletionProposals(text, cursorPosition);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ICompletionProposal[] iCompletionProposalArray = completionProposals;
        int n = completionProposals.length;
        int n2 = 0;
        while (n2 < n) {
            ICompletionProposal completionProposal = iCompletionProposalArray[n2];
            if (completionProposal instanceof ConfigurableCompletionProposal) {
                configurableCompletionProposal.add((ConfigurableCompletionProposal)completionProposal);
            }
            ++n2;
        }
        return configurableCompletionProposal;
    }

    private ICompletionProposal[] computeCompletionProposals(String currentModelToParse, int cursorPosition) throws Exception {
        IXtextDocument xtextDocument = this.getDocument(currentModelToParse);
        return this.computeCompletionProposals(xtextDocument, cursorPosition);
    }

    private ICompletionProposal[] computeCompletionProposals(IXtextDocument xtextDocument, int cursorPosition) throws BadLocationException {
        Shell shell = new Shell();
        try {
            ICompletionProposal[] iCompletionProposalArray = this.computeCompletionProposals(xtextDocument, cursorPosition, shell);
            return iCompletionProposalArray;
        }
        finally {
            shell.dispose();
        }
    }

    private ICompletionProposal[] computeCompletionProposals(IXtextDocument xtextDocument, int cursorPosition, Shell shell) throws BadLocationException {
        XtextSourceViewerConfiguration configuration = this.get(XtextSourceViewerConfiguration.class);
        ISourceViewer sourceViewer = this.getSourceViewer(shell, xtextDocument, configuration);
        return this.computeCompletionProposals(xtextDocument, cursorPosition, configuration, sourceViewer);
    }

    private ICompletionProposal[] computeCompletionProposals(IXtextDocument xtextDocument, int cursorPosition, XtextSourceViewerConfiguration configuration, ISourceViewer sourceViewer) throws BadLocationException {
        String contentType;
        IContentAssistant contentAssistant = configuration.getContentAssistant(sourceViewer);
        IContentAssistProcessor processor = contentAssistant.getContentAssistProcessor(contentType = xtextDocument.getContentType(cursorPosition));
        if (processor != null) {
            return processor.computeCompletionProposals((ITextViewer)sourceViewer, cursorPosition);
        }
        return new ICompletionProposal[0];
    }

    private IXtextDocument getDocument(String currentModelToParse) throws Exception {
        XtextResource xtextResource = this.doGetResource((InputStream)new StringInputStream(Strings.emptyIfNull((String)currentModelToParse)), URI.createURI((String)"dummy:/example.mydsl"));
        return this.getDocument(xtextResource, currentModelToParse);
    }

    private IXtextDocument getDocument(XtextResource xtextResource, String model) {
        XtextDocument document = this.get(XtextDocument.class);
        document.set(model);
        document.setInput(xtextResource);
        DocumentPartitioner partitioner = this.get(DocumentPartitioner.class);
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        return document;
    }

    private <T> T get(Class<T> clazz) {
        return (T)this.injector.getInstance(clazz);
    }

    private ISourceViewer getSourceViewer(Shell shell, IXtextDocument xtextDocument, XtextSourceViewerConfiguration configuration) {
        XtextSourceViewer.Factory factory = this.get(XtextSourceViewer.Factory.class);
        XtextSourceViewer sourceViewer = factory.createSourceViewer((Composite)shell, null, null, false, 0);
        sourceViewer.configure((SourceViewerConfiguration)configuration);
        sourceViewer.setDocument((IDocument)xtextDocument);
        return sourceViewer;
    }

    private XtextResource doGetResource(InputStream in, URI uri) throws Exception {
        XtextResourceSet rs = this.get(XtextResourceSet.class);
        rs.setClasspathURIContext(this.getClass());
        XtextResource resource = (XtextResource)this.getResourceFactory().createResource(uri);
        rs.getResources().add((Object)resource);
        resource.load(in, null);
        if (resource instanceof LazyLinkingResource) {
            ((LazyLinkingResource)resource).resolveLazyCrossReferences(CancelIndicator.NullImpl);
        } else {
            EcoreUtil.resolveAll((Resource)resource);
        }
        return resource;
    }

    private IResourceFactory getResourceFactory() {
        return (IResourceFactory)this.injector.getInstance(IResourceFactory.class);
    }
}

