/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.jaxws.core.annotations.validation;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.TypeMirror;
import java.util.Collection;
import javax.jws.Oneway;
import javax.jws.WebParam;
import javax.jws.soap.SOAPBinding;
import javax.xml.ws.Holder;
import org.eclipse.jst.ws.annotations.core.processor.AbstractAnnotationProcessor;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.internal.jaxws.core.JAXWSCoreMessages;
import org.eclipse.jst.ws.internal.jaxws.core.utils.JAXWSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPBindingDocumentBareRules
extends AbstractAnnotationProcessor {
    public void process() {
        AnnotationTypeDeclaration annotationDeclaration = (AnnotationTypeDeclaration)this.environment.getTypeDeclaration(SOAPBinding.class.getName());
        Collection annotatedTypes = this.environment.getDeclarationsAnnotatedWith(annotationDeclaration);
        for (Declaration declaration : annotatedTypes) {
            Collection annotationMirrors;
            if (declaration instanceof TypeDeclaration) {
                TypeDeclaration typeDeclaration = (TypeDeclaration)declaration;
                annotationMirrors = typeDeclaration.getAnnotationMirrors();
                for (AnnotationMirror mirror : annotationMirrors) {
                    if (!mirror.getAnnotationType().getDeclaration().equals((Object)annotationDeclaration) || !JAXWSUtils.isDocumentBare(mirror)) continue;
                    Collection methodDeclarations = typeDeclaration.getMethods();
                    for (MethodDeclaration methodDeclaration : methodDeclarations) {
                        this.processMethod(methodDeclaration);
                    }
                }
            }
            if (!(declaration instanceof MethodDeclaration)) continue;
            MethodDeclaration methodDeclaration = (MethodDeclaration)declaration;
            annotationMirrors = methodDeclaration.getAnnotationMirrors();
            for (AnnotationMirror mirror : annotationMirrors) {
                if (!mirror.getAnnotationType().getDeclaration().equals((Object)annotationDeclaration) || !JAXWSUtils.isDocumentBare(mirror)) continue;
                this.processMethod(methodDeclaration);
            }
        }
    }

    public void processMethod(MethodDeclaration methodDeclaration) {
        Collection parameters = methodDeclaration.getParameters();
        if (this.isOneway(methodDeclaration) && !this.isSingleNonHeaderINParameter(parameters)) {
            this.printError(methodDeclaration.getPosition(), JAXWSCoreMessages.DOC_BARE_ONLY_ONE_NON_HEADER_IN_PARAMETER);
        } else if (this.isVoidReturnType(methodDeclaration)) {
            if (this.countINParameters(parameters) > 1) {
                this.printError(methodDeclaration.getPosition(), JAXWSCoreMessages.DOC_BARE_VOID_RETURN_ONE_IN_PARAMETER);
            }
            if (this.countOUTParameters(parameters) > 1) {
                this.printError(methodDeclaration.getPosition(), JAXWSCoreMessages.DOC_BARE_VOID_RETURN_ONE_OUT_PARAMETER);
            }
        } else {
            if (this.countINParameters(parameters) > 1) {
                this.printError(methodDeclaration.getPosition(), JAXWSCoreMessages.DOC_BARE_ONLY_ONE_NON_HEADER_IN_PARAMETER);
            }
            if (this.countOUTParameters(parameters) > 0) {
                this.printError(methodDeclaration.getPosition(), JAXWSCoreMessages.DOC_BARE_NON_VOID_RETURN_NO_INOUT_OUT_PARAMETER);
            }
        }
    }

    private boolean isOneway(MethodDeclaration methodDeclaration) {
        AnnotationMirror oneway = AnnotationUtils.getAnnotation((Declaration)methodDeclaration, Oneway.class);
        return oneway != null;
    }

    private boolean isVoidReturnType(MethodDeclaration methodDeclaration) {
        return methodDeclaration.getReturnType().equals((Object)this.environment.getTypeUtils().getVoidType());
    }

    private boolean isSingleNonHeaderINParameter(Collection<ParameterDeclaration> parameters) {
        return this.countNonHeaderINParameters(parameters) <= 1;
    }

    private int countNonHeaderINParameters(Collection<ParameterDeclaration> parameters) {
        int inNonHeaderParameters = 0;
        for (ParameterDeclaration parameterDeclaration : parameters) {
            if (!this.isNonHeaderINParameter(parameterDeclaration)) continue;
            ++inNonHeaderParameters;
        }
        return inNonHeaderParameters;
    }

    private boolean isNonHeaderINParameter(ParameterDeclaration parameterDeclaration) {
        AnnotationMirror webParam = AnnotationUtils.getAnnotation((Declaration)parameterDeclaration, WebParam.class);
        if (webParam != null) {
            return this.getWebParamMode(webParam, parameterDeclaration).equals(WebParam.Mode.IN.name()) && !this.isHeader(webParam);
        }
        return this.getDefaultWebParamMode(parameterDeclaration).equals(WebParam.Mode.IN.name());
    }

    private int countINParameters(Collection<ParameterDeclaration> parameters) {
        int inNonHeaderParameters = 0;
        for (ParameterDeclaration parameterDeclaration : parameters) {
            if (!this.isINParameter(parameterDeclaration)) continue;
            ++inNonHeaderParameters;
        }
        return inNonHeaderParameters;
    }

    private boolean isINParameter(ParameterDeclaration parameterDeclaration) {
        AnnotationMirror webParam = AnnotationUtils.getAnnotation((Declaration)parameterDeclaration, WebParam.class);
        if (webParam != null) {
            String mode = this.getWebParamMode(webParam, parameterDeclaration);
            return (mode.equals(WebParam.Mode.IN.name()) || mode.equals(WebParam.Mode.INOUT.name())) && !this.isHeader(webParam);
        }
        String defaultMode = this.getDefaultWebParamMode(parameterDeclaration);
        return defaultMode.equals(WebParam.Mode.IN.name()) || defaultMode.equals(WebParam.Mode.INOUT.name());
    }

    private int countOUTParameters(Collection<ParameterDeclaration> parameters) {
        int outNonHeaderParameters = 0;
        for (ParameterDeclaration parameterDeclaration : parameters) {
            if (!this.isOUTParameter(parameterDeclaration)) continue;
            ++outNonHeaderParameters;
        }
        return outNonHeaderParameters;
    }

    private boolean isOUTParameter(ParameterDeclaration parameterDeclaration) {
        AnnotationMirror webParam = AnnotationUtils.getAnnotation((Declaration)parameterDeclaration, WebParam.class);
        if (webParam != null) {
            String mode = this.getWebParamMode(webParam, parameterDeclaration);
            return (mode.equals(WebParam.Mode.OUT.name()) || mode.equals(WebParam.Mode.INOUT.name())) && !this.isHeader(webParam);
        }
        return this.getDefaultWebParamMode(parameterDeclaration).equals(WebParam.Mode.INOUT.name());
    }

    private boolean isHeader(AnnotationMirror annotationMirror) {
        Boolean header = AnnotationUtils.getBooleanValue((AnnotationMirror)annotationMirror, (String)"header");
        if (header != null) {
            return header;
        }
        return false;
    }

    private String getWebParamMode(AnnotationMirror annotationMirror, ParameterDeclaration parameterDeclaration) {
        String mode = AnnotationUtils.getStringValue((AnnotationMirror)annotationMirror, (String)"mode");
        if (mode == null || mode.length() == 0) {
            mode = this.getDefaultWebParamMode(parameterDeclaration);
        }
        return mode;
    }

    private String getDefaultWebParamMode(ParameterDeclaration parameterDeclaration) {
        TypeMirror typeMirror = this.environment.getTypeUtils().getErasure(parameterDeclaration.getType());
        if (typeMirror.toString().equals(Holder.class.getCanonicalName())) {
            return WebParam.Mode.INOUT.name();
        }
        return WebParam.Mode.IN.name();
    }
}

