/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.FeatureModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureChild;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.core.iproduct.IArgumentsInfo;
import org.eclipse.pde.internal.core.iproduct.IConfigurationFileInfo;
import org.eclipse.pde.internal.core.iproduct.IJREInfo;
import org.eclipse.pde.internal.core.iproduct.IPluginConfiguration;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductFeature;
import org.eclipse.pde.internal.core.iproduct.IProductPlugin;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.pde.internal.launching.launcher.BundleLauncherHelper;
import org.eclipse.pde.internal.launching.launcher.LaunchArgumentsHelper;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class LaunchAction
extends Action {
    private IProduct fProduct;
    private String fMode;
    private String fPath;
    private Map<String, IPluginConfiguration> fPluginConfigurations;

    public LaunchAction(IProduct product, String path, String mode) {
        IPluginConfiguration[] configurations;
        this.fProduct = product;
        this.fMode = mode;
        this.fPath = path;
        this.fPluginConfigurations = new HashMap<String, IPluginConfiguration>();
        IPluginConfiguration[] iPluginConfigurationArray = configurations = this.fProduct.getPluginConfigurations();
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginConfiguration config = iPluginConfigurationArray[n2];
            this.fPluginConfigurations.put(config.getId(), config);
            ++n2;
        }
    }

    public void run() {
        try {
            ILaunchConfiguration config = this.findLaunchConfiguration();
            if (config != null) {
                DebugUITools.launch((ILaunchConfiguration)config, (String)this.fMode);
            }
        }
        catch (CoreException coreException) {}
    }

    private ILaunchConfiguration findLaunchConfiguration() throws CoreException {
        ILaunchConfiguration[] configs = this.getLaunchConfigurations();
        if (configs.length == 0) {
            return this.createConfiguration();
        }
        ILaunchConfiguration config = null;
        config = configs.length == 1 ? configs[0] : this.chooseConfiguration(configs);
        if (config != null) {
            config = this.refreshConfiguration(config.getWorkingCopy());
        }
        return config;
    }

    private ILaunchConfiguration refreshConfiguration(ILaunchConfigurationWorkingCopy wc) throws CoreException {
        IPluginModelBase[] models;
        wc.setAttribute("product", this.fProduct.getProductId());
        wc.setAttribute("application", this.fProduct.getApplication());
        String os = Platform.getOS();
        String arch = Platform.getOSArch();
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, this.getVMArguments(os, arch));
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, this.getProgramArguments(os, arch));
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, this.getJREContainer(os));
        StringBuffer wsplugins = new StringBuffer();
        StringBuffer explugins = new StringBuffer();
        IPluginModelBase[] iPluginModelBaseArray = models = this.getModels();
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase model = iPluginModelBaseArray[n2];
            if (model.getUnderlyingResource() == null) {
                this.appendBundle(explugins, model);
            } else {
                this.appendBundle(wsplugins, model);
            }
            ++n2;
        }
        wc.setAttribute("selected_workspace_plugins", wsplugins.toString());
        wc.setAttribute("selected_target_plugins", explugins.toString());
        String configIni = this.getTemplateConfigIni(os);
        wc.setAttribute("useDefaultConfig", configIni == null);
        if (configIni != null) {
            wc.setAttribute("templateConfig", configIni);
        }
        return wc.doSave();
    }

    private void appendBundle(StringBuffer buffer, IPluginModelBase model) {
        IPluginConfiguration configuration = this.fPluginConfigurations.get(model.getPluginBase().getId());
        String sl = "default";
        String autostart = "default";
        if (configuration != null) {
            sl = Integer.toString(configuration.getStartLevel());
            sl = sl.equals("0") ? "default" : sl;
            autostart = Boolean.toString(configuration.isAutoStart());
        }
        String entry = BundleLauncherHelper.writeBundleEntry((IPluginModelBase)model, (String)sl, (String)autostart);
        buffer.append(entry);
        buffer.append(',');
    }

    private String getProgramArguments(String os, String arch) {
        StringBuffer buffer = new StringBuffer(LaunchArgumentsHelper.getInitialProgramArguments());
        IArgumentsInfo info = this.fProduct.getLauncherArguments();
        String userArgs = info != null ? CoreUtility.normalize((String)info.getCompleteProgramArguments(os, arch)) : "";
        return this.concatArgs(buffer, userArgs);
    }

    private String getVMArguments(String os, String arch) {
        StringBuffer buffer = new StringBuffer(LaunchArgumentsHelper.getInitialVMArguments());
        IArgumentsInfo info = this.fProduct.getLauncherArguments();
        String userArgs = info != null ? CoreUtility.normalize((String)info.getCompleteVMArguments(os, arch)) : "";
        return this.concatArgs(buffer, userArgs);
    }

    private String concatArgs(StringBuffer initialArgs, String userArgs) {
        List<String> initialArgsList = Arrays.asList(DebugPlugin.splitArguments((String)initialArgs.toString()));
        if (userArgs != null && userArgs.length() > 0) {
            List<String> userArgsList = Arrays.asList(DebugPlugin.splitArguments((String)userArgs));
            boolean previousHasSubArgument = false;
            for (String userArg : userArgsList) {
                boolean hasSubArgument = userArg.toString().equals("-os") || userArg.toString().equals("-ws");
                boolean bl = hasSubArgument = hasSubArgument || userArg.toString().equals("-arch") || userArg.toString().equals("-nl");
                if (!initialArgsList.contains(userArg) || hasSubArgument || previousHasSubArgument) {
                    initialArgs.append(' ');
                    initialArgs.append(userArg);
                }
                previousHasSubArgument = hasSubArgument;
            }
        }
        String arguments = null;
        try {
            arguments = this.removeDuplicateArguments(initialArgs);
        }
        catch (Exception e) {
            PDEPlugin.log(e);
            return initialArgs.toString();
        }
        return arguments;
    }

    private String removeDuplicateArguments(StringBuffer initialArgs) {
        String[] progArguments = new String[]{"-os", "-ws", "-arch", "-nl"};
        String defaultStart = "${target.";
        ArrayList<String> userArgsList = new ArrayList<String>(Arrays.asList(DebugPlugin.splitArguments((String)initialArgs.toString())));
        String[] stringArray = progArguments;
        int n = progArguments.length;
        int n2 = 0;
        while (n2 < n) {
            int index2;
            String progArgument = stringArray[n2];
            int index1 = userArgsList.indexOf(progArgument);
            if (index1 != (index2 = userArgsList.lastIndexOf(progArgument))) {
                String s1 = userArgsList.get(index1 + 1);
                String s2 = userArgsList.get(index2 + 1);
                if (s1.startsWith(defaultStart) && !s2.startsWith(defaultStart)) {
                    userArgsList.remove(index1);
                    userArgsList.remove(index1);
                } else if (s2.startsWith(defaultStart) && !s1.startsWith(defaultStart)) {
                    userArgsList.remove(index2);
                    userArgsList.remove(index2);
                }
            }
            ++n2;
        }
        StringBuffer arguments = new StringBuffer();
        Iterator<String> iterator = userArgsList.iterator();
        while (iterator.hasNext()) {
            String userArg = iterator.next();
            arguments.append((Object)userArg);
            if (!iterator.hasNext()) continue;
            arguments.append(' ');
        }
        return arguments.toString();
    }

    private String getJREContainer(String os) {
        IPath jrePath;
        IJREInfo info = this.fProduct.getJREInfo();
        if (info != null && (jrePath = info.getJREContainerPath(os)) != null) {
            return jrePath.toPortableString();
        }
        return null;
    }

    private IPluginModelBase[] getModels() {
        HashSet<IPluginModelBase> launchPlugins = new HashSet<IPluginModelBase>();
        if (this.fProduct.useFeatures()) {
            IFeatureModel[] features;
            IFeatureModel[] iFeatureModelArray = features = this.getUniqueFeatures();
            int n = features.length;
            int n2 = 0;
            while (n2 < n) {
                IFeatureModel feature = iFeatureModelArray[n2];
                this.addFeaturePlugins(feature.getFeature(), launchPlugins);
                ++n2;
            }
        } else {
            IProductPlugin[] plugins;
            IProductPlugin[] iProductPluginArray = plugins = this.fProduct.getPlugins();
            int n = plugins.length;
            int n3 = 0;
            while (n3 < n) {
                IPluginModelBase model;
                IProductPlugin plugin = iProductPluginArray[n3];
                String id = plugin.getId();
                if (id != null && (model = PluginRegistry.findModel((String)id)) != null && TargetPlatformHelper.matchesCurrentEnvironment((IPluginModelBase)model)) {
                    launchPlugins.add(model);
                }
                ++n3;
            }
        }
        return launchPlugins.toArray(new IPluginModelBase[launchPlugins.size()]);
    }

    private IFeatureModel[] getUniqueFeatures() {
        IProductFeature[] features;
        ArrayList<IFeatureModel> list = new ArrayList<IFeatureModel>();
        IProductFeature[] iProductFeatureArray = features = this.fProduct.getFeatures();
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            IProductFeature feature = iProductFeatureArray[n2];
            String id = feature.getId();
            String version = feature.getVersion();
            this.addFeatureAndChildren(id, version, list);
            ++n2;
        }
        return list.toArray(new IFeatureModel[list.size()]);
    }

    private void addFeatureAndChildren(String id, String version, List<IFeatureModel> list) {
        IFeatureChild[] children;
        FeatureModelManager manager = PDECore.getDefault().getFeatureModelManager();
        IFeatureModel model = manager.findFeatureModel(id, version);
        if (model == null || list.contains(model)) {
            return;
        }
        list.add(model);
        IFeatureChild[] iFeatureChildArray = children = model.getFeature().getIncludedFeatures();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureChild element = iFeatureChildArray[n2];
            this.addFeatureAndChildren(element.getId(), element.getVersion(), list);
            ++n2;
        }
    }

    private void addFeaturePlugins(IFeature feature, Set<IPluginModelBase> launchPlugins) {
        IFeaturePlugin[] plugins;
        IFeaturePlugin[] iFeaturePluginArray = plugins = feature.getPlugins();
        int n = plugins.length;
        int n2 = 0;
        while (n2 < n) {
            IFeaturePlugin plugin = iFeaturePluginArray[n2];
            String id = plugin.getId();
            String version = plugin.getVersion();
            if (id != null && version != null) {
                IPluginModelBase model = PluginRegistry.findModel((String)id, (String)version, (int)1, null);
                if (model == null) {
                    model = PluginRegistry.findModel((String)id);
                }
                if (model != null && !launchPlugins.contains(model) && TargetPlatformHelper.matchesCurrentEnvironment((IPluginModelBase)model)) {
                    launchPlugins.add(model);
                }
            }
            ++n2;
        }
    }

    private String getTemplateConfigIni(String os) {
        IConfigurationFileInfo info = this.fProduct.getConfigurationFileInfo();
        if (info != null) {
            File file;
            String expandedPath;
            String path = info.getPath(os);
            if (path == null) {
                path = info.getPath(null);
            }
            if (path != null && (expandedPath = this.getExpandedPath(path)) != null && (file = new File(expandedPath)).exists() && file.isFile()) {
                return file.getAbsolutePath();
            }
        }
        return null;
    }

    private String getExpandedPath(String path) {
        if (path == null || path.length() == 0) {
            return null;
        }
        IResource resource = PDEPlugin.getWorkspace().getRoot().findMember((IPath)new Path(path));
        if (resource != null) {
            IPath fullPath = resource.getLocation();
            return fullPath == null ? null : fullPath.toOSString();
        }
        return null;
    }

    private ILaunchConfiguration chooseConfiguration(ILaunchConfiguration[] configs) {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(PDEPlugin.getActiveWorkbenchShell(), (ILabelProvider)labelProvider);
        dialog.setElements((Object[])configs);
        dialog.setTitle(PDEUIMessages.RuntimeWorkbenchShortcut_title);
        if (this.fMode.equals("debug")) {
            dialog.setMessage(PDEUIMessages.RuntimeWorkbenchShortcut_select_debug);
        } else {
            dialog.setMessage(PDEUIMessages.RuntimeWorkbenchShortcut_select_run);
        }
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    private ILaunchConfiguration createConfiguration() throws CoreException {
        ILaunchConfigurationType configType = this.getWorkbenchLaunchConfigType();
        String computedName = this.getComputedName(new Path(this.fPath).lastSegment());
        ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, computedName);
        wc.setAttribute("location", LaunchArgumentsHelper.getDefaultWorkspaceLocation((String)computedName));
        wc.setAttribute("usefeatures", false);
        wc.setAttribute("default", false);
        wc.setAttribute("clearws", false);
        wc.setAttribute("clearwslog", false);
        wc.setAttribute("append.args", true);
        wc.setAttribute("askclear", true);
        wc.setAttribute("useProduct", true);
        wc.setAttribute("automaticAdd", false);
        wc.setAttribute("productFile", this.fPath);
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, "org.eclipse.pde.ui.workbenchClasspathProvider");
        return this.refreshConfiguration(wc);
    }

    private String getComputedName(String prefix) {
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        return lm.generateLaunchConfigurationName(prefix);
    }

    private ILaunchConfiguration[] getLaunchConfigurations() throws CoreException {
        ArrayList<ILaunchConfiguration> result = new ArrayList<ILaunchConfiguration>();
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType("org.eclipse.pde.ui.RuntimeWorkbench");
        ILaunchConfiguration[] configs = manager.getLaunchConfigurations(type);
        int i = 0;
        while (i < configs.length) {
            String path;
            if (!DebugUITools.isPrivate((ILaunchConfiguration)configs[i]) && new Path(this.fPath).equals((Object)new Path(path = configs[i].getAttribute("productFile", "")))) {
                result.add(configs[i]);
            }
            ++i;
        }
        return result.toArray(new ILaunchConfiguration[result.size()]);
    }

    protected ILaunchConfigurationType getWorkbenchLaunchConfigType() {
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        return lm.getLaunchConfigurationType("org.eclipse.pde.ui.RuntimeWorkbench");
    }
}

