/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.exports;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.exports.BaseExportWizardPage;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class JNLPTab {
    private static final String S_JNLP = "jnlp";
    private static final String S_URL = "siteURL";
    private static final String S_JRE = "jre";
    private Label fURLLabel;
    private Text fURLText;
    private Label fVersionLabel;
    private Text fVersionText;
    private Button fButton;
    private BaseExportWizardPage fPage;

    public JNLPTab(BaseExportWizardPage page) {
        this.fPage = page;
    }

    public Control createControl(Composite parent) {
        Composite jnlpGroup = new Composite(parent, 0);
        jnlpGroup.setLayout((Layout)new GridLayout(2, false));
        jnlpGroup.setLayoutData((Object)new GridData(768));
        this.fButton = new Button(jnlpGroup, 32);
        this.fButton.setText(PDEUIMessages.AdvancedFeatureExportPage_createJNLP);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.fButton.setLayoutData((Object)gd);
        this.fButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.updateGroup(this.fButton.getSelection());
            this.fPage.pageChanged();
        }));
        this.fURLLabel = this.createLabel(jnlpGroup, PDEUIMessages.AdvancedFeatureExportPage_siteURL);
        this.fURLText = this.createText(jnlpGroup);
        this.fVersionLabel = this.createLabel(jnlpGroup, PDEUIMessages.AdvancedFeatureExportPage_jreVersion);
        this.fVersionText = this.createText(jnlpGroup);
        Dialog.applyDialogFont((Control)jnlpGroup);
        return jnlpGroup;
    }

    protected Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        GridData gd = new GridData();
        gd.horizontalIndent = 15;
        label.setLayoutData((Object)gd);
        return label;
    }

    protected Text createText(Composite parent) {
        Text text = new Text(parent, 2052);
        text.setLayoutData((Object)new GridData(768));
        text.addModifyListener(e -> this.fPage.pageChanged());
        return text;
    }

    protected void initialize(IDialogSettings settings) {
        this.fURLText.setText(this.getString(settings, S_URL));
        this.fVersionText.setText(this.getString(settings, S_JRE));
        this.fButton.setSelection(settings.getBoolean(S_JNLP));
        this.updateGroup(this.fButton.getSelection());
    }

    private String getString(IDialogSettings settings, String key) {
        String value = settings.get(key);
        return value == null ? "" : value;
    }

    private void updateGroup(boolean enabled) {
        this.fURLLabel.setEnabled(enabled);
        this.fURLText.setEnabled(enabled);
        this.fVersionLabel.setEnabled(enabled);
        this.fVersionText.setEnabled(enabled);
    }

    protected String validate() {
        String error = null;
        if (this.fButton.getSelection()) {
            if (this.fURLText.getText().trim().length() == 0) {
                error = PDEUIMessages.AdvancedFeatureExportPage_noSite;
            } else if (this.fVersionText.getText().trim().length() == 0) {
                error = PDEUIMessages.AdvancedFeatureExportPage_noVersion;
            }
        }
        return error;
    }

    protected void saveSettings(IDialogSettings settings) {
        settings.put(S_JNLP, this.fButton.getSelection());
        settings.put(S_URL, this.fURLText.getText());
        settings.put(S_JRE, this.fVersionText.getText());
    }

    protected String[] getJNLPInfo() {
        if (this.fButton.getSelection()) {
            return new String[]{this.fURLText.getText().trim(), this.fVersionText.getText().trim()};
        }
        return null;
    }
}

