/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.template.c;

import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.corext.template.c.CFormatter;
import org.eclipse.cdt.internal.corext.template.c.TranslationUnitContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateTranslator;

public class CommentContext
extends TranslationUnitContext {
    public CommentContext(TemplateContextType type, IDocument document, int completionOffset, int completionLength, ITranslationUnit translationUnit) {
        super(type, document, completionOffset, completionLength, translationUnit);
    }

    public CommentContext(TemplateContextType type, IDocument document, Position completionPosition, ITranslationUnit translationUnit) {
        super(type, document, completionPosition, translationUnit);
    }

    public int getStart() {
        if (this.fIsManaged && this.getCompletionLength() > 0) {
            return super.getStart();
        }
        try {
            IDocument document = this.getDocument();
            if (this.getCompletionLength() == 0) {
                int start = this.getCompletionOffset();
                while (start != 0 && !Character.isWhitespace(document.getChar(start - 1))) {
                    --start;
                }
                if (start != 0 && !Character.isWhitespace(document.getChar(start - 1))) {
                    --start;
                }
                return start;
            }
            int start = this.getCompletionOffset();
            int end = this.getCompletionOffset() + this.getCompletionLength();
            while (start != 0 && !Character.isWhitespace(document.getChar(start - 1))) {
                --start;
            }
            while (start != end && Character.isWhitespace(document.getChar(start))) {
                ++start;
            }
            if (start == end) {
                start = this.getCompletionOffset();
            }
            return start;
        }
        catch (BadLocationException e) {
            return this.getCompletionOffset();
        }
    }

    public int getEnd() {
        if (this.fIsManaged || this.getCompletionLength() == 0) {
            return super.getEnd();
        }
        try {
            IDocument document = this.getDocument();
            int start = this.getCompletionOffset();
            int end = this.getCompletionOffset() + this.getCompletionLength();
            while (start != end && Character.isWhitespace(document.getChar(end - 1))) {
                --end;
            }
            return end;
        }
        catch (BadLocationException e) {
            return super.getEnd();
        }
    }

    public TemplateBuffer evaluate(Template template) throws BadLocationException, TemplateException {
        TemplateTranslator translator = new TemplateTranslator();
        TemplateBuffer buffer = translator.translate(template);
        this.getContextType().resolve(buffer, (TemplateContext)this);
        boolean useCodeFormatter = false;
        ICProject project = this.getCProject();
        CFormatter formatter = new CFormatter(TextUtilities.getDefaultLineDelimiter((IDocument)this.getDocument()), this.getIndentationLevel(), useCodeFormatter, project);
        formatter.format(buffer, (TemplateContext)this);
        return buffer;
    }
}

