/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMember;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.ui.editor.ITranslationUnitEditorInput;
import org.eclipse.cdt.internal.ui.refactoring.CRefactoringContext;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public class DefinitionFinder {
    public static IASTName getDefinition(IASTName name, CRefactoringContext context, IProgressMonitor pm) throws CoreException, OperationCanceledException {
        IBinding binding = name.resolveBinding();
        if (binding == null) {
            return null;
        }
        return DefinitionFinder.getDefinition(binding, name.getTranslationUnit(), context, pm);
    }

    public static IASTName getDefinition(IBinding binding, IASTTranslationUnit contextTu, CRefactoringContext context, IProgressMonitor pm) throws CoreException {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)pm, (int)10);
        IIndex index = context.getIndex();
        if (index == null) {
            return null;
        }
        IIndexBinding indexBinding = index.adaptBinding(binding);
        if (binding == null) {
            return null;
        }
        HashSet<String> searchedFiles = new HashSet<String>();
        ArrayList<IASTName> definitions = new ArrayList<IASTName>();
        IIndexName[] definitionsFromIndex = index.findNames((IBinding)indexBinding, 10);
        int remainingCount = definitionsFromIndex.length;
        SubMonitor loopProgress = sm.newChild(6).setWorkRemaining(remainingCount);
        IIndexName[] iIndexNameArray = definitionsFromIndex;
        int n = definitionsFromIndex.length;
        int n2 = 0;
        while (n2 < n) {
            ITranslationUnit tu;
            IIndexName name = iIndexNameArray[n2];
            if (sm.isCanceled()) {
                throw new OperationCanceledException();
            }
            IIndexFile indexFile = name.getFile();
            if ((contextTu.getASTFileSet().contains(indexFile) || contextTu.getIndexFileSet().contains(indexFile)) && searchedFiles.add((tu = CoreModelUtil.findTranslationUnitForLocation((IIndexFileLocation)indexFile.getLocation(), null)).getLocation().toOSString())) {
                DefinitionFinder.findDefinitionsInTranslationUnit(indexBinding, tu, context, definitions, pm);
                if (definitions.size() > 1) {
                    return null;
                }
            }
            loopProgress.setWorkRemaining(--remainingCount);
            ++n2;
        }
        if (definitions.isEmpty()) {
            IEditorPart[] dirtyEditors = EditorUtility.getDirtyEditors(true);
            loopProgress = sm.newChild(3).setWorkRemaining(dirtyEditors.length);
            IEditorPart[] iEditorPartArray = dirtyEditors;
            int n3 = dirtyEditors.length;
            n = 0;
            while (n < n3) {
                ITranslationUnit tu;
                IEditorPart editor = iEditorPartArray[n];
                if (sm.isCanceled()) {
                    throw new OperationCanceledException();
                }
                IEditorInput editorInput = editor.getEditorInput();
                if (editorInput instanceof ITranslationUnitEditorInput && searchedFiles.add((tu = ((ITranslationUnitEditorInput)editorInput).getTranslationUnit()).getLocation().toOSString())) {
                    DefinitionFinder.findDefinitionsInTranslationUnit(indexBinding, tu, context, definitions, (IProgressMonitor)loopProgress.newChild(1));
                    if (definitions.size() > 1) {
                        return null;
                    }
                }
                ++n;
            }
        }
        return definitions.size() == 1 ? (IASTName)definitions.get(0) : null;
    }

    public static boolean hasDefinition(IBinding binding, CRefactoringContext context, IProgressMonitor pm) throws CoreException, OperationCanceledException {
        IEditorPart[] dirtyEditors;
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)pm, (int)10);
        IIndex index = context.getIndex();
        if (index == null) {
            return false;
        }
        IIndexBinding indexBinding = index.adaptBinding(binding);
        if (binding == null) {
            return false;
        }
        HashSet<String> dirtyFiles = new HashSet<String>();
        IEditorPart[] iEditorPartArray = dirtyEditors = EditorUtility.getDirtyEditors(true);
        int n = dirtyEditors.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorPart editor = iEditorPartArray[n2];
            IEditorInput editorInput = editor.getEditorInput();
            if (editorInput instanceof ITranslationUnitEditorInput) {
                ITranslationUnit tu = ((ITranslationUnitEditorInput)editorInput).getTranslationUnit();
                dirtyFiles.add(tu.getLocation().toOSString());
            }
            ++n2;
        }
        HashSet<String> searchedFiles = new HashSet<String>();
        IIndexName[] definitionsFromIndex = index.findNames((IBinding)indexBinding, 10);
        int remainingCount = definitionsFromIndex.length;
        SubMonitor loopProgress = sm.newChild(6).setWorkRemaining(remainingCount);
        IIndexName[] iIndexNameArray = definitionsFromIndex;
        int n3 = definitionsFromIndex.length;
        int n4 = 0;
        while (n4 < n3) {
            IIndexName name = iIndexNameArray[n4];
            if (sm.isCanceled()) {
                throw new OperationCanceledException();
            }
            ITranslationUnit tu = CoreModelUtil.findTranslationUnitForLocation((IIndexFileLocation)name.getFile().getLocation(), null);
            String filename = tu.getLocation().toOSString();
            if (searchedFiles.add(filename) && (!dirtyFiles.contains(filename) || DefinitionFinder.hasDefinitionsInTranslationUnit(indexBinding, tu, context, (IProgressMonitor)loopProgress.newChild(1)))) {
                return true;
            }
            loopProgress.setWorkRemaining(--remainingCount);
            ++n4;
        }
        loopProgress = sm.newChild(3).setWorkRemaining(dirtyEditors.length);
        iIndexNameArray = dirtyEditors;
        n3 = dirtyEditors.length;
        n4 = 0;
        while (n4 < n3) {
            ITranslationUnit tu;
            String filename;
            IIndexName editor = iIndexNameArray[n4];
            if (sm.isCanceled()) {
                throw new OperationCanceledException();
            }
            IEditorInput editorInput = editor.getEditorInput();
            if (editorInput instanceof ITranslationUnitEditorInput && searchedFiles.add(filename = (tu = ((ITranslationUnitEditorInput)editorInput).getTranslationUnit()).getLocation().toOSString()) && DefinitionFinder.hasDefinitionsInTranslationUnit(indexBinding, tu, context, (IProgressMonitor)loopProgress.newChild(1))) {
                return true;
            }
            ++n4;
        }
        return false;
    }

    private static void findDefinitionsInTranslationUnit(IIndexBinding binding, ITranslationUnit tu, CRefactoringContext context, List<IASTName> definitions, IProgressMonitor pm) throws CoreException, OperationCanceledException {
        IASTTranslationUnit ast = context.getAST(tu, pm);
        ArrayUtil.addAll(definitions, (Object[])ast.getDefinitionsInAST((IBinding)binding));
    }

    private static boolean hasDefinitionsInTranslationUnit(IIndexBinding binding, ITranslationUnit tu, CRefactoringContext context, IProgressMonitor pm) throws CoreException, OperationCanceledException {
        IASTTranslationUnit ast = context.getAST(tu, pm);
        return ast.getDefinitionsInAST((IBinding)binding).length != 0;
    }

    public static IASTName getMemberDeclaration(IASTName memberName, CRefactoringContext context, IProgressMonitor pm) throws CoreException, OperationCanceledException {
        IBinding binding = memberName.resolveBinding();
        if (!(binding instanceof ICPPMember)) {
            return null;
        }
        return DefinitionFinder.getMemberDeclaration((ICPPMember)binding, memberName.getTranslationUnit(), context, pm);
    }

    public static IASTName getMemberDeclaration(ICPPMember member, IASTTranslationUnit contextTu, CRefactoringContext context, IProgressMonitor pm) throws CoreException, OperationCanceledException {
        IASTName[] memberDeclarationNames;
        IASTName classDefintionName = DefinitionFinder.getDefinition((IBinding)member.getClassOwner(), contextTu, context, pm);
        if (classDefintionName == null) {
            return null;
        }
        IASTCompositeTypeSpecifier compositeTypeSpecifier = (IASTCompositeTypeSpecifier)ASTQueries.findAncestorWithType((IASTNode)classDefintionName, IASTCompositeTypeSpecifier.class);
        IASTTranslationUnit ast = classDefintionName.getTranslationUnit();
        IIndex index = context.getIndex();
        if (index == null) {
            return null;
        }
        IASTName[] iASTNameArray = memberDeclarationNames = ast.getDeclarationsInAST((IBinding)index.adaptBinding((IBinding)member));
        int n = memberDeclarationNames.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclaration declaration;
            IASTName name = iASTNameArray[n2];
            if (name.getPropertyInParent() == IASTDeclarator.DECLARATOR_NAME && (declaration = (IASTDeclaration)ASTQueries.findAncestorWithType((IASTNode)name, IASTDeclaration.class)).getParent() == compositeTypeSpecifier) {
                return name;
            }
            ++n2;
        }
        return null;
    }
}

