/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.wizards.classwizard;

import java.util.List;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.internal.ui.wizards.classwizard.BaseClassesLabelProvider;
import org.eclipse.cdt.internal.ui.wizards.classwizard.IMethodStub;
import org.eclipse.cdt.internal.ui.wizards.classwizard.MethodStubsLabelProvider;
import org.eclipse.cdt.internal.ui.wizards.classwizard.NewClassWizardMessages;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;

public class MethodStubsListDialogField
extends CheckedListDialogField<IMethodStub> {
    private static final String CP_NAME = "name";
    private static final String CP_ACCESS = "access";
    private static final String CP_VIRTUAL = "virtual";
    private static final String CP_INLINE = "inline";
    static final Integer INDEX_YES = 0;
    static final Integer INDEX_NO = 1;
    static final Integer INDEX_PUBLIC = 0;
    static final Integer INDEX_PROTECTED = 1;
    static final Integer INDEX_PRIVATE = 2;

    public MethodStubsListDialogField(String title, IListAdapter<IMethodStub> listAdapter) {
        super(listAdapter, null, (IBaseLabelProvider)new MethodStubsLabelProvider());
        this.setLabelText(title);
        String[] headers = new String[]{NewClassWizardMessages.MethodStubsDialogField_headings_name, NewClassWizardMessages.MethodStubsDialogField_headings_access, NewClassWizardMessages.MethodStubsDialogField_headings_virtual, NewClassWizardMessages.MethodStubsDialogField_headings_inline};
        ColumnLayoutData[] columns = new ColumnLayoutData[]{new ColumnWeightData(70, 30), new ColumnWeightData(40, 30), new ColumnWeightData(30, 25), new ColumnWeightData(30, 25)};
        this.setTableColumns(new ListDialogField.ColumnsDescription(columns, headers, true));
    }

    @Override
    protected boolean managedButtonPressed(int index) {
        super.managedButtonPressed(index);
        return false;
    }

    @Override
    protected TableViewer createTableViewer(Composite parent) {
        TableViewer viewer = super.createTableViewer(parent);
        Table table = viewer.getTable();
        table.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = NewClassWizardMessages.NewClassCreationWizardPage_methodStubs_label;
            }
        });
        ComboBoxCellEditor virtualCellEditor = new ComboBoxCellEditor((Composite)table, new String[]{BaseClassesLabelProvider.getYesNoText(true), BaseClassesLabelProvider.getYesNoText(false)}, 8);
        ComboBoxCellEditor accessCellEditor = new ComboBoxCellEditor((Composite)table, new String[]{BaseClassesLabelProvider.getAccessText(ASTAccessVisibility.PUBLIC), BaseClassesLabelProvider.getAccessText(ASTAccessVisibility.PROTECTED), BaseClassesLabelProvider.getAccessText(ASTAccessVisibility.PRIVATE)}, 8);
        CellEditor[] cellEditorArray = new CellEditor[4];
        cellEditorArray[1] = accessCellEditor;
        cellEditorArray[2] = virtualCellEditor;
        cellEditorArray[3] = virtualCellEditor;
        viewer.setCellEditors(cellEditorArray);
        viewer.setColumnProperties(new String[]{CP_NAME, CP_ACCESS, CP_VIRTUAL, CP_INLINE});
        viewer.setCellModifier((ICellModifier)new CellHandler());
        return viewer;
    }

    public void addMethodStub(IMethodStub methodStub, boolean checked) {
        this.addElement(methodStub);
        this.setChecked(methodStub, checked);
    }

    public IMethodStub[] getMethodStubs() {
        List<IMethodStub> allStubs = this.getElements();
        return allStubs.toArray(new IMethodStub[allStubs.size()]);
    }

    public IMethodStub[] getCheckedMethodStubs() {
        List<IMethodStub> checkedStubs = this.getCheckedElements();
        return checkedStubs.toArray(new IMethodStub[checkedStubs.size()]);
    }

    private final class CellHandler
    implements ICellModifier {
        private CellHandler() {
        }

        public boolean canModify(Object element, String property) {
            if (element instanceof IMethodStub) {
                IMethodStub stub = (IMethodStub)element;
                if (property.equals(MethodStubsListDialogField.CP_ACCESS)) {
                    return stub.canModifyAccess();
                }
                if (property.equals(MethodStubsListDialogField.CP_VIRTUAL)) {
                    return stub.canModifyVirtual();
                }
                if (property.equals(MethodStubsListDialogField.CP_INLINE)) {
                    return stub.canModifyInline();
                }
            }
            return false;
        }

        public Object getValue(Object element, String property) {
            if (!(element instanceof IMethodStub)) {
                return null;
            }
            IMethodStub stub = (IMethodStub)element;
            if (property.equals(MethodStubsListDialogField.CP_ACCESS)) {
                if (stub.getAccess() == ASTAccessVisibility.PRIVATE) {
                    return INDEX_PRIVATE;
                }
                if (stub.getAccess() == ASTAccessVisibility.PROTECTED) {
                    return INDEX_PROTECTED;
                }
                return INDEX_PUBLIC;
            }
            if (property.equals(MethodStubsListDialogField.CP_VIRTUAL)) {
                if (stub.isVirtual()) {
                    return INDEX_YES;
                }
                return INDEX_NO;
            }
            if (property.equals(MethodStubsListDialogField.CP_INLINE)) {
                if (stub.isInline()) {
                    return INDEX_YES;
                }
                return INDEX_NO;
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            Object data;
            IMethodStub stub = null;
            if (element instanceof IMethodStub) {
                stub = (IMethodStub)element;
            } else if (element instanceof Item && (data = ((Item)element).getData()) instanceof IMethodStub) {
                stub = (IMethodStub)data;
            }
            if (stub != null) {
                Integer yesno;
                if (property.equals(MethodStubsListDialogField.CP_ACCESS) && value instanceof Integer) {
                    Integer access = (Integer)value;
                    if (access.equals(INDEX_PRIVATE)) {
                        stub.setAccess(ASTAccessVisibility.PRIVATE);
                    } else if (access.equals(INDEX_PROTECTED)) {
                        stub.setAccess(ASTAccessVisibility.PROTECTED);
                    } else {
                        stub.setAccess(ASTAccessVisibility.PUBLIC);
                    }
                    MethodStubsListDialogField.this.refresh();
                } else if (property.equals(MethodStubsListDialogField.CP_VIRTUAL) && value instanceof Integer) {
                    yesno = (Integer)value;
                    stub.setVirtual(yesno.equals(INDEX_YES));
                    MethodStubsListDialogField.this.refresh();
                } else if (property.equals(MethodStubsListDialogField.CP_INLINE) && value instanceof Integer) {
                    yesno = (Integer)value;
                    stub.setInline(yesno.equals(INDEX_YES));
                    MethodStubsListDialogField.this.refresh();
                }
            }
        }
    }
}

