/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.base.core;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.NotifyingList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.viatra.query.runtime.base.api.BaseIndexOptions;
import org.eclipse.viatra.query.runtime.base.api.DataTypeListener;
import org.eclipse.viatra.query.runtime.base.api.EMFBaseIndexChangeListener;
import org.eclipse.viatra.query.runtime.base.api.FeatureListener;
import org.eclipse.viatra.query.runtime.base.api.IEClassifierProcessor;
import org.eclipse.viatra.query.runtime.base.api.IEMFIndexingErrorListener;
import org.eclipse.viatra.query.runtime.base.api.IEStructuralFeatureProcessor;
import org.eclipse.viatra.query.runtime.base.api.IndexingLevel;
import org.eclipse.viatra.query.runtime.base.api.InstanceListener;
import org.eclipse.viatra.query.runtime.base.api.LightweightEObjectObserver;
import org.eclipse.viatra.query.runtime.base.api.NavigationHelper;
import org.eclipse.viatra.query.runtime.base.api.filters.IBaseIndexObjectFilter;
import org.eclipse.viatra.query.runtime.base.api.filters.IBaseIndexResourceFilter;
import org.eclipse.viatra.query.runtime.base.comprehension.EMFModelComprehension;
import org.eclipse.viatra.query.runtime.base.comprehension.EMFVisitor;
import org.eclipse.viatra.query.runtime.base.core.EMFBaseIndexInstanceStore;
import org.eclipse.viatra.query.runtime.base.core.EMFBaseIndexMetaStore;
import org.eclipse.viatra.query.runtime.base.core.EMFBaseIndexStatisticsStore;
import org.eclipse.viatra.query.runtime.base.core.NavigationHelperContentAdapter;
import org.eclipse.viatra.query.runtime.base.core.NavigationHelperSetting;
import org.eclipse.viatra.query.runtime.base.core.NavigationHelperVisitor;
import org.eclipse.viatra.query.runtime.base.exception.ViatraBaseException;

public class NavigationHelperImpl
implements NavigationHelper {
    protected IndexingLevel wildcardMode;
    protected Notifier notifier;
    protected Set<Notifier> modelRoots;
    private boolean expansionAllowed;
    protected NavigationHelperContentAdapter contentAdapter;
    private final Logger logger;
    protected Map<Object, IndexingLevel> directlyObservedClasses = new HashMap<Object, IndexingLevel>();
    protected Map<Object, IndexingLevel> allObservedClasses = null;
    protected Map<Object, IndexingLevel> observedDataTypes;
    protected Map<Object, IndexingLevel> observedFeatures;
    protected Set<Object> ignoreResolveNotificationFeatures;
    protected boolean delayTraversals = false;
    protected Map<Object, IndexingLevel> delayedClasses;
    protected Map<Object, IndexingLevel> delayedFeatures;
    protected Map<Object, IndexingLevel> delayedDataTypes;
    protected Multimap<EObject, EReference> delayedProxyResolutions = LinkedHashMultimap.create();
    protected Set<Resource> resolutionDelayingResources = new HashSet<Resource>();
    protected Queue<Runnable> traversalCallbacks = new LinkedList<Runnable>();
    private final Set<EMFBaseIndexChangeListener> baseIndexChangeListeners;
    private final Map<LightweightEObjectObserver, Collection<EObject>> lightweightObservers;
    private final Map<InstanceListener, Set<EClass>> subscribedInstanceListeners;
    private final Map<FeatureListener, Set<EStructuralFeature>> subscribedFeatureListeners;
    private final Map<DataTypeListener, Set<EDataType>> subscribedDataTypeListeners;
    private Table<Object, InstanceListener, Set<EClass>> instanceListeners;
    private Table<Object, FeatureListener, Set<EStructuralFeature>> featureListeners;
    private Table<Object, DataTypeListener, Set<EDataType>> dataTypeListeners;
    private final Set<IEMFIndexingErrorListener> errorListeners;
    private final BaseIndexOptions baseIndexOptions;
    private EMFModelComprehension comprehension;
    private boolean loggedRegistrationMessage = false;
    EMFBaseIndexMetaStore metaStore;
    EMFBaseIndexInstanceStore instanceStore;
    EMFBaseIndexStatisticsStore statsStore;

    <T> Set<T> setMinus(Collection<? extends T> a, Collection<T> b) {
        HashSet<T> result = new HashSet<T>(a);
        result.removeAll(b);
        return result;
    }

    <T extends EObject> Set<T> resolveAllInternal(Set<? extends T> a) {
        if (a == null) {
            a = Collections.emptySet();
        }
        HashSet<EObject> result = new HashSet<EObject>();
        for (EObject eObject : a) {
            if (eObject.eIsProxy()) {
                result.add(EcoreUtil.resolve((EObject)eObject, null));
                continue;
            }
            result.add(eObject);
        }
        return result;
    }

    Set<Object> resolveClassifiersToKey(Set<? extends EClassifier> classes) {
        Set<? extends EClassifier> resolveds = this.resolveAllInternal(classes);
        HashSet<Object> result = new HashSet<Object>();
        for (EClassifier eClassifier : resolveds) {
            result.add(this.toKey(eClassifier));
        }
        return result;
    }

    Set<Object> resolveFeaturesToKey(Set<? extends EStructuralFeature> features) {
        Set<? extends EStructuralFeature> resolveds = this.resolveAllInternal(features);
        HashSet<Object> result = new HashSet<Object>();
        for (EStructuralFeature eStructuralFeature : resolveds) {
            result.add(this.toKey(eStructuralFeature));
        }
        return result;
    }

    @Override
    public boolean isInWildcardMode() {
        return this.isInWildcardMode(IndexingLevel.FULL);
    }

    @Override
    public boolean isInWildcardMode(IndexingLevel level) {
        return this.wildcardMode.providesLevel(level);
    }

    @Override
    public boolean isInDynamicEMFMode() {
        return this.baseIndexOptions.isDynamicEMFMode();
    }

    public BaseIndexOptions getBaseIndexOptions() {
        return this.baseIndexOptions.copy();
    }

    public EMFModelComprehension getComprehension() {
        return this.comprehension;
    }

    public NavigationHelperImpl(Notifier emfRoot, BaseIndexOptions options, Logger logger) throws ViatraBaseException {
        this.baseIndexOptions = options.copy();
        this.logger = logger;
        assert (logger != null);
        this.comprehension = new EMFModelComprehension(this.baseIndexOptions);
        this.wildcardMode = this.baseIndexOptions.getWildcardLevel();
        this.subscribedInstanceListeners = new HashMap<InstanceListener, Set<EClass>>();
        this.subscribedFeatureListeners = new HashMap<FeatureListener, Set<EStructuralFeature>>();
        this.subscribedDataTypeListeners = new HashMap<DataTypeListener, Set<EDataType>>();
        this.lightweightObservers = new HashMap<LightweightEObjectObserver, Collection<EObject>>();
        this.observedFeatures = new HashMap<Object, IndexingLevel>();
        this.ignoreResolveNotificationFeatures = new HashSet<Object>();
        this.observedDataTypes = new HashMap<Object, IndexingLevel>();
        this.metaStore = new EMFBaseIndexMetaStore(this);
        this.instanceStore = new EMFBaseIndexInstanceStore(this, logger);
        this.statsStore = new EMFBaseIndexStatisticsStore(this, logger);
        this.contentAdapter = new NavigationHelperContentAdapter(this);
        this.baseIndexChangeListeners = new HashSet<EMFBaseIndexChangeListener>();
        this.errorListeners = new LinkedHashSet<IEMFIndexingErrorListener>();
        this.notifier = emfRoot;
        this.modelRoots = new HashSet<Notifier>();
        this.expansionAllowed = false;
        if (emfRoot != null) {
            this.addRootInternal(emfRoot);
        }
    }

    @Override
    public IndexingLevel getWildcardLevel() {
        return this.wildcardMode;
    }

    @Override
    public void setWildcardLevel(IndexingLevel level) {
        try {
            IndexingLevel mergedLevel = this.wildcardMode.merge(level);
            if (mergedLevel != this.wildcardMode) {
                this.wildcardMode = mergedLevel;
                final NavigationHelperVisitor.TraversingVisitor visitor = new NavigationHelperVisitor.TraversingVisitor(this, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
                this.coalesceTraversals(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        NavigationHelperImpl.this.traverse(visitor);
                        return null;
                    }
                });
            }
        }
        catch (InvocationTargetException ex) {
            this.processingFatal(ex.getCause(), "Setting wildcard level: " + (Object)((Object)level));
        }
        catch (Exception ex) {
            this.processingFatal(ex, "Setting wildcard level: " + (Object)((Object)level));
        }
    }

    public NavigationHelperContentAdapter getContentAdapter() {
        return this.contentAdapter;
    }

    public Map<Object, IndexingLevel> getObservedFeaturesInternal() {
        return this.observedFeatures;
    }

    public boolean isFeatureResolveIgnored(EStructuralFeature feature) {
        return this.ignoreResolveNotificationFeatures.contains(this.toKey(feature));
    }

    @Override
    public void dispose() {
        this.ensureNoListenersForDispose();
        for (Notifier root : this.modelRoots) {
            this.contentAdapter.removeAdapter(root);
        }
    }

    @Override
    public Set<Object> getDataTypeInstances(EDataType type) {
        Object typeKey = this.toKey((EClassifier)type);
        Map<Object, Integer> valMap = this.instanceStore.getDataTypeMap(typeKey);
        if (valMap != null) {
            return Collections.unmodifiableSet(valMap.keySet());
        }
        return Collections.emptySet();
    }

    @Override
    public Set<EStructuralFeature.Setting> findByAttributeValue(Object value_) {
        Object value = this.toCanonicalValueRepresentation(value_);
        HashSet<EStructuralFeature.Setting> retSet = new HashSet<EStructuralFeature.Setting>();
        Map valMap = this.instanceStore.getValueToFeatureToHolderMap().row(value);
        for (Map.Entry entry : valMap.entrySet()) {
            Collection holders = (Collection)entry.getValue();
            EStructuralFeature feature = this.metaStore.getKnownFeatureForKey(entry.getKey());
            for (EObject holder : EMFBaseIndexInstanceStore.holderCollectionToUniqueSet(holders)) {
                retSet.add(new NavigationHelperSetting(feature, holder, value));
            }
        }
        return retSet;
    }

    @Override
    public Set<EStructuralFeature.Setting> findByAttributeValue(Object value_, Collection<EAttribute> attributes) {
        Object value = this.toCanonicalValueRepresentation(value_);
        HashSet<EStructuralFeature.Setting> retSet = new HashSet<EStructuralFeature.Setting>();
        Map valMap = this.instanceStore.getValueToFeatureToHolderMap().row(value);
        for (EAttribute attr : attributes) {
            Object feature = this.toKey((EStructuralFeature)attr);
            Collection holders = (Collection)valMap.get(feature);
            if (holders == null) continue;
            for (EObject holder : EMFBaseIndexInstanceStore.holderCollectionToUniqueSet(holders)) {
                retSet.add(new NavigationHelperSetting((EStructuralFeature)attr, holder, value));
            }
        }
        return retSet;
    }

    @Override
    public Set<EObject> findByAttributeValue(Object value_, EAttribute attribute) {
        Object feature;
        Object value = this.toCanonicalValueRepresentation(value_);
        Map valMap = this.instanceStore.getValueToFeatureToHolderMap().row(value);
        Collection holders = (Collection)valMap.get(feature = this.toKey((EStructuralFeature)attribute));
        if (holders == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(EMFBaseIndexInstanceStore.holderCollectionToUniqueSet(holders));
    }

    @Override
    public void processAllFeatureInstances(EStructuralFeature feature, IEStructuralFeatureProcessor processor) {
        Map instanceMap = this.instanceStore.getValueToFeatureToHolderMap().column(this.toKey(feature));
        for (Map.Entry entry : instanceMap.entrySet()) {
            Collection holders = (Collection)entry.getValue();
            for (EObject src : EMFBaseIndexInstanceStore.holderCollectionToUniqueSet(holders)) {
                processor.process(feature, src, entry.getKey());
            }
        }
    }

    @Override
    public void processDirectInstances(EClass type, IEClassifierProcessor.IEClassProcessor processor) {
        Object typeKey = this.toKey((EClassifier)type);
        this.processDirectInstancesInternal(type, processor, typeKey);
    }

    @Override
    public void processAllInstances(EClass type, IEClassifierProcessor.IEClassProcessor processor) {
        Object typeKey = this.toKey((EClassifier)type);
        Set<Object> subTypes = this.metaStore.getSubTypeMap().get(typeKey);
        if (subTypes != null) {
            for (Object subTypeKey : subTypes) {
                this.processDirectInstancesInternal(type, processor, subTypeKey);
            }
        }
        this.processDirectInstancesInternal(type, processor, typeKey);
    }

    @Override
    public void processDataTypeInstances(EDataType type, IEClassifierProcessor.IEDataTypeProcessor processor) {
        Object typeKey = this.toKey((EClassifier)type);
        Map<Object, Integer> valMap = this.instanceStore.getDataTypeMap(typeKey);
        if (valMap == null) {
            return;
        }
        for (Object value : valMap.keySet()) {
            processor.process(type, value);
        }
    }

    private void processDirectInstancesInternal(EClass type, IEClassifierProcessor.IEClassProcessor processor, Object typeKey) {
        Set<EObject> instances = this.instanceStore.getInstanceSet(typeKey);
        if (instances != null) {
            for (EObject eObject : instances) {
                processor.process(type, eObject);
            }
        }
    }

    @Override
    public Set<EStructuralFeature.Setting> getInverseReferences(EObject target) {
        HashSet<EStructuralFeature.Setting> retSet = new HashSet<EStructuralFeature.Setting>();
        Map valMap = this.instanceStore.getValueToFeatureToHolderMap().row((Object)target);
        for (Map.Entry entry : valMap.entrySet()) {
            Collection holders = (Collection)entry.getValue();
            for (EObject source : EMFBaseIndexInstanceStore.holderCollectionToUniqueSet(holders)) {
                EStructuralFeature feature = this.metaStore.getKnownFeatureForKey(entry.getKey());
                retSet.add(new NavigationHelperSetting(feature, source, target));
            }
        }
        return retSet;
    }

    @Override
    public Set<EStructuralFeature.Setting> getInverseReferences(EObject target, Collection<EReference> references) {
        HashSet<EStructuralFeature.Setting> retSet = new HashSet<EStructuralFeature.Setting>();
        Map valMap = this.instanceStore.getValueToFeatureToHolderMap().row((Object)target);
        for (EReference ref : references) {
            Object feature = this.toKey((EStructuralFeature)ref);
            Collection holders = (Collection)valMap.get(feature);
            if (holders == null) continue;
            for (EObject source : EMFBaseIndexInstanceStore.holderCollectionToUniqueSet(holders)) {
                retSet.add(new NavigationHelperSetting((EStructuralFeature)ref, source, target));
            }
        }
        return retSet;
    }

    @Override
    public Set<EObject> getInverseReferences(EObject target, EReference reference) {
        Object feature = this.toKey((EStructuralFeature)reference);
        Map valMap = this.instanceStore.getValueToFeatureToHolderMap().row((Object)target);
        Collection holders = (Collection)valMap.get(feature);
        if (holders == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(EMFBaseIndexInstanceStore.holderCollectionToUniqueSet(holders));
    }

    @Override
    public Set<EObject> getReferenceValues(EObject source, EReference reference) {
        Set<Object> targets = this.getFeatureTargets(source, (EStructuralFeature)reference);
        return targets;
    }

    @Override
    public Set<Object> getFeatureTargets(EObject source, EStructuralFeature _feature) {
        Object feature = this.toKey(_feature);
        Set valSet = (Set)this.instanceStore.getHolderToFeatureToValueMap().get((Object)source, feature);
        if (valSet == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(valSet);
    }

    @Override
    public Map<EObject, Set<Object>> getFeatureInstances(EStructuralFeature _feature) {
        Object feature = this.toKey(_feature);
        Map valMap = this.instanceStore.getHolderToFeatureToValueMap().column(feature);
        if (valMap == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(valMap);
    }

    @Override
    public Set<EObject> getDirectInstances(EClass type) {
        Object typeKey = this.toKey((EClassifier)type);
        Set<EObject> valSet = this.instanceStore.getInstanceSet(typeKey);
        if (valSet == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(valSet);
    }

    private Object toKey(EClassifier eClassifier) {
        return this.metaStore.toKey(eClassifier);
    }

    private Object toKey(EStructuralFeature feature) {
        return this.metaStore.toKey(feature);
    }

    @Override
    public Object toCanonicalValueRepresentation(Object value) {
        return this.metaStore.toInternalValueRepresentation(value);
    }

    @Override
    public Set<EObject> getAllInstances(EClass type) {
        Set<EObject> instances;
        HashSet<EObject> retSet = new HashSet<EObject>();
        Object typeKey = this.toKey((EClassifier)type);
        Set<Object> subTypes = this.metaStore.getSubTypeMap().get(typeKey);
        if (subTypes != null) {
            for (Object subTypeKey : subTypes) {
                Set<EObject> instances2 = this.instanceStore.getInstanceSet(subTypeKey);
                if (instances2 == null) continue;
                retSet.addAll(instances2);
            }
        }
        if ((instances = this.instanceStore.getInstanceSet(typeKey)) != null) {
            retSet.addAll(instances);
        }
        return retSet;
    }

    @Override
    public boolean isInstanceOfUnscoped(EObject object, EClass clazz) {
        Object typeKey;
        Object candidateTypeKey = this.toKey((EClassifier)clazz);
        if (candidateTypeKey.equals(typeKey = this.toKey((EClassifier)object.eClass()))) {
            return true;
        }
        if (this.metaStore.getEObjectClassKey().equals(candidateTypeKey)) {
            return true;
        }
        Set<Object> superTypes = this.metaStore.getSuperTypeMap().get(typeKey);
        return superTypes.contains(candidateTypeKey);
    }

    @Override
    public Set<EObject> findByFeatureValue(Object value_, EStructuralFeature _feature) {
        Object value = this.toCanonicalValueRepresentation(value_);
        Object feature = this.toKey(_feature);
        HashSet<EObject> retSet = new HashSet<EObject>();
        Map valMap = this.instanceStore.getValueToFeatureToHolderMap().row(value);
        Collection holders = (Collection)valMap.get(feature);
        if (holders != null) {
            retSet.addAll(EMFBaseIndexInstanceStore.holderCollectionToUniqueSet(holders));
        }
        return retSet;
    }

    @Override
    public Set<EObject> getHoldersOfFeature(EStructuralFeature _feature) {
        Object feature = this.toKey(_feature);
        Multiset<EObject> holders = this.instanceStore.getFeatureToHolderMap().get(feature);
        if (holders == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(holders.elementSet());
    }

    @Override
    public void addInstanceListener(Collection<EClass> classes, InstanceListener listener) {
        Set<EClass> delta;
        Set<EClass> registered = this.subscribedInstanceListeners.get(listener);
        if (registered == null) {
            registered = new HashSet<EClass>();
            this.subscribedInstanceListeners.put(listener, registered);
        }
        if (!(delta = this.setMinus(classes, registered)).isEmpty()) {
            registered.addAll(delta);
            if (this.instanceListeners != null) {
                for (EClass subscriptionType : delta) {
                    Object superElementTypeKey = this.toKey((EClassifier)subscriptionType);
                    this.addInstanceListenerInternal(listener, subscriptionType, superElementTypeKey);
                    Set<Object> subTypeKeys = this.metaStore.getSubTypeMap().get(superElementTypeKey);
                    if (subTypeKeys == null) continue;
                    for (Object subTypeKey : subTypeKeys) {
                        this.addInstanceListenerInternal(listener, subscriptionType, subTypeKey);
                    }
                }
            }
        }
    }

    @Override
    public void removeInstanceListener(Collection<EClass> classes, InstanceListener listener) {
        Set<EClass> restriction = this.subscribedInstanceListeners.get(listener);
        if (restriction != null) {
            boolean changed = restriction.removeAll(classes);
            if (restriction.size() == 0) {
                this.subscribedInstanceListeners.remove(listener);
            }
            if (changed) {
                this.instanceListeners = null;
            }
        }
    }

    @Override
    public void addFeatureListener(Collection<? extends EStructuralFeature> features, FeatureListener listener) {
        Set<EStructuralFeature> delta;
        Set<EStructuralFeature> registered = this.subscribedFeatureListeners.get(listener);
        if (registered == null) {
            registered = new HashSet<EStructuralFeature>();
            this.subscribedFeatureListeners.put(listener, registered);
        }
        if (!(delta = this.setMinus(features, registered)).isEmpty()) {
            registered.addAll(delta);
            if (this.featureListeners != null) {
                for (EStructuralFeature subscriptionType : delta) {
                    this.addFeatureListenerInternal(listener, subscriptionType, this.toKey(subscriptionType));
                }
            }
        }
    }

    @Override
    public void removeFeatureListener(Collection<? extends EStructuralFeature> features, FeatureListener listener) {
        Collection restriction = this.subscribedFeatureListeners.get(listener);
        if (restriction != null) {
            boolean changed = restriction.removeAll(features);
            if (restriction.size() == 0) {
                this.subscribedFeatureListeners.remove(listener);
            }
            if (changed) {
                this.featureListeners = null;
            }
        }
    }

    @Override
    public void addDataTypeListener(Collection<EDataType> types, DataTypeListener listener) {
        Set<EDataType> delta;
        Set<EDataType> registered = this.subscribedDataTypeListeners.get(listener);
        if (registered == null) {
            registered = new HashSet<EDataType>();
            this.subscribedDataTypeListeners.put(listener, registered);
        }
        if (!(delta = this.setMinus(types, registered)).isEmpty()) {
            registered.addAll(delta);
            if (this.dataTypeListeners != null) {
                for (EDataType subscriptionType : delta) {
                    this.addDatatypeListenerInternal(listener, subscriptionType, this.toKey((EClassifier)subscriptionType));
                }
            }
        }
    }

    @Override
    public void removeDataTypeListener(Collection<EDataType> types, DataTypeListener listener) {
        Collection restriction = this.subscribedDataTypeListeners.get(listener);
        if (restriction != null) {
            boolean changed = restriction.removeAll(types);
            if (restriction.size() == 0) {
                this.subscribedDataTypeListeners.remove(listener);
            }
            if (changed) {
                this.dataTypeListeners = null;
            }
        }
    }

    public Map<Object, IndexingLevel> getObservedDataTypesInternal() {
        return this.observedDataTypes;
    }

    @Override
    public boolean addLightweightEObjectObserver(LightweightEObjectObserver observer, EObject observedObject) {
        Collection<EObject> observedObjects = this.lightweightObservers.get(observer);
        if (observedObjects == null) {
            observedObjects = new HashSet<EObject>();
            this.lightweightObservers.put(observer, observedObjects);
        }
        return observedObjects.add(observedObject);
    }

    @Override
    public boolean removeLightweightEObjectObserver(LightweightEObjectObserver observer, EObject observedObject) {
        boolean result = false;
        Collection<EObject> observedObjects = this.lightweightObservers.get(observer);
        if (observedObjects != null) {
            result = observedObjects.remove(observedObject);
            if (observedObjects.isEmpty()) {
                this.lightweightObservers.remove(observer);
            }
        }
        return result;
    }

    public Map<LightweightEObjectObserver, Collection<EObject>> getLightweightObservers() {
        return this.lightweightObservers;
    }

    public void notifyBaseIndexChangeListeners() {
        this.notifyBaseIndexChangeListeners(this.instanceStore.isDirty);
        if (this.instanceStore.isDirty) {
            this.instanceStore.isDirty = false;
        }
    }

    protected void notifyBaseIndexChangeListeners(boolean baseIndexChanged) {
        if (!this.baseIndexChangeListeners.isEmpty()) {
            for (EMFBaseIndexChangeListener listener : new ArrayList<EMFBaseIndexChangeListener>(this.baseIndexChangeListeners)) {
                try {
                    if (listener.onlyOnIndexChange() && !baseIndexChanged) continue;
                    listener.notifyChanged(baseIndexChanged);
                }
                catch (Exception ex) {
                    this.notifyFatalListener("VIATRA Base encountered an error in delivering notifications about changes. ", ex);
                }
            }
        }
    }

    void notifyDataTypeListeners(Object typeKey, Object value, boolean isInsertion, boolean firstOrLastOccurrence) {
        for (Map.Entry entry : this.getDataTypeListeners().row(typeKey).entrySet()) {
            DataTypeListener listener = (DataTypeListener)entry.getKey();
            for (EDataType subscriptionType : (Set)entry.getValue()) {
                if (isInsertion) {
                    listener.dataTypeInstanceInserted(subscriptionType, value, firstOrLastOccurrence);
                    continue;
                }
                listener.dataTypeInstanceDeleted(subscriptionType, value, firstOrLastOccurrence);
            }
        }
    }

    void notifyFeatureListeners(EObject host, Object featureKey, Object value, boolean isInsertion) {
        for (Map.Entry entry : this.getFeatureListeners().row(featureKey).entrySet()) {
            FeatureListener listener = (FeatureListener)entry.getKey();
            for (EStructuralFeature subscriptionType : (Set)entry.getValue()) {
                if (isInsertion) {
                    listener.featureInserted(host, subscriptionType, value);
                    continue;
                }
                listener.featureDeleted(host, subscriptionType, value);
            }
        }
    }

    void notifyInstanceListeners(Object clazzKey, EObject instance, boolean isInsertion) {
        for (Map.Entry entry : this.getInstanceListeners().row(clazzKey).entrySet()) {
            InstanceListener listener = (InstanceListener)entry.getKey();
            for (EClass subscriptionType : (Set)entry.getValue()) {
                if (isInsertion) {
                    listener.instanceInserted(subscriptionType, instance);
                    continue;
                }
                listener.instanceDeleted(subscriptionType, instance);
            }
        }
    }

    void notifyLightweightObservers(EObject host, EStructuralFeature feature, Notification notification) {
        for (Map.Entry<LightweightEObjectObserver, Collection<EObject>> entry : this.getLightweightObservers().entrySet()) {
            if (!entry.getValue().contains(host)) continue;
            entry.getKey().notifyFeatureChanged(host, feature, notification);
        }
    }

    @Override
    public void addBaseIndexChangeListener(EMFBaseIndexChangeListener listener) {
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0, (Object)"Cannot add null listener!");
        this.baseIndexChangeListeners.add(listener);
    }

    @Override
    public void removeBaseIndexChangeListener(EMFBaseIndexChangeListener listener) {
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0, (Object)"Cannot remove null listener!");
        this.baseIndexChangeListeners.remove(listener);
    }

    @Override
    public boolean addIndexingErrorListener(IEMFIndexingErrorListener listener) {
        return this.errorListeners.add(listener);
    }

    @Override
    public boolean removeIndexingErrorListener(IEMFIndexingErrorListener listener) {
        return this.errorListeners.remove(listener);
    }

    protected void processingFatal(Throwable ex, String task) {
        this.notifyFatalListener(this.logTaskFormat(task), ex);
    }

    protected void processingError(Throwable ex, String task) {
        this.notifyErrorListener(this.logTaskFormat(task), ex);
    }

    public void notifyErrorListener(String message, Throwable t) {
        this.logger.error((Object)message, t);
        for (IEMFIndexingErrorListener listener : this.errorListeners) {
            listener.error(message, t);
        }
    }

    public void notifyFatalListener(String message, Throwable t) {
        this.logger.fatal((Object)message, t);
        for (IEMFIndexingErrorListener listener : this.errorListeners) {
            listener.fatal(message, t);
        }
    }

    private String logTaskFormat(String task) {
        return "VIATRA Query encountered an error in processing the EMF model. This happened while trying to " + task;
    }

    protected void considerForExpansion(EObject obj) {
        Resource eResource;
        if (this.expansionAllowed && (eResource = obj.eResource()) != null && eResource.getResourceSet() == null) {
            this.expandToAdditionalRoot((Notifier)eResource);
        }
    }

    protected void expandToAdditionalRoot(Notifier root) {
        IBaseIndexResourceFilter resourceFilter;
        if (this.modelRoots.contains(root)) {
            return;
        }
        if (root instanceof ResourceSet) {
            this.expansionAllowed = true;
        } else if (root instanceof Resource && (resourceFilter = this.baseIndexOptions.getResourceFilterConfiguration()) != null && resourceFilter.isResourceFiltered((Resource)root)) {
            return;
        }
        IBaseIndexObjectFilter objectFilter = this.baseIndexOptions.getObjectFilterConfiguration();
        if (objectFilter != null && objectFilter.isFiltered(root)) {
            return;
        }
        this.modelRoots.add(root);
        this.contentAdapter.addAdapter(root);
        this.notifyBaseIndexChangeListeners();
    }

    public boolean isExpansionAllowed() {
        return this.expansionAllowed;
    }

    public Set<Object> getDirectlyObservedClassesInternal() {
        return this.directlyObservedClasses.keySet();
    }

    boolean isObservedInternal(Object clazzKey) {
        return this.isInWildcardMode() || this.getAllObservedClassesInternal().containsKey(clazzKey);
    }

    private static <V> void putIntoMapIfHigherLevel(Map<V, IndexingLevel> map, V key, IndexingLevel level) {
        IndexingLevel l = map.get(key);
        if (l == null || level.compareTo(l) > 0) {
            map.put((IndexingLevel)((Object)key), level);
        }
    }

    private void addObservedClassesInternal(Object eClassKey, IndexingLevel level) {
        NavigationHelperImpl.putIntoMapIfHigherLevel(this.allObservedClasses, eClassKey, level);
        Set<Object> subTypes = this.metaStore.getSubTypeMap().get(eClassKey);
        if (subTypes != null) {
            for (Object subType : subTypes) {
                NavigationHelperImpl.putIntoMapIfHigherLevel(this.allObservedClasses, subType, level);
            }
        }
    }

    public Map<Object, IndexingLevel> getAllObservedClassesInternal() {
        if (this.allObservedClasses == null) {
            this.allObservedClasses = new HashMap<Object, IndexingLevel>();
            for (Map.Entry<Object, IndexingLevel> entry : this.directlyObservedClasses.entrySet()) {
                Object eClassKey = entry.getKey();
                IndexingLevel level = entry.getValue();
                this.addObservedClassesInternal(eClassKey, level);
            }
        }
        return this.allObservedClasses;
    }

    Table<Object, InstanceListener, Set<EClass>> getInstanceListeners() {
        if (this.instanceListeners == null) {
            this.instanceListeners = HashBasedTable.create((int)100, (int)1);
            for (Map.Entry<InstanceListener, Set<EClass>> subscription : this.subscribedInstanceListeners.entrySet()) {
                InstanceListener listener = subscription.getKey();
                for (EClass subscriptionType : subscription.getValue()) {
                    Object superElementTypeKey = this.toKey((EClassifier)subscriptionType);
                    this.addInstanceListenerInternal(listener, subscriptionType, superElementTypeKey);
                    Set<Object> subTypeKeys = this.metaStore.getSubTypeMap().get(superElementTypeKey);
                    if (subTypeKeys == null) continue;
                    for (Object subTypeKey : subTypeKeys) {
                        this.addInstanceListenerInternal(listener, subscriptionType, subTypeKey);
                    }
                }
            }
        }
        return this.instanceListeners;
    }

    Table<Object, InstanceListener, Set<EClass>> peekInstanceListeners() {
        return this.instanceListeners;
    }

    void addInstanceListenerInternal(InstanceListener listener, EClass subscriptionType, Object elementTypeKey) {
        HashSet<EClass> subscriptionTypes = (HashSet<EClass>)this.instanceListeners.get(elementTypeKey, (Object)listener);
        if (subscriptionTypes == null) {
            subscriptionTypes = new HashSet<EClass>();
            this.instanceListeners.put(elementTypeKey, (Object)listener, subscriptionTypes);
        }
        subscriptionTypes.add(subscriptionType);
    }

    Table<Object, FeatureListener, Set<EStructuralFeature>> getFeatureListeners() {
        if (this.featureListeners == null) {
            this.featureListeners = HashBasedTable.create((int)100, (int)1);
            for (Map.Entry<FeatureListener, Set<EStructuralFeature>> subscription : this.subscribedFeatureListeners.entrySet()) {
                FeatureListener listener = subscription.getKey();
                for (EStructuralFeature subscriptionType : subscription.getValue()) {
                    Object elementTypeKey = this.toKey(subscriptionType);
                    this.addFeatureListenerInternal(listener, subscriptionType, elementTypeKey);
                }
            }
        }
        return this.featureListeners;
    }

    void addFeatureListenerInternal(FeatureListener listener, EStructuralFeature subscriptionType, Object elementTypeKey) {
        HashSet<EStructuralFeature> subscriptionTypes = (HashSet<EStructuralFeature>)this.featureListeners.get(elementTypeKey, (Object)listener);
        if (subscriptionTypes == null) {
            subscriptionTypes = new HashSet<EStructuralFeature>();
            this.featureListeners.put(elementTypeKey, (Object)listener, subscriptionTypes);
        }
        subscriptionTypes.add(subscriptionType);
    }

    Table<Object, DataTypeListener, Set<EDataType>> getDataTypeListeners() {
        if (this.dataTypeListeners == null) {
            this.dataTypeListeners = HashBasedTable.create((int)100, (int)1);
            for (Map.Entry<DataTypeListener, Set<EDataType>> subscription : this.subscribedDataTypeListeners.entrySet()) {
                DataTypeListener listener = subscription.getKey();
                for (EDataType subscriptionType : subscription.getValue()) {
                    Object elementTypeKey = this.toKey((EClassifier)subscriptionType);
                    this.addDatatypeListenerInternal(listener, subscriptionType, elementTypeKey);
                }
            }
        }
        return this.dataTypeListeners;
    }

    void addDatatypeListenerInternal(DataTypeListener listener, EDataType subscriptionType, Object elementTypeKey) {
        HashSet<EDataType> subscriptionTypes = (HashSet<EDataType>)this.dataTypeListeners.get(elementTypeKey, (Object)listener);
        if (subscriptionTypes == null) {
            subscriptionTypes = new HashSet<EDataType>();
            this.dataTypeListeners.put(elementTypeKey, (Object)listener, subscriptionTypes);
        }
        subscriptionTypes.add(subscriptionType);
    }

    @Override
    public void registerObservedTypes(Set<EClass> classes, Set<EDataType> dataTypes, Set<? extends EStructuralFeature> features) {
        this.registerObservedTypes(classes, dataTypes, features, IndexingLevel.FULL);
    }

    @Override
    public void registerObservedTypes(Set<EClass> classes, Set<EDataType> dataTypes, Set<? extends EStructuralFeature> features, final IndexingLevel level) {
        if (this.isRegistrationNecessary(level) && (classes != null || features != null || dataTypes != null)) {
            final Set<Object> resolvedFeatures = this.resolveFeaturesToKey(features);
            final Set<Object> resolvedClasses = this.resolveClassifiersToKey(classes);
            final Set<Object> resolvedDatatypes = this.resolveClassifiersToKey(dataTypes);
            try {
                this.coalesceTraversals(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        Function<Object, IndexingLevel> f = new Function<Object, IndexingLevel>(){

                            public IndexingLevel apply(Object input) {
                                return level;
                            }
                        };
                        NavigationHelperImpl.this.delayedFeatures.putAll(Maps.asMap((Set)resolvedFeatures, (Function)f));
                        NavigationHelperImpl.this.delayedDataTypes.putAll(Maps.asMap((Set)resolvedDatatypes, (Function)f));
                        NavigationHelperImpl.this.delayedClasses.putAll(Maps.asMap((Set)resolvedClasses, (Function)f));
                        return null;
                    }
                });
            }
            catch (InvocationTargetException ex) {
                this.processingFatal(ex.getCause(), "register en masse the observed EClasses " + resolvedClasses + " and EDatatypes " + resolvedDatatypes + " and EStructuralFeatures " + resolvedFeatures);
            }
            catch (Exception ex) {
                this.processingFatal(ex, "register en masse the observed EClasses " + resolvedClasses + " and EDatatypes " + resolvedDatatypes + " and EStructuralFeatures " + resolvedFeatures);
            }
        }
    }

    @Override
    public void unregisterObservedTypes(Set<EClass> classes, Set<EDataType> dataTypes, Set<? extends EStructuralFeature> features) {
        this.unregisterEClasses(classes);
        this.unregisterEDataTypes(dataTypes);
        this.unregisterEStructuralFeatures(features);
    }

    @Override
    public void registerEStructuralFeatures(Set<? extends EStructuralFeature> features, final IndexingLevel level) {
        if (this.isRegistrationNecessary(level) && features != null) {
            final Set<Object> resolved = this.resolveFeaturesToKey(features);
            try {
                this.coalesceTraversals(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        for (Object o : resolved) {
                            NavigationHelperImpl.this.delayedFeatures.put(o, level);
                        }
                        return null;
                    }
                });
            }
            catch (InvocationTargetException ex) {
                this.processingFatal(ex.getCause(), "register the observed EStructuralFeatures: " + resolved);
            }
            catch (Exception ex) {
                this.processingFatal(ex, "register the observed EStructuralFeatures: " + resolved);
            }
        }
    }

    @Override
    public void registerEStructuralFeatures(Set<? extends EStructuralFeature> features) {
        this.registerEStructuralFeatures(features, IndexingLevel.FULL);
    }

    @Override
    public void unregisterEStructuralFeatures(Set<? extends EStructuralFeature> features) {
        if (this.isRegistrationNecessary(IndexingLevel.FULL) && features != null) {
            Set<Object> resolved = this.resolveFeaturesToKey(features);
            this.ensureNoListeners(resolved, this.getFeatureListeners());
            this.observedFeatures.keySet().removeAll(resolved);
            this.delayedFeatures.keySet().removeAll(resolved);
            for (Object f : resolved) {
                this.instanceStore.getValueToFeatureToHolderMap().column(f).clear();
                if (this.instanceStore.peekFeatureToHolderMap() != null) {
                    this.instanceStore.peekFeatureToHolderMap().remove(f);
                }
                if (this.instanceStore.peekHolderToFeatureToValueMap() != null) {
                    this.instanceStore.peekHolderToFeatureToValueMap().column(f).clear();
                }
                this.statsStore.removeType(f);
            }
        }
    }

    @Override
    public void registerEClasses(Set<EClass> classes, final IndexingLevel level) {
        if (this.isRegistrationNecessary(level) && classes != null) {
            final Set<Object> resolvedClasses = this.resolveClassifiersToKey(classes);
            try {
                this.coalesceTraversals(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        for (Object o : resolvedClasses) {
                            NavigationHelperImpl.this.delayedClasses.put(o, level);
                        }
                        return null;
                    }
                });
            }
            catch (InvocationTargetException ex) {
                this.processingFatal(ex.getCause(), "register the observed EClasses: " + resolvedClasses);
            }
            catch (Exception ex) {
                this.processingFatal(ex, "register the observed EClasses: " + resolvedClasses);
            }
        }
    }

    @Override
    public void registerEClasses(Set<EClass> classes) {
        this.registerEClasses(classes, IndexingLevel.FULL);
    }

    protected void startObservingClasses(Map<Object, IndexingLevel> classObservations) {
        for (Map.Entry<Object, IndexingLevel> classObservation : classObservations.entrySet()) {
            NavigationHelperImpl.putIntoMapIfHigherLevel(this.directlyObservedClasses, classObservation.getKey(), classObservation.getValue());
            this.addObservedClassesInternal(classObservation.getKey(), classObservation.getValue());
        }
    }

    @Override
    public void unregisterEClasses(Set<EClass> classes) {
        if (this.isRegistrationNecessary(IndexingLevel.FULL) && classes != null) {
            Set<Object> resolved = this.resolveClassifiersToKey(classes);
            this.ensureNoListeners(resolved, this.getInstanceListeners());
            this.directlyObservedClasses.keySet().removeAll(resolved);
            this.allObservedClasses = null;
            this.delayedClasses.keySet().removeAll(resolved);
            for (Object c : resolved) {
                this.instanceStore.removeInstanceSet(c);
                this.statsStore.removeType(c);
            }
        }
    }

    @Override
    public void registerEDataTypes(Set<EDataType> dataTypes, final IndexingLevel level) {
        if (this.isRegistrationNecessary(level) && dataTypes != null) {
            final Set<Object> resolved = this.resolveClassifiersToKey(dataTypes);
            try {
                this.coalesceTraversals(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        for (Object o : resolved) {
                            NavigationHelperImpl.this.delayedDataTypes.put(o, level);
                        }
                        return null;
                    }
                });
            }
            catch (InvocationTargetException ex) {
                this.processingFatal(ex.getCause(), "register the observed EDataTypes: " + resolved);
            }
            catch (Exception ex) {
                this.processingFatal(ex, "register the observed EDataTypes: " + resolved);
            }
        }
    }

    @Override
    public void registerEDataTypes(Set<EDataType> dataTypes) {
        this.registerEDataTypes(dataTypes, IndexingLevel.FULL);
    }

    @Override
    public void unregisterEDataTypes(Set<EDataType> dataTypes) {
        if (this.isRegistrationNecessary(IndexingLevel.FULL) && dataTypes != null) {
            Set<Object> resolved = this.resolveClassifiersToKey(dataTypes);
            this.ensureNoListeners(resolved, this.getDataTypeListeners());
            this.observedDataTypes.keySet().removeAll(resolved);
            this.delayedDataTypes.keySet().removeAll(resolved);
            for (Object dataType : resolved) {
                this.instanceStore.removeDataTypeMap(dataType);
                this.statsStore.removeType(dataType);
            }
        }
    }

    @Override
    public boolean isCoalescing() {
        return this.delayTraversals;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <V> V coalesceTraversals(Callable<V> callable) throws InvocationTargetException {
        finalResult = null;
        if (this.delayTraversals) {
            try {
                finalResult = callable.call();
                return finalResult;
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        }
        firstRun = true;
        while (callable != null) {
            this.delayedClasses = new HashMap<Object, IndexingLevel>();
            this.delayedFeatures = new HashMap<Object, IndexingLevel>();
            this.delayedDataTypes = new HashMap<Object, IndexingLevel>();
            try {
                try {
                    this.delayTraversals = true;
                    result = callable.call();
                    if (firstRun) {
                        firstRun = false;
                        finalResult = result;
                    }
                    while (!this.delayedProxyResolutions.isEmpty()) {
                        if (!this.resolutionDelayingResources.isEmpty()) {
                        }
                        entries = this.delayedProxyResolutions.entries();
                        toResolve = (Map.Entry)entries.iterator().next();
                        entries.remove(toResolve);
                        this.comprehension.tryResolveReference((EObject)toResolve.getKey(), (EReference)toResolve.getValue());
                    }
                }
                finally {
                    this.delayTraversals = false;
                    callable = null;
                    oldClasses = this.observedFeatures.entrySet().iterator();
                    if (true) ** GOTO lbl48
                }
            }
            catch (Exception e) {
                this.notifyFatalListener("VIATRA Base encountered an error while traversing the EMF model to gather new information. ", e);
                throw new InvocationTargetException(e);
            }
            do {
                if ((requested = this.delayedFeatures.get((entry = oldClasses.next()).getKey())) == null) continue;
                old = entry.getValue();
                merged = requested.merge(old);
                if (merged == old) {
                    this.delayedFeatures.remove(entry.getKey());
                    continue;
                }
                this.delayedFeatures.put(entry.getKey(), merged);
lbl48:
                // 4 sources

            } while (oldClasses.hasNext());
            for (Map.Entry<Object, IndexingLevel> entry : this.directlyObservedClasses.entrySet()) {
                requested = this.delayedClasses.get(entry.getKey());
                if (requested == null) continue;
                old = entry.getValue();
                merged = requested.merge(old);
                if (merged == old) {
                    this.delayedClasses.remove(entry.getKey());
                    continue;
                }
                this.delayedClasses.put(entry.getKey(), merged);
            }
            for (Map.Entry<Object, IndexingLevel> entry : this.observedDataTypes.entrySet()) {
                requested = this.delayedDataTypes.get(entry.getKey());
                if (requested == null) continue;
                old = entry.getValue();
                merged = requested.merge(old);
                if (merged == old) {
                    this.delayedDataTypes.remove(entry.getKey());
                    continue;
                }
                this.delayedDataTypes.put(entry.getKey(), merged);
            }
            v0 = classesWarrantTraversal = Maps.difference(this.delayedClasses, this.getAllObservedClassesInternal()).areEqual() == false;
            if (this.delayedClasses.isEmpty() && this.delayedFeatures.isEmpty() && this.delayedDataTypes.isEmpty()) continue;
            oldClasses = new HashMap<Object, IndexingLevel>(this.directlyObservedClasses);
            this.startObservingClasses(this.delayedClasses);
            this.observedDataTypes.putAll(this.delayedDataTypes);
            this.observedFeatures.putAll(this.delayedFeatures);
            toGatherClasses = new HashMap<Object, IndexingLevel>(this.delayedClasses);
            toGatherFeatures = new HashMap<Object, IndexingLevel>(this.delayedFeatures);
            toGatherDataTypes = new HashMap<Object, IndexingLevel>(this.delayedDataTypes);
            for (Map.Entry entry : Iterables.concat(toGatherClasses.entrySet(), toGatherFeatures.entrySet(), toGatherDataTypes.entrySet())) {
                if (!((IndexingLevel)entry.getValue()).hasInstances()) continue;
                this.statsStore.removeType(entry.getKey());
            }
            if (!classesWarrantTraversal && toGatherFeatures.isEmpty() && toGatherDataTypes.isEmpty()) continue;
            visitor = new NavigationHelperVisitor.TraversingVisitor(this, toGatherFeatures, toGatherClasses, oldClasses, toGatherDataTypes);
            callable = new Callable<V>(toGatherFeatures, (NavigationHelperVisitor)visitor){
                private final /* synthetic */ Map val$toGatherFeatures;
                private final /* synthetic */ NavigationHelperVisitor val$visitor;
                {
                    this.val$toGatherFeatures = map;
                    this.val$visitor = navigationHelperVisitor;
                }

                @Override
                public V call() throws Exception {
                    NavigationHelperImpl.this.ignoreResolveNotificationFeatures.addAll(this.val$toGatherFeatures.keySet());
                    try {
                        NavigationHelperImpl.this.traverse(this.val$visitor);
                    }
                    finally {
                        NavigationHelperImpl.this.ignoreResolveNotificationFeatures.removeAll(this.val$toGatherFeatures.keySet());
                    }
                    return null;
                }
            };
        }
        this.executeTraversalCallbacks();
        return finalResult;
    }

    private void executeTraversalCallbacks() throws InvocationTargetException {
        final Runnable[] callbacks = this.traversalCallbacks.toArray(new Runnable[this.traversalCallbacks.size()]);
        this.traversalCallbacks.clear();
        if (callbacks.length > 0) {
            this.coalesceTraversals(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    Runnable[] runnableArray = callbacks;
                    int n = callbacks.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Runnable callback = runnableArray[n2];
                        callback.run();
                        ++n2;
                    }
                    return null;
                }
            });
        }
    }

    private void traverse(NavigationHelperVisitor visitor) {
        for (Notifier root : new HashSet<Notifier>(this.modelRoots)) {
            this.comprehension.traverseModel(visitor, root);
        }
        this.notifyBaseIndexChangeListeners();
    }

    @Override
    public void addRoot(Notifier emfRoot) throws ViatraBaseException {
        this.addRootInternal(emfRoot);
    }

    @Override
    public <T extends EObject> void cheapMoveTo(T element, EList<T> targetContainmentReferenceList) {
        if (element.eAdapters().contains((Object)this.contentAdapter) && targetContainmentReferenceList instanceof NotifyingList) {
            Object listNotifier = ((NotifyingList)targetContainmentReferenceList).getNotifier();
            if (listNotifier instanceof Notifier && ((Notifier)listNotifier).eAdapters().contains((Object)this.contentAdapter)) {
                this.contentAdapter.ignoreInsertionAndDeletion = element;
                try {
                    targetContainmentReferenceList.add(element);
                }
                finally {
                    this.contentAdapter.ignoreInsertionAndDeletion = null;
                }
            } else {
                targetContainmentReferenceList.add(element);
            }
        } else {
            targetContainmentReferenceList.add(element);
        }
    }

    @Override
    public void cheapMoveTo(EObject element, EObject parent, EReference containmentFeature) {
        this.metaStore.maintainMetamodel((EStructuralFeature)containmentFeature);
        if (containmentFeature.isMany()) {
            this.cheapMoveTo(element, (EList)parent.eGet((EStructuralFeature)containmentFeature));
        } else if (element.eAdapters().contains((Object)this.contentAdapter) && parent.eAdapters().contains((Object)this.contentAdapter)) {
            this.contentAdapter.ignoreInsertionAndDeletion = element;
            try {
                parent.eSet((EStructuralFeature)containmentFeature, (Object)element);
            }
            finally {
                this.contentAdapter.ignoreInsertionAndDeletion = null;
            }
        } else {
            parent.eSet((EStructuralFeature)containmentFeature, (Object)element);
        }
    }

    private void addRootInternal(Notifier emfRoot) throws ViatraBaseException {
        if (!(emfRoot instanceof EObject || emfRoot instanceof Resource || emfRoot instanceof ResourceSet)) {
            throw new ViatraBaseException("Emf navigation helper can only be attached on the contents of an EMF EObject, Resource, or ResourceSet.");
        }
        this.expandToAdditionalRoot(emfRoot);
    }

    @Override
    public Set<EClass> getAllCurrentClasses() {
        return this.instanceStore.getAllCurrentClasses();
    }

    private boolean isRegistrationNecessary(IndexingLevel level) {
        boolean inWildcardMode = this.isInWildcardMode(level);
        if (inWildcardMode && !this.loggedRegistrationMessage) {
            this.loggedRegistrationMessage = true;
            this.logger.warn((Object)"Type registration/unregistration not required in wildcard mode. This message will not be repeated for future occurences.");
        }
        return !inWildcardMode;
    }

    private <X, Y> void ensureNoListeners(Set<Object> unobservedTypes, Table<Object, X, Set<Y>> listenerRegistry) {
        if (!Collections.disjoint(unobservedTypes, listenerRegistry.rowKeySet())) {
            throw new IllegalStateException("Cannot unregister observed types for which there are active listeners");
        }
    }

    private void ensureNoListenersForDispose() {
        if (!(this.baseIndexChangeListeners.isEmpty() && this.subscribedFeatureListeners.isEmpty() && this.subscribedDataTypeListeners.isEmpty() && this.subscribedInstanceListeners.isEmpty())) {
            throw new IllegalStateException("Cannot dispose while there are active listeners");
        }
    }

    @Override
    public void resampleDerivedFeatures() {
        if (!this.baseIndexOptions.isTraverseOnlyWellBehavingDerivedFeatures()) {
            Set<EClass> allCurrentClasses = this.instanceStore.getAllCurrentClasses();
            HashSet featuresToSample = Sets.newHashSet();
            for (EClass cls : allCurrentClasses) {
                EList features = cls.getEAllStructuralFeatures();
                for (EStructuralFeature f : features) {
                    if (!this.comprehension.onlySamplingFeature(f)) continue;
                    featuresToSample.add(f);
                }
            }
            final EMFVisitor removalVisitor = this.contentAdapter.getVisitorForChange(false);
            final EMFVisitor insertionVisitor = this.contentAdapter.getVisitorForChange(true);
            for (final EStructuralFeature f : featuresToSample) {
                EClass containingClass = f.getEContainingClass();
                this.processAllInstances(containingClass, new IEClassifierProcessor.IEClassProcessor(){

                    @Override
                    public void process(EClass type, EObject instance) {
                        NavigationHelperImpl.this.resampleFeatureValueForHolder(instance, f, insertionVisitor, removalVisitor);
                    }
                });
            }
            this.notifyBaseIndexChangeListeners();
        }
    }

    protected void resampleFeatureValueForHolder(EObject source, EStructuralFeature feature, EMFVisitor insertionVisitor, EMFVisitor removalVisitor) {
        Object newValue = source.eGet(feature);
        Set<Object> oldValues = this.instanceStore.getOldValuesForHolderAndFeature(source, feature);
        if (feature.isMany()) {
            this.resampleManyFeatureValueForHolder(source, feature, newValue, oldValues, insertionVisitor, removalVisitor);
        } else {
            this.resampleSingleFeatureValueForHolder(source, feature, newValue, oldValues, insertionVisitor, removalVisitor);
        }
    }

    private void resampleManyFeatureValueForHolder(EObject source, EStructuralFeature feature, Object newValue, Set<Object> oldValues, EMFVisitor insertionVisitor, EMFVisitor removalVisitor) {
        InternalEObject internalEObject = (InternalEObject)source;
        Collection newValues = (Collection)newValue;
        HashSet newValueSet = new HashSet(newValues);
        newValueSet.removeAll(oldValues);
        oldValues.removeAll(newValues);
        if (!oldValues.isEmpty()) {
            for (Object ov : oldValues) {
                this.comprehension.traverseFeature(removalVisitor, source, feature, ov, null);
            }
            ENotificationImpl removeNotification = new ENotificationImpl(internalEObject, 6, feature, oldValues, null);
            this.notifyLightweightObservers(source, feature, (Notification)removeNotification);
        }
        if (!newValueSet.isEmpty()) {
            for (Object nv : newValueSet) {
                this.comprehension.traverseFeature(insertionVisitor, source, feature, nv, null);
            }
            ENotificationImpl addNotification = new ENotificationImpl(internalEObject, 5, feature, null, newValueSet);
            this.notifyLightweightObservers(source, feature, (Notification)addNotification);
        }
    }

    private void resampleSingleFeatureValueForHolder(EObject source, EStructuralFeature feature, Object newValue, Set<Object> oldValues, EMFVisitor insertionVisitor, EMFVisitor removalVisitor) {
        InternalEObject internalEObject = (InternalEObject)source;
        Object oldValue = Iterables.getFirst(oldValues, null);
        if (!Objects.equal((Object)oldValue, (Object)newValue)) {
            this.comprehension.traverseFeature(removalVisitor, source, feature, oldValue, null);
            this.comprehension.traverseFeature(insertionVisitor, source, feature, newValue, null);
            ENotificationImpl notification = new ENotificationImpl(internalEObject, 1, feature, oldValue, newValue);
            this.notifyLightweightObservers(source, feature, (Notification)notification);
        }
    }

    @Override
    public int countAllInstances(EClass type) {
        int result = 0;
        Object typeKey = this.toKey((EClassifier)type);
        Set<Object> subTypes = this.metaStore.getSubTypeMap().get(typeKey);
        if (subTypes != null) {
            for (Object subTypeKey : subTypes) {
                result += this.statsStore.countInstances(subTypeKey);
            }
        }
        return result += this.statsStore.countInstances(typeKey);
    }

    @Override
    public int countDataTypeInstances(EDataType dataType) {
        return this.statsStore.countInstances(this.toKey((EClassifier)dataType));
    }

    @Override
    public int countFeatureTargets(EObject seedSource, EStructuralFeature feature) {
        return ((Set)this.instanceStore.getHolderToFeatureToValueMap().get((Object)seedSource, this.toKey(feature))).size();
    }

    @Override
    public int countFeatures(EStructuralFeature feature) {
        return this.statsStore.countFeatures(this.toKey(feature));
    }

    @Override
    public IndexingLevel getIndexingLevel(EClass type) {
        Object key = this.toKey((EClassifier)type);
        IndexingLevel level = this.directlyObservedClasses.get(key);
        if (level == null) {
            level = this.delayedClasses.get(key);
        }
        return this.wildcardMode.merge(level);
    }

    @Override
    public IndexingLevel getIndexingLevel(EDataType type) {
        Object key = this.toKey((EClassifier)type);
        IndexingLevel level = this.observedDataTypes.get(key);
        if (level == null) {
            level = this.delayedDataTypes.get(key);
        }
        return this.wildcardMode.merge(level);
    }

    @Override
    public IndexingLevel getIndexingLevel(EStructuralFeature feature) {
        Object key = this.toKey(feature);
        IndexingLevel level = this.observedFeatures.get(key);
        if (level == null) {
            level = this.delayedFeatures.get(key);
        }
        return this.wildcardMode.merge(level);
    }

    @Override
    public void executeAfterTraversal(final Runnable traversalCallback) throws InvocationTargetException {
        this.coalesceTraversals(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                NavigationHelperImpl.this.traversalCallbacks.add(traversalCallback);
                return null;
            }
        });
    }
}

