/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.internal.validation;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.validation.ValidationFramework;
import org.eclipse.wst.validation.Validator;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.ui.internal.validation.DelegatingSourceValidator;
import org.eclipse.wst.xsl.ui.internal.editor.XSLEditor;

public class DelegatingSourceValidatorForXSL
extends DelegatingSourceValidator {
    private static final String XSL_UI_XSL_EDITOR_ID = "org.eclipse.wst.xsl.ui.XSLEditor";
    private static final String Id = "org.eclipse.wst.xsl.core.xsl";
    private final String QUICKASSISTPROCESSOR = IQuickAssistProcessor.class.getName();
    private Validator _validator;

    protected void updateValidationMessages(List messages, IDOMDocument document, IReporter reporter) {
        super.updateValidationMessages(messages, document, reporter);
    }

    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
        super.validate(helper, reporter);
        String[] delta = helper.getURIs();
        if (delta.length > 0) {
            IWorkbenchWindow[] windows;
            IFile file = this.getFile(delta[0]);
            IWorkbenchWindow[] iWorkbenchWindowArray = windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            int n = windows.length;
            int n2 = 0;
            while (n2 < n) {
                XSLEditor editor;
                IEditorReference[] refs;
                IWorkbenchWindow workbenchWindow = iWorkbenchWindowArray[n2];
                IWorkbenchPage page = workbenchWindow.getActivePage();
                if (page != null && (refs = page.findEditors((IEditorInput)new FileEditorInput(file), XSL_UI_XSL_EDITOR_ID, 3)).length == 1 && (editor = (XSLEditor)refs[0].getEditor(false)) != null) {
                    editor.getOverrideIndicatorManager().updateAnnotations();
                }
                ++n2;
            }
        }
    }

    private Validator getValidator() {
        if (this._validator == null) {
            this._validator = ValidationFramework.getDefault().getValidator(Id, null);
        }
        return this._validator;
    }

    protected IValidator getDelegateValidator() {
        Validator v = this.getValidator();
        if (v == null) {
            return null;
        }
        return v.asIValidator();
    }
}

